/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;
import tanukidecor.block.TallBlock;
import tanukidecor.block.misc.PlasmaBallBlock;
import tanukidecor.util.Gradient;

public class PlasmaBallBlockEntity
extends BlockEntity {
    private final List<Arc> arcs = new ArrayList<Arc>();
    private static final Gradient ARC_COLORS = new Gradient.Builder(-570425345).with(0.36f, -814698753).with(0.92f, -37416).build();

    public PlasmaBallBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, PlasmaBallBlockEntity blockEntity) {
        if (blockState.m_61143_(TallBlock.HALF) != DoubleBlockHalf.UPPER || !((Boolean)blockState.m_61143_((Property)PlasmaBallBlock.ENABLED)).booleanValue()) {
            return;
        }
        Collection<Arc> arcsView = Collections.unmodifiableCollection(blockEntity.getArcs());
        for (Arc arc : arcsView) {
            arc.update(blockEntity, arcsView, level.m_213780_());
        }
        for (Arc arc : arcsView) {
            arc.move(blockEntity, level.m_213780_());
        }
    }

    public List<Arc> getArcs() {
        if (this.arcs.isEmpty() && this.m_58904_() != null) {
            this.arcs.addAll(this.createArcs(12, ARC_COLORS, this.m_58904_().m_213780_()));
        }
        return this.arcs;
    }

    protected List<Arc> createArcs(int count, Gradient colors, RandomSource random) {
        ArrayList<Arc> list = new ArrayList<Arc>(count);
        for (int i = 0; i < count; ++i) {
            list.add(new Arc(colors, random));
        }
        return list;
    }

    public static class Arc {
        private static final float MAX_POSITION = 1.0f;
        private static final float MAX_QUADRATIC_TERM = 1.0f;
        private static final float MAX_DELTA_POSITION = 0.028f;
        private static final float MAX_DELTA_QUADRATIC_TERM = 0.04f;
        private Vector3f position;
        private Vector3f deltaPosition;
        private Vector3f quadraticTerm;
        private Vector3f deltaQuadraticTerm;
        private Gradient color;

        public Arc(Gradient color, RandomSource random) {
            this.color = color;
            this.position = new Vector3f();
            this.deltaPosition = new Vector3f();
            this.quadraticTerm = new Vector3f();
            this.deltaQuadraticTerm = new Vector3f();
            Arc.setRandomFloats(this.position, random, 0.0f, 1.0f);
            Arc.setRandomFloats(this.deltaPosition, random, -0.028f, 0.028f);
            Arc.setRandomFloats(this.quadraticTerm, random, -1.0f, 1.0f);
            Arc.setRandomFloats(this.deltaQuadraticTerm, random, -0.04f, 0.04f);
        }

        public void update(BlockEntity blockEntity, Collection<Arc> arcs, RandomSource random) {
            int edges = 0;
            if (this.position.x() * this.position.x() > 0.95f) {
                ++edges;
            }
            if (this.position.y() * this.position.y() > 0.95f) {
                ++edges;
            }
            if (this.position.z() * this.position.z() > 0.95f) {
                ++edges;
            }
            if (random.m_188501_() < 0.01f + (float)edges * 0.005f) {
                Arc.setRandomFloats(this.deltaPosition, random, -0.028f, 0.028f);
            }
            if (random.m_188501_() < 0.004f + (float)edges * 0.003f) {
                Arc.setRandomFloats(this.deltaQuadraticTerm, random, -0.04f, 0.04f);
            }
            if (random.m_188501_() < 0.01f + (float)edges * 0.009f) {
                Arc.setRandomFloats(this.quadraticTerm, random, -1.0f, 1.0f);
            }
            if (random.m_188501_() < 0.003f + (float)edges * 0.04f) {
                Arc.setRandomFloats(this.position, random, 0.0f, 1.0f);
            }
            Vec3 pos = new Vec3(this.getEndPosition());
            for (Arc other : arcs) {
                Vec3 otherVec;
                if (other == this || !pos.m_82509_((Position)(otherVec = new Vec3(other.getEndPosition())), 0.125)) continue;
                Arc.setRandomFloats(this.position, random, 0.0f, 1.0f);
                break;
            }
        }

        public void move(BlockEntity blockEntity, RandomSource random) {
            this.position.set(Mth.m_14036_((float)(this.position.x() + this.deltaPosition.x()), (float)-0.5f, (float)0.5f), Mth.m_14036_((float)(this.position.y() + this.deltaPosition.y()), (float)-0.5f, (float)0.5f), Mth.m_14036_((float)(this.position.z() + this.deltaPosition.z()), (float)-0.5f, (float)0.5f));
            this.quadraticTerm.set(Mth.m_14036_((float)(this.quadraticTerm.x() + this.deltaQuadraticTerm.x()), (float)-0.6f, (float)0.6f), Mth.m_14036_((float)(this.quadraticTerm.y() + this.deltaQuadraticTerm.y()), (float)-0.6f, (float)0.6f), Mth.m_14036_((float)(this.quadraticTerm.z() + this.deltaQuadraticTerm.z()), (float)-0.6f, (float)0.6f));
        }

        public Vector3f getEndPosition() {
            return this.position;
        }

        public Vector3f getPosition(float percent, long time, float partialTick) {
            Vector3f endPos = this.getEndPosition();
            float x = percent * Mth.m_14179_((float)(this.deltaPosition.x() * partialTick), (float)(endPos.x() - this.deltaPosition.x()), (float)endPos.x());
            float y = percent * Mth.m_14179_((float)(this.deltaPosition.y() * partialTick), (float)(endPos.y() - this.deltaPosition.y()), (float)endPos.y());
            float z = percent * Mth.m_14179_((float)(this.deltaPosition.z() * partialTick), (float)(endPos.z() - this.deltaPosition.z()), (float)endPos.z());
            float timeFactor = (float)Math.PI * (((float)time + partialTick) / 40.0f);
            float noise = this.noiseFactor((float)time / 15.0f, percent);
            return new Vector3f(x += this.quadraticTerm.x() * noise, y += this.quadraticTerm.y() * noise, z += this.quadraticTerm.z() * noise);
        }

        private float noiseFactor(float time, float percent) {
            return 0.019f * Mth.m_14031_((float)(percent * time * 8.4f));
        }

        public Vector4f getColor(float percent) {
            return this.color.getColor(percent);
        }

        protected static void setRandomFloats(Vector3f vec, RandomSource random, float min, float max) {
            float range = max - min;
            float x = min + random.m_188501_() * range;
            float y = min + random.m_188501_() * range;
            float z = min + random.m_188501_() * range;
            vec.set(x, y, z);
        }
    }
}

