/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.screens;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.buttons.MenuButton;
import club.iananderson.seasonhud.client.gui.screens.ColorScreen;
import club.iananderson.seasonhud.client.gui.screens.SeasonHudScreen;
import club.iananderson.seasonhud.client.gui.screens.SeasonOptionsScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import club.iananderson.seasonhud.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class MainConfigScreen
extends SeasonHudScreen {
    private static final Component SCREEN_TITLE = Common.translatedText("menu.seasonhud.main.title");
    private static final Component MINIMAP_SETTINGS = Common.translatedText("menu.seasonhud.main.minimap.options");
    private static final Component JOURNEYMAP = Common.translatedText("menu.seasonhud.main.journeymap.title");
    private final List<AbstractWidget> optionButtons = new ArrayList<AbstractWidget>();
    MenuButton seasonButton;
    MenuButton colorButton;
    CycleButton<Boolean> enableMinimapIntegrationButton;
    CycleButton<Boolean> showMinimapHiddenButton;
    CycleButton<Boolean> journeyMapAboveMapButton;
    CycleButton<Boolean> journeyMapMacOSButton;
    private boolean enableMod;
    private boolean showMinimapHidden;
    private boolean enableMinimapIntegration;
    private boolean journeyMapAboveMap;
    private boolean journeyMapMacOS;

    public MainConfigScreen() {
        super(null, SCREEN_TITLE);
        this.loadConfig();
        this.BUTTON_WIDTH = 170;
    }

    public static MainConfigScreen getInstance() {
        return new MainConfigScreen();
    }

    public void loadConfig() {
        this.enableMod = SeasonHudClient.getEnableMod();
        this.showMinimapHidden = SeasonHudClient.getShowDefaultWhenMinimapHidden();
        this.enableMinimapIntegration = SeasonHudClient.getEnableMinimapIntegration();
        if (CurrentMinimap.journeyMapLoaded()) {
            this.journeyMapAboveMap = SeasonHudClient.getJourneyMapAboveMap();
            this.journeyMapMacOS = SeasonHudClient.getJourneyMapMacOS();
        }
    }

    @Override
    public void saveConfig() {
        SeasonHudClient.setEnableMod(this.enableMod);
        SeasonHudClient.setEnableMinimapIntegration(this.enableMinimapIntegration);
        SeasonHudClient.setShowDefaultWhenMinimapHidden(this.showMinimapHidden);
        if (CurrentMinimap.journeyMapLoaded()) {
            SeasonHudClient.setJourneyMapAboveMap(this.journeyMapAboveMap);
            SeasonHudClient.setJourneyMapMacOS(this.journeyMapMacOS);
        }
    }

    @Override
    public void onDone() {
        this.saveConfig();
        super.onDone();
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        int n = this.f_96543_ / 2;
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280653_(this.f_96547_, MINIMAP_SETTINGS, n, 50 + 2 * (this.BUTTON_HEIGHT + 6) - (9 + 6), 0xFFFFFF);
        if (Services.PLATFORM.isModLoaded("journeymap")) {
            int n2 = this.f_96543_ / 2;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280653_(this.f_96547_, JOURNEYMAP, n2, 50 + 4 * (this.BUTTON_HEIGHT + 6) - (9 + 6), 0xFFFFFF);
            this.journeyMapAboveMapButton.f_93623_ = this.enableMod;
            this.journeyMapMacOSButton.f_93623_ = this.enableMod;
        }
        this.seasonButton.f_93623_ = this.enableMod;
        this.colorButton.f_93623_ = this.enableMod;
        this.enableMinimapIntegrationButton.f_93623_ = this.enableMod;
        this.showMinimapHiddenButton.f_93623_ = this.enableMod;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int enableModWidth = this.f_96547_.m_92852_((FormattedText)Common.translatedText("menu.seasonhud.main.enableMod.button").m_130946_(": OFF")) + 8;
        CycleButton enableModButton = CycleButton.m_168916_((boolean)this.enableMod).m_232498_(t -> Common.newTooltip("menu.seasonhud.main.enableMod.tooltip")).m_168936_(this.f_96543_ - enableModWidth - 5, 5, enableModWidth, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.main.enableMod.button"), (b, val) -> {
            this.enableMod = val;
        });
        int row = 0;
        this.seasonButton = MenuButton.builder(MenuButton.MenuButtons.SEASON, b -> {
            this.saveConfig();
            SeasonOptionsScreen.getInstance(this).open();
        }).withTooltip(Common.newTooltip("menu.seasonhud.main.season.tooltip")).withPos(this.leftButtonX, this.buttonStartY + row * this.yOffset).withWidth(this.BUTTON_WIDTH).build();
        this.colorButton = MenuButton.builder(MenuButton.MenuButtons.COLORS, b -> {
            this.saveConfig();
            ColorScreen.getInstance(this).open();
        }).withTooltip(Common.newTooltip("menu.seasonhud.main.color.tooltip")).withPos(this.rightButtonX, this.buttonStartY + row * this.yOffset).withWidth(this.BUTTON_WIDTH).build();
        row = 2;
        this.enableMinimapIntegrationButton = CycleButton.m_168916_((boolean)this.enableMinimapIntegration).m_232498_(t -> Common.newTooltip("menu.seasonhud.main.minimapIntegration.tooltip")).m_168936_(this.leftButtonX, this.buttonStartY + row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.main.enableMinimapIntegration.button"), (b, val) -> {
            this.enableMinimapIntegration = val;
        });
        this.showMinimapHiddenButton = CycleButton.m_168916_((boolean)this.showMinimapHidden).m_232498_(t -> Common.newTooltip("menu.seasonhud.main.showMinimapHidden.tooltip")).m_168936_(this.rightButtonX, this.buttonStartY + row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.main.showMinimapHidden.button"), (b, val) -> {
            this.showMinimapHidden = val;
        });
        this.widgets.addAll(Arrays.asList(new AbstractButton[]{this.seasonButton, this.colorButton, enableModButton, this.enableMinimapIntegrationButton, this.showMinimapHiddenButton}));
        if (Services.PLATFORM.isModLoaded("journeymap")) {
            this.journeyMapAboveMapButton = CycleButton.m_168916_((boolean)this.journeyMapAboveMap).m_232498_(t -> Common.newTooltip("menu.seasonhud.main.journeymap.aboveMap.tooltip")).m_168936_(this.leftButtonX, this.buttonStartY + (row += 2) * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.main.journeymap.aboveMap.button"), (b, val) -> {
                this.journeyMapAboveMap = val;
            });
            this.journeyMapMacOSButton = CycleButton.m_168916_((boolean)this.journeyMapMacOS).m_232498_(t -> Common.newTooltip("menu.seasonhud.main.journeymap.macOS.tooltip")).m_168936_(this.rightButtonX, this.buttonStartY + row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.main.journeymap.macOS.button"), (b, val) -> {
                this.journeyMapMacOS = val;
            });
            this.widgets.add(this.journeyMapAboveMapButton);
            this.widgets.add(this.journeyMapMacOSButton);
        }
        this.widgets.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }
}

