/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.coroutil.util.CULog;
import com.corosus.watut.FakePlayerHelper;
import com.corosus.watut.InventorySnapshot;
import com.corosus.watut.PlayerStatus;
import com.corosus.watut.PlayerStatusManager;
import com.corosus.watut.WatutMod;
import com.corosus.watut.WatutNetworking;
import com.corosus.watut.config.ConfigCommon;
import com.corosus.watut.config.ConfigServerControlledSyncedToClient;
import com.corosus.watut.config.ConfigServerSyncHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PlayerStatusManagerServer
extends PlayerStatusManager {
    @Override
    public void tickPlayer(Player player) {
        this.getStatus(player).setTicksToMarkPlayerIdleSyncedForClient(ConfigCommon.ticksToMarkPlayerIdle);
        super.tickPlayer(player);
    }

    public void receiveAny(Player player, CompoundTag data) {
        data.m_128359_(WatutNetworking.NBTDataPlayerUUID, player.m_20148_().toString());
        if (data.m_128441_(WatutNetworking.NBTDataPlayerGuiStatus)) {
            PlayerStatus.PlayerGuiState playerGuiState = PlayerStatus.PlayerGuiState.get(data.m_128451_(WatutNetworking.NBTDataPlayerGuiStatus));
            this.getStatus(player).setPlayerGuiState(playerGuiState);
        }
        if (data.m_128441_(WatutNetworking.NBTDataPlayerChatStatus)) {
            PlayerStatus.PlayerChatState state = PlayerStatus.PlayerChatState.get(data.m_128451_(WatutNetworking.NBTDataPlayerChatStatus));
            this.getStatus(player).setPlayerChatState(state);
        }
        if (data.m_128441_(WatutNetworking.NBTDataPlayerIdleTicks)) {
            this.handleIdleState(player, data.m_128451_(WatutNetworking.NBTDataPlayerIdleTicks));
            data.m_128405_(WatutNetworking.NBTDataPlayerTicksToGoIdle, ConfigCommon.ticksToMarkPlayerIdle);
        }
        if (data.m_128441_(WatutNetworking.NBTDataPlayerMouseX)) {
            float x = data.m_128457_(WatutNetworking.NBTDataPlayerMouseX);
            float y = data.m_128457_(WatutNetworking.NBTDataPlayerMouseY);
            boolean pressed = data.m_128471_(WatutNetworking.NBTDataPlayerMousePressed);
            this.setMouse(player.m_20148_(), x, y, pressed);
        }
        this.getStatus(player).getNbtCache().m_128391_(data);
        if (data.m_128441_(WatutNetworking.NBTDataPlayerGuiStatus) || data.m_128441_(WatutNetworking.NBTDataPlayerIdleTicks) || data.m_128441_(WatutNetworking.NBTDataPlayerChatStatus)) {
            WatutNetworking.instance().serverSendToClientAll(data);
        } else {
            WatutNetworking.instance().serverSendToClientNear(data, player.m_20182_(), ConfigServerControlledSyncedToClient.distanceRequiredToShowGUIInfo, player.m_9236_());
        }
    }

    public void handleIdleState(Player player, int idleTicks) {
        if (WatutMod.instance().getPlayerList() == null) {
            return;
        }
        PlayerStatus status = this.getStatus(player);
        if (WatutMod.instance().getPlayerList().m_11309_() > 1 || this.singleplayerTesting) {
            if (idleTicks > ConfigCommon.ticksToMarkPlayerIdle) {
                if (!status.isIdle()) {
                    this.broadcast(player.m_5446_().getString() + " has gone idle");
                }
            } else if (status.isIdle()) {
                this.broadcast(player.m_5446_().getString() + " is no longer idle");
            }
        }
        status.setTicksSinceLastAction(idleTicks);
    }

    public void broadcast(String msg) {
        if (WatutMod.instance().getPlayerList() == null) {
            return;
        }
        if (ConfigCommon.announceIdleStatesInChat) {
            WatutMod.instance().getPlayerList().m_240416_((Component)Component.m_237113_((String)msg), false);
        }
    }

    @Override
    public void playerLoggedIn(Player player) {
        super.playerLoggedIn(player);
        WatutMod.dbg("player logged in " + player.m_7755_());
        if (player instanceof ServerPlayer) {
            for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
                WatutMod.dbg("sending update all packet for " + ((UUID)entry.getKey()).toString() + " to " + player.m_5446_().getString() + " with status " + PlayerStatus.PlayerGuiState.get(((PlayerStatus)entry.getValue()).getNbtCache().m_128451_(WatutNetworking.NBTDataPlayerGuiStatus)));
                WatutNetworking.instance().serverSendToClientPlayer(((PlayerStatus)entry.getValue()).getNbtCache(), player);
            }
            CULog.dbg((String)("sending server config sync to " + player.m_7755_()));
            WatutNetworking.instance().serverSendToClientPlayer(this.getServerConfigNBT(), player);
        }
    }

    public void syncServerConfigToAllPlayers() {
        if (WatutMod.instance().getPlayerList() == null) {
            return;
        }
        for (ServerPlayer serverPlayer : WatutMod.instance().getPlayerList().m_11314_()) {
            CULog.dbg((String)("sending server config sync to " + serverPlayer.m_7755_()));
            WatutNetworking.instance().serverSendToClientPlayer(this.getServerConfigNBT(), (Player)serverPlayer);
        }
    }

    public CompoundTag getServerConfigNBT() {
        CompoundTag nbt = ConfigServerSyncHelper.getInstance().getSyncableConfigOnServer();
        nbt.m_128379_(WatutNetworking.NBTDataServerConfig, true);
        return nbt;
    }

    public void sendItemMove(Player player, Level level, ItemStack itemStack, double fromX, double fromY, double fromZ, double toX, double toY, double toZ) {
        this.sendItemMove(player, level, itemStack, (float)fromX, (float)fromY, (float)fromZ, (float)toX, (float)toY, (float)toZ);
    }

    public void sendItemMove(Player player, Level level, ItemStack itemStack, float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        if (level.m_5788_((double)fromX, (double)fromY, (double)fromZ, (double)ConfigServerControlledSyncedToClient.distanceRequiredToShowGUIInfo, entity -> entity != player) != null) {
            CompoundTag data = new CompoundTag();
            data.m_128365_(WatutNetworking.NBTDataItemTransferItemStack, (Tag)itemStack.m_41739_(new CompoundTag()));
            data.m_128350_(WatutNetworking.NBTDataItemTransferFromX, fromX);
            data.m_128350_(WatutNetworking.NBTDataItemTransferFromY, fromY);
            data.m_128350_(WatutNetworking.NBTDataItemTransferFromZ, fromZ);
            data.m_128350_(WatutNetworking.NBTDataItemTransferToX, toX);
            data.m_128350_(WatutNetworking.NBTDataItemTransferToY, toY);
            data.m_128350_(WatutNetworking.NBTDataItemTransferToZ, toZ);
            WatutNetworking.instance().serverSendToClientNear(data, new Vec3((double)fromX, (double)fromY, (double)fromZ), ConfigServerControlledSyncedToClient.distanceRequiredToShowGUIInfo, level);
        }
    }

    public void makeNewInventorySnapshot(AbstractContainerMenu abstractContainerMenu, Player player) {
        PlayerStatus playerStatus = this.getStatus(player);
        playerStatus.getInventorySnapshotPlayer().itemStackList.clear();
        playerStatus.getInventorySnapshotContainer().itemStackList.clear();
        playerStatus.getInventorySnapshotCarried().itemStackList.clear();
        for (ItemStack item : player.m_150109_().f_35974_) {
            playerStatus.getInventorySnapshotPlayer().itemStackList.add(item.m_41777_());
        }
        for (Slot slot : abstractContainerMenu.f_38839_) {
            if (slot.f_40218_ instanceof Inventory) continue;
            playerStatus.getInventorySnapshotContainer().itemStackList.add(slot.m_7993_().m_41777_());
        }
        if (!abstractContainerMenu.m_142621_().m_41619_()) {
            playerStatus.getInventorySnapshotCarried().itemStackList.add(abstractContainerMenu.m_142621_().m_41777_());
        }
    }

    public void doClickPre(AbstractContainerMenu abstractContainerMenu, int pSlotId, int pButton, ClickType pClickType, Player player) {
        if (!ConfigServerControlledSyncedToClient.showItemsBeingTransferredBetweenPlayerAndContainer) {
            return;
        }
        if (FakePlayerHelper.isFakePlayer(player)) {
            return;
        }
        PlayerStatus playerStatus = this.getStatus(player);
        if (playerStatus.isPlayerGuiDontSendItemInfo()) {
            return;
        }
        if (playerStatus.getLastBlockOpened().equals((Object)BlockPos.f_121853_)) {
            return;
        }
        this.makeNewInventorySnapshot(abstractContainerMenu, player);
    }

    public void useBlock(Player player, BlockPos pos) {
        if (!ConfigServerControlledSyncedToClient.showItemsBeingTransferredBetweenPlayerAndContainer) {
            return;
        }
        if (FakePlayerHelper.isFakePlayer(player)) {
            return;
        }
        PlayerStatus playerStatus = this.getStatus(player);
        if (playerStatus.isPlayerGuiDontSendItemInfo()) {
            return;
        }
        playerStatus.setLastBlockOpened(pos);
    }

    public void doClickPost(AbstractContainerMenu abstractContainerMenu, int pSlotId, int pButton, ClickType pClickType, Player player) {
        block17: {
            List containerRemovedItems;
            List containerAddedItems;
            List playerRemovedItems;
            List playerAddedItems;
            block16: {
                if (!ConfigServerControlledSyncedToClient.showItemsBeingTransferredBetweenPlayerAndContainer) {
                    return;
                }
                if (FakePlayerHelper.isFakePlayer(player)) {
                    return;
                }
                PlayerStatus playerStatus = this.getStatus(player);
                if (playerStatus.isPlayerGuiDontSendItemInfo()) {
                    return;
                }
                if (playerStatus.getLastBlockOpened().equals((Object)BlockPos.f_121853_)) {
                    return;
                }
                InventorySnapshot inventorySnapshotPlayerPost = new InventorySnapshot();
                InventorySnapshot inventorySnapshotContainerPost = new InventorySnapshot();
                InventorySnapshot inventorySnapshotCarriedPost = new InventorySnapshot();
                for (ItemStack item : player.m_150109_().f_35974_) {
                    inventorySnapshotPlayerPost.itemStackList.add(item.m_41777_());
                }
                for (Slot slot : abstractContainerMenu.f_38839_) {
                    if (slot.f_40218_ instanceof Inventory) continue;
                    inventorySnapshotContainerPost.itemStackList.add(slot.m_7993_().m_41777_());
                }
                if (!abstractContainerMenu.m_142621_().m_41619_()) {
                    inventorySnapshotCarriedPost.itemStackList.add(abstractContainerMenu.m_142621_().m_41777_());
                }
                Pair<List<ItemStack>, List<ItemStack>> listsPlayer = this.processInventorySnapshots(playerStatus.getInventorySnapshotPlayer().itemStackList, inventorySnapshotPlayerPost.itemStackList);
                playerAddedItems = (List)listsPlayer.getFirst();
                playerRemovedItems = (List)listsPlayer.getSecond();
                Pair<List<ItemStack>, List<ItemStack>> listsContainer = this.processInventorySnapshots(playerStatus.getInventorySnapshotContainer().itemStackList, inventorySnapshotContainerPost.itemStackList);
                containerAddedItems = (List)listsContainer.getFirst();
                containerRemovedItems = (List)listsContainer.getSecond();
                if (pClickType != ClickType.PICKUP) break block16;
                if (!abstractContainerMenu.m_142621_().m_41619_() && playerAddedItems.size() == 0 && containerAddedItems.size() == 0) {
                    ItemStack itemStackCarriedMatch = this.getMatchingItem(abstractContainerMenu.m_142621_(), playerRemovedItems);
                    if (itemStackCarriedMatch != null) {
                        playerStatus.setCarriedItemFromPlayerInventory(true);
                    } else {
                        itemStackCarriedMatch = this.getMatchingItem(abstractContainerMenu.m_142621_(), containerRemovedItems);
                        if (itemStackCarriedMatch != null) {
                            playerStatus.setCarriedItemFromPlayerInventory(false);
                        }
                    }
                }
                if (playerStatus.getInventorySnapshotCarried().itemStackList.size() <= 0) break block17;
                ItemStack prevCarried = playerStatus.getInventorySnapshotCarried().itemStackList.get(0);
                for (ItemStack itemStackAdded : playerAddedItems) {
                    if (!ItemStack.m_41656_((ItemStack)prevCarried, (ItemStack)itemStackAdded) || playerStatus.isCarriedItemFromPlayerInventory()) continue;
                    this.sendItemMove(player, itemStackAdded, false);
                }
                for (ItemStack itemStackAdded : containerAddedItems) {
                    if (!ItemStack.m_41656_((ItemStack)prevCarried, (ItemStack)itemStackAdded) || !playerStatus.isCarriedItemFromPlayerInventory()) continue;
                    this.sendItemMove(player, itemStackAdded, true);
                }
                break block17;
            }
            if (pClickType == ClickType.QUICK_MOVE) {
                ItemStack itemStackAdded;
                for (ItemStack itemStackRemoved : playerRemovedItems) {
                    itemStackAdded = this.getMatchingItem(itemStackRemoved, containerAddedItems);
                    if (itemStackAdded == null || itemStackAdded.m_41613_() < itemStackRemoved.m_41613_()) continue;
                    this.sendItemMove(player, itemStackAdded, true);
                }
                for (ItemStack itemStackRemoved : containerRemovedItems) {
                    itemStackAdded = this.getMatchingItem(itemStackRemoved, playerAddedItems);
                    if (itemStackAdded == null || itemStackAdded.m_41613_() < itemStackRemoved.m_41613_()) continue;
                    this.sendItemMove(player, itemStackAdded, false);
                }
            }
        }
    }

    public ItemStack getSimpleItemStack(ItemStack itemStack) {
        return new ItemStack((ItemLike)itemStack.m_41720_(), itemStack.m_41613_());
    }

    public Pair<List<ItemStack>, List<ItemStack>> processInventorySnapshots(List<ItemStack> pre, List<ItemStack> post) {
        ArrayList<ItemStack> addedItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> removedItems = new ArrayList<ItemStack>();
        for (int i = 0; i < post.size(); ++i) {
            ItemStack stack;
            ItemStack stackPost;
            ItemStack stackPre = pre.get(i);
            if (!ItemStack.m_41656_((ItemStack)stackPre, (ItemStack)(stackPost = post.get(i)))) {
                if (stackPre.m_41619_() && !stackPost.m_41619_()) {
                    addedItems.add(this.getSimpleItemStack(stackPost));
                    continue;
                }
                if (stackPre.m_41619_() || !stackPost.m_41619_()) continue;
                removedItems.add(this.getSimpleItemStack(stackPre));
                continue;
            }
            if (stackPre.m_41613_() > stackPost.m_41613_()) {
                stack = this.getSimpleItemStack(stackPre);
                stack.m_41764_(stackPre.m_41613_() - stackPost.m_41613_());
                removedItems.add(stack);
                continue;
            }
            if (stackPre.m_41613_() >= stackPost.m_41613_()) continue;
            stack = this.getSimpleItemStack(stackPost);
            stack.m_41764_(stackPost.m_41613_() - stackPre.m_41613_());
            addedItems.add(stack);
        }
        return Pair.of(addedItems, removedItems);
    }

    public ItemStack getMatchingItem(ItemStack itemStack, List<ItemStack> itemStackList) {
        for (ItemStack itemStack1 : itemStackList) {
            if (!ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)itemStack1)) continue;
            return itemStack1;
        }
        return null;
    }

    public void sendItemMove(Player player, ItemStack itemStack, boolean toContainer) {
        PlayerStatus playerStatus = this.getStatus(player);
        BlockPos pos = playerStatus.getLastBlockOpened();
        float distFromFace = 0.55f;
        Vec3 lookVec = this.getBodyAngle(player).m_82490_((double)distFromFace);
        if (toContainer) {
            this.sendItemMove(player, player.m_9236_(), itemStack, player.m_20185_() + lookVec.f_82479_, player.m_20186_() + 1.2, player.m_20189_() + lookVec.f_82481_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.7f), (double)((float)pos.m_123343_() + 0.5f));
        } else {
            this.sendItemMove(player, player.m_9236_(), itemStack, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.7f), (double)((float)pos.m_123343_() + 0.5f), player.m_20185_() + lookVec.f_82479_, player.m_20186_() + 1.2, player.m_20189_() + lookVec.f_82481_);
        }
    }
}

