/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.stockKeeper;

import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import ru.zznty.create_factory_abstractions.api.generic.crafting.OrderProvider;
import ru.zznty.create_factory_abstractions.api.generic.crafting.RecipeRequestHelper;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKey;
import ru.zznty.create_factory_abstractions.api.generic.search.CategoriesProvider;
import ru.zznty.create_factory_abstractions.api.generic.search.GenericSearch;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.impl.GenericContentExtender;
import ru.zznty.create_factory_abstractions.generic.support.BigGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.CraftableGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;
import ru.zznty.create_factory_logistics.logistics.ingredient.ClickableIngredientProvider;
import ru.zznty.create_factory_logistics.mixin.accessor.CategoryEntryAccessor;
import ru.zznty.create_factory_logistics.mixin.accessor.StockTickerBlockEntityAccessor;

@Mixin(value={StockKeeperRequestScreen.class})
public abstract class StockKeeperRequestScreenMixin
extends AbstractSimiContainerScreen<StockKeeperRequestMenu>
implements OrderProvider,
CategoriesProvider,
ClickableIngredientProvider {
    @Shadow(remap=false)
    private InventorySummary forcedEntries;
    @Shadow(remap=false)
    public List<BigGenericStack> itemsToOrder;
    @Shadow(remap=false)
    StockTickerBlockEntity blockEntity;
    @Shadow(remap=false)
    public List<List<BigGenericStack>> currentItemSource;
    @Shadow(remap=false)
    public List<CraftableGenericStack> recipesToOrder;
    @Shadow(remap=false)
    private boolean canRequestCraftingPackage;
    @Shadow
    int orderY;
    @Shadow(remap=false)
    public LerpedFloat itemScroll;
    @Shadow(remap=false)
    public List<List<BigGenericStack>> displayedItems;
    @Shadow(remap=false)
    public EditBox searchBox;
    @Final
    @Shadow(remap=false)
    int cols;
    @Final
    @Shadow(remap=false)
    int rows;
    @Final
    @Shadow(remap=false)
    int rowHeight;
    @Final
    @Shadow(remap=false)
    int colWidth;
    @Final
    @Shadow(remap=false)
    private Set<Integer> hiddenCategories;
    @Shadow
    public List<StockKeeperRequestScreen.CategoryEntry> categories;
    @Final
    @Shadow(remap=false)
    Couple<Integer> noneHovered;
    @Shadow(remap=false)
    int itemsX;
    @Shadow(remap=false)
    int itemsY;
    @Shadow(remap=false)
    int windowWidth;

    public StockKeeperRequestScreenMixin(StockKeeperRequestMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    @Shadow(remap=false)
    private Pair<Integer, List<List<BigItemStack>>> maxCraftable(CraftableBigItemStack cbis, InventorySummary summary, Function<ItemStack, Integer> countModifier, int newTypeLimit) {
        return null;
    }

    @Shadow(remap=false)
    private void clampScrollBar() {
    }

    @Shadow(remap=false)
    public boolean isSchematicListMode() {
        return false;
    }

    @Shadow(remap=false)
    public void requestSchematicList() {
    }

    @Shadow(remap=false)
    private Couple<Integer> getHoveredSlot(int x, int y) {
        return this.noneHovered;
    }

    @Redirect(method={"containerTick"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/packager/InventorySummary;getCountOf(Lnet/minecraft/world/item/ItemStack;)I"))
    private int getCountInForced(InventorySummary instance, ItemStack $, @Local BigItemStack entry) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)entry);
        return GenericInventorySummary.of((InventorySummary)instance).getCountOf(stack.get().key());
    }

    @Redirect(method={"containerTick"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/packager/InventorySummary;erase(Lnet/minecraft/world/item/ItemStack;)Z"))
    private boolean eraseFromForced(InventorySummary instance, ItemStack $, @Local BigItemStack entry) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)entry);
        return GenericInventorySummary.of((InventorySummary)instance).erase(stack.get().key());
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="NEW", target="(Lnet/minecraft/world/item/ItemStack;I)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack createOrderForIngredientInClicked(ItemStack $, int count, @Local(ordinal=0) BigItemStack entry) {
        BigGenericStack genericStack = BigGenericStack.of((GenericStack)BigGenericStack.of((BigItemStack)entry).get().withAmount(1));
        genericStack.setAmount(0);
        return genericStack.asStack();
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="NEW", target="(Lnet/minecraft/world/item/ItemStack;I)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack createOrderForIngredientInScrolled(ItemStack $, int count, @Local(ordinal=0) BigItemStack entry) {
        BigGenericStack genericStack = BigGenericStack.of((GenericStack)BigGenericStack.of((BigItemStack)entry).get().withAmount(1));
        genericStack.setAmount(0);
        return genericStack.asStack();
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/packager/InventorySummary;getCountOf(Lnet/minecraft/world/item/ItemStack;)I"))
    private int getCountInSummary(InventorySummary instance, ItemStack $, @Local(ordinal=0) BigItemStack entry) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)entry);
        return GenericInventorySummary.of((InventorySummary)instance).getCountOf(stack.get().key());
    }

    @Unique
    private BigGenericStack createFactoryLogistics$getOrderForStack(GenericStack stack) {
        for (BigGenericStack entry : this.itemsToOrder) {
            if (!entry.get().canStack(stack)) continue;
            return entry;
        }
        return null;
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/StockKeeperRequestScreen;getOrderForItem(Lnet/minecraft/world/item/ItemStack;)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack getExistingOrderInClicked(StockKeeperRequestScreen instance, ItemStack $, @Local BigItemStack itemStack) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)itemStack);
        BigGenericStack order = this.createFactoryLogistics$getOrderForStack(stack.get());
        return order == null ? null : order.asStack();
    }

    @Redirect(method={"renderItemEntry"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/StockKeeperRequestScreen;getOrderForItem(Lnet/minecraft/world/item/ItemStack;)Lcom/simibubi/create/content/logistics/BigItemStack;"), remap=false)
    private BigItemStack getExistingOrderInRender(StockKeeperRequestScreen instance, ItemStack $, @Local(argsOnly=true) BigItemStack itemStack) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)itemStack);
        BigGenericStack order = this.createFactoryLogistics$getOrderForStack(stack.get());
        return order == null ? null : order.asStack();
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getMaxStackSize()I"))
    private int getMaxStackSize(ItemStack instance, @Local BigItemStack itemStack) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)itemStack);
        return GenericContentExtender.registrationOf((GenericKey)stack.get().key()).clientProvider().guiHandler().stackSize(stack.get().key());
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/StockKeeperRequestScreen;getOrderForItem(Lnet/minecraft/world/item/ItemStack;)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack getExistingOrderInScrolled(StockKeeperRequestScreen instance, ItemStack $, @Local BigItemStack itemStack) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)itemStack);
        BigGenericStack order = this.createFactoryLogistics$getOrderForStack(stack.get());
        return order == null ? null : order.asStack();
    }

    @Overwrite(remap=false)
    private void revalidateOrders() {
        HashSet<BigGenericStack> invalid = new HashSet<BigGenericStack>(this.itemsToOrder);
        GenericInventorySummary summary = GenericInventorySummary.of((InventorySummary)this.blockEntity.getLastClientsideStockSnapshotAsSummary());
        if (this.currentItemSource == null || summary == null) {
            this.itemsToOrder.removeAll(invalid);
            return;
        }
        for (BigGenericStack stack : this.itemsToOrder) {
            stack.setAmount(Math.min(summary.getCountOf(stack.get().key()), stack.get().amount()));
            if (stack.get().amount() <= 0) continue;
            invalid.remove(stack);
        }
        this.itemsToOrder.removeAll(invalid);
    }

    @Redirect(method={"renderForeground"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderTooltip(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)V"))
    private void renderTooltip(GuiGraphics instance, Font p_282308_, ItemStack p_282781_, int p_282687_, int p_282292_, @Local BigItemStack itemStack, @Local(ordinal=1) boolean orderHovered) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)itemStack);
        BigGenericStack order = this.createFactoryLogistics$getOrderForStack(stack.get());
        int customCount = stack.get().amount();
        if (stack.get().amount() < 1000000000 && !orderHovered) {
            int forcedCount = GenericInventorySummary.of((InventorySummary)this.forcedEntries).getCountOf(stack.get().key());
            if (forcedCount != 0) {
                customCount = Math.min(customCount, -forcedCount - 1);
            }
            if (order != null) {
                customCount -= order.get().amount();
            }
            customCount = Math.max(0, customCount);
        }
        instance.m_280666_(p_282308_, GenericContentExtender.registrationOf((GenericKey)stack.get().key()).clientProvider().guiHandler().tooltipBuilder(stack.get().key(), customCount), p_282687_, p_282292_);
    }

    @Redirect(method={"renderForeground"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getTooltipLines(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"))
    private List<Component> getCraftableTooltip(ItemStack instance, Player player, TooltipFlag flag, @Local BigItemStack itemStack) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)itemStack);
        return GenericContentExtender.registrationOf((GenericKey)stack.get().key()).clientProvider().guiHandler().tooltipBuilder(stack.get().key(), stack.get().amount());
    }

    @Overwrite(remap=false)
    private void refreshSearchResults(boolean scrollBackUp) {
        this.displayedItems = Collections.emptyList();
        if (scrollBackUp) {
            this.itemScroll.startWithValue(0.0);
        }
        if (this.currentItemSource == null) {
            this.clampScrollBar();
            return;
        }
        if (this.isSchematicListMode()) {
            this.clampScrollBar();
            this.requestSchematicList();
            return;
        }
        GenericSearch.SearchResult result = GenericSearch.search((CategoriesProvider)this, (String)this.searchBox.m_94155_(), (int)this.rowHeight, (int)this.cols);
        this.displayedItems = result.displayedItems();
        this.categories = new ArrayList<StockKeeperRequestScreen.CategoryEntry>(result.categories().size());
        for (int i = 0; i < result.categories().size(); ++i) {
            GenericSearch.CategoryEntry entry = (GenericSearch.CategoryEntry)result.categories().get(i);
            StockKeeperRequestScreen.CategoryEntry categoryEntry = new StockKeeperRequestScreen.CategoryEntry(entry.targetCategory(), entry.name(), entry.y().getValue().intValue());
            ((CategoryEntryAccessor)categoryEntry).setHidden(entry.hidden().getValue());
            this.categories.add(categoryEntry);
        }
        this.clampScrollBar();
        this.updateCraftableAmounts();
    }

    @Redirect(method={"renderItemEntry"}, at=@At(value="INVOKE", target="Lnet/createmod/catnip/gui/element/GuiGameElement;of(Lnet/minecraft/world/item/ItemStack;)Lnet/createmod/catnip/gui/element/GuiGameElement$GuiRenderBuilder;"), remap=false)
    private GuiGameElement.GuiRenderBuilder renderIngredientEntry(ItemStack itemStack, @Local(argsOnly=true) BigItemStack entry, @Local(argsOnly=true) GuiGraphics graphics) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)entry);
        GenericContentExtender.registrationOf((GenericKey)stack.get().key()).clientProvider().guiHandler().renderSlot(graphics, stack.get().key(), 0, 0);
        return GuiGameElement.of((ItemLike)Blocks.f_50016_);
    }

    @Redirect(method={"renderItemEntry"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/StockKeeperRequestScreen;drawItemCount(Lnet/minecraft/client/gui/GuiGraphics;II)V"), remap=false)
    private void renderIngredientEntryAmount(StockKeeperRequestScreen instance, GuiGraphics graphics, int count, int customCount, @Local(argsOnly=true) BigItemStack entry, @Local(argsOnly=true, ordinal=0) boolean isStackHovered, @Local(argsOnly=true, ordinal=1) boolean isRenderingOrders) {
        if (isStackHovered && isRenderingOrders && !(entry instanceof CraftableBigItemStack)) {
            return;
        }
        BigGenericStack stack = BigGenericStack.of((BigItemStack)entry);
        count = customCount;
        GenericContentExtender.registrationOf((GenericKey)stack.get().key()).clientProvider().guiHandler().renderDecorations(graphics, stack.get().key(), count, 1, 1);
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=1))
    private void decreaseOrderCount(BigItemStack instance, int count) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)instance);
        stack.setAmount(count);
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=4))
    private void increaseOrderCount(BigItemStack instance, int count) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)instance);
        stack.setAmount(count);
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=1))
    private void scrollDecreaseOrderCount(BigItemStack instance, int count) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)instance);
        stack.setAmount(count);
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=4))
    private void scrollIncreaseOrderCount(BigItemStack instance, int count) {
        BigGenericStack stack = BigGenericStack.of((BigItemStack)instance);
        stack.setAmount(count);
    }

    @Overwrite(remap=false)
    private void updateCraftableAmounts() {
        this.canRequestCraftingPackage = RecipeRequestHelper.updateCraftableAmounts((OrderProvider)this);
    }

    @Overwrite(remap=false)
    public void requestCraftable(CraftableBigItemStack cbis, int requestedDifference) {
        RecipeRequestHelper.requestCraftable((OrderProvider)this, (CraftableGenericStack)CraftableGenericStack.of((CraftableBigItemStack)cbis), (int)requestedDifference);
    }

    public List<BigGenericStack> itemsToOrder() {
        return this.itemsToOrder;
    }

    public List<CraftableGenericStack> recipesToOrder() {
        return this.recipesToOrder;
    }

    public Level world() {
        return this.blockEntity.m_58904_();
    }

    public BigGenericStack orderForStack(GenericStack stack) {
        return this.createFactoryLogistics$getOrderForStack(stack);
    }

    public GenericInventorySummary stockSnapshot() {
        return GenericInventorySummary.of((InventorySummary)this.blockEntity.getLastClientsideStockSnapshotAsSummary());
    }

    public List<ItemStack> categories() {
        return ((StockTickerBlockEntityAccessor)this.blockEntity).getCategories();
    }

    public Set<Integer> hiddenCategories() {
        return this.hiddenCategories;
    }

    public List<List<BigGenericStack>> currentItemSource() {
        return this.currentItemSource;
    }

    @Override
    public Pair<GenericKey, Rect2i> getHoveredKey(int mouseX, int mouseY) {
        Couple<Integer> hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        if (hoveredSlot != this.noneHovered) {
            BigGenericStack entry;
            int y;
            int x;
            boolean orderHovered;
            int index = (Integer)hoveredSlot.getSecond();
            boolean recipeHovered = (Integer)hoveredSlot.getFirst() == -2;
            boolean bl = orderHovered = (Integer)hoveredSlot.getFirst() == -1;
            if (recipeHovered) {
                int jeiX = this.getGuiLeft() + (this.windowWidth - this.colWidth * this.recipesToOrder.size()) / 2 + 1;
                int jeiY = this.orderY - 31;
                x = jeiX + index * this.colWidth;
                y = jeiY;
                entry = (BigGenericStack)this.recipesToOrder.get(index);
            } else if (orderHovered) {
                x = this.itemsX + index * this.colWidth;
                y = this.orderY;
                entry = this.itemsToOrder.get(index);
            } else {
                int categoryIndex = (Integer)hoveredSlot.getFirst();
                int categoryY = this.categories.isEmpty() ? 0 : ((CategoryEntryAccessor)this.categories.get(categoryIndex)).getY();
                x = this.itemsX + index % this.cols * this.colWidth;
                y = this.itemsY + categoryY + (this.categories.isEmpty() ? 4 : this.rowHeight) + index / this.cols * this.rowHeight;
                entry = this.displayedItems.get(categoryIndex).get(index);
            }
            Rect2i bounds = new Rect2i(x, y, x + 18, y + 18);
            return Pair.of((Object)entry.get().key(), (Object)bounds);
        }
        return Pair.of((Object)GenericKey.EMPTY, (Object)new Rect2i(0, 0, 0, 0));
    }
}

