/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.generic;

import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import ru.zznty.create_factory_abstractions.api.generic.capability.GenericInventorySummaryProvider;
import ru.zznty.create_factory_abstractions.api.generic.extensibility.GenericKeyProviderExtension;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericCapabilityWrapperProvider;
import ru.zznty.create_factory_logistics.logistics.generic.FluidInventorySummaryProvider;
import ru.zznty.create_factory_logistics.logistics.generic.FluidKey;
import ru.zznty.create_factory_logistics.logistics.generic.NetworkFluidHandler;

public class FluidGenericExtension
implements GenericKeyProviderExtension<FluidKey, FluidStack, Fluid, IFluidHandler> {
    private final GenericCapabilityWrapperProvider<IFluidHandler> provider = new GenericCapabilityWrapperProvider<IFluidHandler>(){

        public Capability<IFluidHandler> capability() {
            return ForgeCapabilities.FLUID_HANDLER;
        }

        public IFluidHandler wrap(GenericInventorySummaryProvider summaryProvider) {
            return new NetworkFluidHandler(summaryProvider);
        }

        public GenericInventorySummaryProvider unwrap(IFluidHandler capability) {
            return new FluidInventorySummaryProvider(capability);
        }
    };

    public FluidKey defaultKey() {
        return this.wrap(FluidStack.EMPTY);
    }

    public FluidKey wrap(FluidStack fluidStack) {
        return new FluidKey(fluidStack.getRawFluid(), fluidStack.getTag());
    }

    public FluidKey wrapGeneric(FluidStack fluidStack) {
        return new FluidKey(fluidStack.getRawFluid(), null);
    }

    public FluidStack unwrap(FluidKey key) {
        return key.stack();
    }

    public String ingredientTypeUid() {
        return "fluid_stack";
    }

    public Optional<ResourceKey<Fluid>> resourceKey(FluidKey key) {
        return ForgeRegistries.FLUIDS.getResourceKey((Object)key.fluid());
    }

    public GenericCapabilityWrapperProvider<IFluidHandler> capabilityWrapperProvider() {
        return this.provider;
    }

    public int compare(FluidKey a, FluidKey b) {
        ResourceLocation akey = ForgeRegistries.FLUIDS.getKey((Object)a.fluid());
        if (akey == null) {
            return -1;
        }
        ResourceLocation bKey = ForgeRegistries.FLUIDS.getKey((Object)b.fluid());
        if (bKey == null) {
            return 1;
        }
        return akey.compareTo(bKey);
    }
}

