/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.cherishedworlds.client.favorites;

import com.illusivesoulworks.cherishedworlds.CherishedWorldsConstants;
import com.illusivesoulworks.cherishedworlds.platform.Services;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.apache.commons.io.FileUtils;

public class FavoritesList {
    private static final Set<String> favorites = new HashSet<String>();

    public static void load() {
        try {
            favorites.clear();
            File file = new File(Services.PLATFORM.getGamePath().toString(), "cherishedworlds-favorites.dat");
            CompoundTag compound = NbtIo.m_128953_((File)file);
            if (compound == null) {
                return;
            }
            ListTag list = compound.m_128437_("favorites", 8);
            for (int i = 0; i < list.size(); ++i) {
                favorites.add(list.m_128778_(i));
            }
        }
        catch (Exception exception) {
            CherishedWorldsConstants.LOG.error("Couldn't load favorites list", (Throwable)exception);
        }
    }

    public static void save() {
        try {
            ListTag list = new ListTag();
            for (String s : favorites) {
                list.add((Object)StringTag.m_129297_((String)s));
            }
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("favorites", (Tag)list);
            File file = new File(Services.PLATFORM.getGamePath().toString(), "cherishedworlds-favorites.dat");
            if (!file.exists()) {
                FileUtils.forceMkdirParent((File)file);
            }
            NbtIo.m_128955_((CompoundTag)compound, (File)file);
        }
        catch (Exception exception) {
            CherishedWorldsConstants.LOG.error("Couldn't save favorites list", (Throwable)exception);
        }
    }

    public static boolean contains(String fileName) {
        return favorites.contains(fileName);
    }

    public static void add(String name) {
        favorites.add(name);
    }

    public static void remove(String name) {
        favorites.remove(name);
    }
}

