/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ExportCreativeTabsCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"creative_tabs").then(Commands.m_82129_((String)"signPos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> ExportCreativeTabsCommand.exportCreativeTabs((CommandSourceStack)ctx.getSource(), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"signPos")))));
    }

    private static int exportCreativeTabs(CommandSourceStack source, BlockPos pos) {
        DataResult<Pair<ResourceLocation, Direction>> result = ExportCreativeTabsCommand.checkIsValidSign(source, pos);
        if (result.error().isPresent()) {
            source.m_81352_((Component)Component.m_237113_((String)((DataResult.PartialResult)result.error().get()).message()));
            return 0;
        }
        Direction direction = (Direction)((Pair)result.result().orElseThrow()).getSecond();
        ServerLevel level = source.m_81372_();
        List<Pair<BlockPos, Container>> containers = ExportCreativeTabsCommand.findContainerSequence(level, pos, direction);
        LinkedHashMap data = Maps.newLinkedHashMap();
        try {
            LinkedHashSet<String> items = ExportCreativeTabsCommand.collectItems(source, containers);
            if (!items.isEmpty()) {
                data.put(((ResourceLocation)((Pair)result.result().orElseThrow()).getFirst()).toString(), items);
            }
            for (Direction leftOrRight : List.of(Rotation.CLOCKWISE_90.m_55954_(direction), Rotation.COUNTERCLOCKWISE_90.m_55954_(direction))) {
                BlockPos.MutableBlockPos mutablePos = pos.m_122032_().m_122173_(leftOrRight);
                int failed = 0;
                while (failed < 5) {
                    mutablePos.m_122173_(leftOrRight);
                    DataResult<Pair<ResourceLocation, Direction>> result2 = ExportCreativeTabsCommand.checkIsValidSign(source, (BlockPos)mutablePos);
                    if (result2.error().isPresent()) {
                        ++failed;
                        continue;
                    }
                    Pair pair = (Pair)result2.result().orElseThrow();
                    if (direction != pair.getSecond()) {
                        ++failed;
                        continue;
                    }
                    String tabId = ((ResourceLocation)pair.getFirst()).toString();
                    if (data.containsKey(tabId)) {
                        failed = 0;
                        continue;
                    }
                    containers = ExportCreativeTabsCommand.findContainerSequence(level, (BlockPos)mutablePos, direction);
                    items = ExportCreativeTabsCommand.collectItems(source, containers);
                    if (!items.isEmpty()) {
                        data.put(tabId, items);
                    }
                    failed = 0;
                }
            }
        }
        catch (RuntimeException e) {
            source.m_81352_((Component)Component.m_237113_((String)e.getMessage()));
            return 0;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get("exported_creative_tabs.json", new String[0]), new OpenOption[0]);){
            new Gson().toJson((Object)data, (Appendable)writer);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)e.getMessage()));
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)"Creative tabs exported"), false);
        return 1;
    }

    private static List<Pair<BlockPos, Container>> findContainerSequence(ServerLevel level, BlockPos pos, Direction direction) {
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        ArrayList containers = Lists.newArrayList();
        HashSet set = Sets.newHashSet();
        while (true) {
            BaseContainerBlockEntity blockEntity;
            mutablePos.m_122173_(direction);
            BlockEntity blockEntity2 = level.m_7702_((BlockPos)mutablePos);
            if (!(blockEntity2 instanceof BaseContainerBlockEntity)) break;
            BaseContainerBlockEntity container = blockEntity = (BaseContainerBlockEntity)blockEntity2;
            Block block = blockEntity.m_58900_().m_60734_();
            if (block instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)block;
                if (ChestBlock.m_51584_((BlockState)blockEntity.m_58900_()) == direction.m_122424_()) continue;
                container = ChestBlock.m_51511_((ChestBlock)chestBlock, (BlockState)blockEntity.m_58900_(), (Level)Objects.requireNonNull(blockEntity.m_58904_()), (BlockPos)mutablePos, (boolean)true);
            }
            if (!set.add(container)) continue;
            containers.add(Pair.of((Object)blockEntity.m_58899_(), (Object)container));
        }
        return containers;
    }

    private static LinkedHashSet<String> collectItems(CommandSourceStack source, List<Pair<BlockPos, Container>> pairs) {
        ServerLevel level = source.m_81372_();
        LinkedHashSet items = Sets.newLinkedHashSet();
        for (Pair<BlockPos, Container> pair : pairs) {
            level.m_46597_(((BlockPos)pair.getFirst()).m_7495_(), Blocks.f_50098_.m_49966_());
        }
        for (Pair<BlockPos, Container> pair : pairs) {
            Container container = (Container)pair.getSecond();
            for (int i = 0; i < container.m_6643_(); ++i) {
                String item;
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_() || items.add(item = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString())) continue;
                for (Pair<BlockPos, Container> pair1 : pairs) {
                    if (!((Container)pair1.getSecond()).m_216874_($ -> ItemStack.m_150942_((ItemStack)$, (ItemStack)stack))) continue;
                    level.m_46597_(((BlockPos)pair1.getFirst()).m_7495_(), Blocks.f_50108_.m_49966_());
                }
                throw new IllegalStateException("Duplicate item: %s (%s)".formatted(stack.m_41786_().getString(), item));
            }
            level.m_46597_(((BlockPos)pair.getFirst()).m_7495_(), Blocks.f_50099_.m_49966_());
        }
        return items;
    }

    private static DataResult<Pair<ResourceLocation, Direction>> checkIsValidSign(CommandSourceStack source, BlockPos pos) {
        ServerLevel level = source.m_81372_();
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (!(block instanceof SignBlock)) {
            return DataResult.error(() -> "Target block is not a sign");
        }
        SignBlock block2 = (SignBlock)block;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SignBlockEntity)) {
            return DataResult.error(() -> "Target block is not a sign");
        }
        SignBlockEntity blockEntity2 = (SignBlockEntity)blockEntity;
        String signText = String.join((CharSequence)"", Arrays.stream(blockEntity2.m_277142_().m_276945_(false)).map(Component::getString).toList());
        if (signText.isBlank()) {
            return DataResult.error(() -> "The sign is empty");
        }
        ResourceLocation tabId = ResourceLocation.m_135820_((String)signText);
        if (tabId == null) {
            return DataResult.error(() -> "The sign text is not a valid resource location");
        }
        Direction direction = Direction.m_122364_((double)block2.m_276903_(blockState)).m_122424_();
        return DataResult.success((Object)Pair.of((Object)tabId, (Object)direction));
    }
}

