/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import snownee.kiwi.customization.builder.BuilderRule;
import snownee.kiwi.customization.builder.BuilderRules;
import snownee.kiwi.customization.builder.BuildersButton;
import snownee.kiwi.util.KHolder;
import snownee.kiwi.util.NotNullByDefault;
import snownee.kiwi.util.Util;

@NotNullByDefault
public class BuilderModePreview
implements DebugRenderer.SimpleDebugRenderer {
    public KHolder<BuilderRule> rule;
    public BlockPos pos;
    private BlockState blockState = Blocks.f_50016_.m_49966_();
    public List<BlockPos> positions = List.of();
    private final ListMultimap<Direction, AABB> faces = ArrayListMultimap.create((int)6, (int)32);
    private long lastUpdateTime;

    public void m_7790_(PoseStack pPoseStack, MultiBufferSource pBuffer, double pCamX, double pCamY, double pCamZ) {
        BlockHitResult hitResult;
        Minecraft mc;
        block8: {
            block7: {
                HitResult hitResult2;
                mc = Minecraft.m_91087_();
                if (!BuildersButton.isBuilderModeOn() || !((hitResult2 = mc.f_91077_) instanceof BlockHitResult)) break block7;
                hitResult = (BlockHitResult)hitResult2;
                if (mc.f_91077_.m_6662_() != HitResult.Type.MISS) break block8;
            }
            this.positions = List.of();
            return;
        }
        long millis = net.minecraft.Util.m_137550_();
        Player player = (Player)Objects.requireNonNull(mc.f_91074_);
        BlockState blockState = player.m_9236_().m_8055_(hitResult.m_82425_());
        if (millis - this.lastUpdateTime > 200L || !hitResult.m_82425_().equals((Object)this.pos) || this.blockState != blockState) {
            this.lastUpdateTime = millis;
            this.blockState = blockState;
            this.updatePositions(player, hitResult);
        }
        if (this.positions.isEmpty()) {
            return;
        }
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_269166_());
        Matrix4f pose = pPoseStack.m_85850_().m_252922_();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 0.08f + Mth.m_14031_((float)((float)millis / 350.0f)) * 0.05f;
        for (Map.Entry entry : this.faces.asMap().entrySet()) {
            Direction direction = (Direction)entry.getKey();
            for (AABB aabb : (Collection)entry.getValue()) {
                aabb = aabb.m_82386_(-pCamX, -pCamY, -pCamZ);
                this.drawFace(pose, vertexconsumer, aabb, direction, r, g, b, a);
            }
        }
    }

    private void updatePositions(Player player, BlockHitResult hitResult) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_()) {
            return;
        }
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack itemStack = player.m_21120_(hand);
        this.rule = null;
        this.pos = null;
        this.positions = List.of();
        for (KHolder<BuilderRule> holder : BuilderRules.find(this.blockState.m_60734_())) {
            if (!holder.value().matches(player, itemStack, this.blockState)) continue;
            this.positions = holder.value().searchPositions(this.blockState, new UseOnContext(player, hand, hitResult));
            if (this.positions.isEmpty()) continue;
            this.rule = holder;
            this.pos = hitResult.m_82425_();
            this.faces.clear();
            VoxelShape fullShape = this.positions.stream().map(BuilderModePreview::getShape).reduce(Shapes.m_83040_(), (a, b) -> Shapes.m_83148_((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.f_82695_));
            fullShape = fullShape.m_83296_();
            List aabbs = fullShape.m_83299_();
            for (Direction direction : Util.DIRECTIONS) {
                for (AABB aabb : aabbs) {
                    VoxelShape faceShape = BuilderModePreview.getFaceShape(aabb, direction);
                    if ((faceShape = Shapes.m_83113_((VoxelShape)faceShape, (VoxelShape)fullShape, (BooleanOp)BooleanOp.f_82685_)).m_83281_()) continue;
                    for (AABB faceShapeAabb : faceShape.m_83299_()) {
                        this.faces.put((Object)direction, (Object)faceShapeAabb);
                    }
                }
            }
        }
    }

    private void drawFace(Matrix4f pose, VertexConsumer consumer, AABB aabb, Direction face, float r, float g, float b, float a) {
        float minX = (float)aabb.f_82288_;
        float minY = (float)aabb.f_82289_;
        float minZ = (float)aabb.f_82290_;
        float maxX = (float)aabb.f_82291_;
        float maxY = (float)aabb.f_82292_;
        float maxZ = (float)aabb.f_82293_;
        switch (face) {
            case DOWN: {
                consumer.m_252986_(pose, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
                break;
            }
            case UP: {
                consumer.m_252986_(pose, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
                break;
            }
            case NORTH: {
                consumer.m_252986_(pose, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
                break;
            }
            case SOUTH: {
                consumer.m_252986_(pose, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
                break;
            }
            case WEST: {
                consumer.m_252986_(pose, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
                break;
            }
            case EAST: {
                consumer.m_252986_(pose, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
                consumer.m_252986_(pose, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
            }
        }
    }

    private static VoxelShape getFaceShape(AABB aabb, Direction face) {
        aabb = switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new AABB(aabb.f_82288_, aabb.f_82289_ - 1.0E-4, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
            case Direction.UP -> new AABB(aabb.f_82288_, aabb.f_82292_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_ + 1.0E-4, aabb.f_82293_);
            case Direction.NORTH -> new AABB(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_ - 1.0E-4, aabb.f_82291_, aabb.f_82292_, aabb.f_82290_);
            case Direction.SOUTH -> new AABB(aabb.f_82288_, aabb.f_82289_, aabb.f_82293_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_ + 1.0E-4);
            case Direction.WEST -> new AABB(aabb.f_82288_ - 1.0E-4, aabb.f_82289_, aabb.f_82290_, aabb.f_82288_, aabb.f_82292_, aabb.f_82293_);
            case Direction.EAST -> new AABB(aabb.f_82291_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_ + 1.0E-4, aabb.f_82292_, aabb.f_82293_);
        };
        return Shapes.m_83064_((AABB)aabb);
    }

    private static VoxelShape getShape(BlockPos pos) {
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        BlockState blockState = level.m_8055_(pos);
        return blockState.m_60808_((BlockGetter)level, pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }
}

