/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.client.gui;

import cd4017be.dimstack.api.CustomWorldProps;
import cd4017be.dimstack.api.IDimension;
import cd4017be.dimstack.client.gui.AutoCompletion;
import cd4017be.dimstack.client.gui.AutoCompletions;
import cd4017be.dimstack.client.gui.GuiBlockSel;
import cd4017be.dimstack.client.gui.GuiMenuBase;
import cd4017be.lib.util.TooltipUtil;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiListButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.world.biome.Biome;

public class GuiWorldProvider
extends GuiMenuBase
implements GuiPageButtonList.GuiResponder {
    private final IDimension dim;
    private final CustomWorldProps cfg;
    private AutoCompletion<Biome> complete;
    private GuiBlockSel biomes;

    public GuiWorldProvider(GuiScreen parent, IDimension dim) {
        super(parent);
        this.dim = dim;
        this.cfg = dim.getSettings(CustomWorldProps.class, true);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.complete = AutoCompletions.biomes();
        this.title = TooltipUtil.translate((String)"gui.dimstack.world_provider") + " [\u00a7e" + this.dim + "\u00a7r]";
        int n = 4;
        int x = this.field_146294_l / 2 - 158;
        int y = (this.field_146295_m - n * 28 - 20) / 2;
        ((GuiSlider)this.func_189646_b((GuiButton)new GuiSlider((GuiPageButtonList.GuiResponder)this, 9, x, y, TooltipUtil.translate((String)"gui.dimstack.horizon"), 0.0f, 256.0f, this.cfg.horizonHeight, (id, name, val) -> String.format(name.startsWith("Format error: ") ? name.substring(14) : name, Float.valueOf(val))))).func_175211_a(150);
        ((GuiSlider)this.func_189646_b((GuiButton)new GuiSlider((GuiPageButtonList.GuiResponder)this, 10, x + 166, y, TooltipUtil.translate((String)"gui.dimstack.clouds"), 0.0f, 256.0f, this.cfg.cloudHeight, (id, name, val) -> String.format(name.startsWith("Format error: ") ? name.substring(14) : name, Float.valueOf(val))))).func_175211_a(150);
        this.func_189646_b((GuiButton)new GuiListButton((GuiPageButtonList.GuiResponder)this, 5, x, y += 28, "gui.dimstack.fog", (this.cfg.flags & 0x10) != 0));
        GuiLabel l = new GuiLabel(this.field_146289_q, 0, x + 166, y, 90, 20, -8355712);
        this.field_146293_o.add(l);
        l.func_175202_a(TooltipUtil.translate((String)"gui.dimstack.fogc"));
        l.func_175202_a("hex: YYRRGGBB");
        GuiTextField tf = new GuiTextField(6, this.field_146289_q, x + 256, y, 60, 20);
        this.textFields.add(tf);
        tf.func_146180_a(String.format("%08X", this.cfg.fogColor));
        tf.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.func_189646_b((GuiButton)new GuiListButton((GuiPageButtonList.GuiResponder)this, 1, x, y += 28, "gui.dimstack.skylight", (this.cfg.flags & 1) != 0));
        this.func_189646_b((GuiButton)new GuiListButton((GuiPageButtonList.GuiResponder)this, 2, x + 166, y, "gui.dimstack.skybox", (this.cfg.flags & 8) != 0));
        this.func_189646_b((GuiButton)new GuiListButton((GuiPageButtonList.GuiResponder)this, 3, x, y += 28, "gui.dimstack.nether", (this.cfg.flags & 4) != 0));
        this.func_189646_b((GuiButton)new GuiListButton((GuiPageButtonList.GuiResponder)this, 4, x + 166, y, "gui.dimstack.nowater", (this.cfg.flags & 2) != 0));
        l = new GuiLabel(this.field_146289_q, 1, x, y += 28, 150, 10, -8355712);
        this.field_146293_o.add(l);
        l.func_175202_a(TooltipUtil.translate((String)"gui.dimstack.biome"));
        l = new GuiLabel(this.field_146289_q, 2, x + 166, y, 150, 10, -8355712);
        this.field_146293_o.add(l);
        l.func_175202_a(TooltipUtil.translate((String)"gui.dimstack.chunkgen"));
        this.biomes = new GuiBlockSel(7, this.field_146289_q, this.complete, x, y += 10, 150, 20);
        this.textFields.add(this.biomes);
        this.biomes.func_146180_a(this.cfg.biomeGen);
        this.biomes.func_175207_a(this);
        this.func_189646_b(new GuiButton(8, x + 166, y, TooltipUtil.translate((String)("gui.dimstack.chunkgen" + Integer.toHexString(this.cfg.chunkGen))))).func_175211_a(150);
    }

    @Override
    public void func_73863_a(int mx, int my, float t) {
        super.func_73863_a(mx, my, t);
        this.biomes.drawOverlay();
    }

    public void func_146281_b() {
        this.complete.dispose();
    }

    public void func_175321_a(int id, boolean value) {
        int mask = 0;
        switch (id) {
            case 1: {
                mask = 1;
                break;
            }
            case 2: {
                mask = 8;
                break;
            }
            case 3: {
                mask = 4;
                break;
            }
            case 4: {
                mask = 2;
                break;
            }
            case 5: {
                mask = 16;
            }
        }
        this.cfg.flags = value ? (this.cfg.flags |= mask) : (this.cfg.flags &= ~mask);
    }

    public void func_175320_a(int id, float value) {
        switch (id) {
            case 9: {
                this.cfg.horizonHeight = value;
                break;
            }
            case 10: {
                this.cfg.cloudHeight = value;
            }
        }
    }

    public void func_175319_a(int id, String value) {
        switch (id) {
            case 6: {
                try {
                    this.cfg.fogColor = Integer.parseInt(value, 16);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 7: {
                this.cfg.biomeGen = value;
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton b) throws IOException {
        if (b.field_146127_k == 8) {
            if (++this.cfg.chunkGen >= 4) {
                this.cfg.chunkGen = 0;
            }
            b.field_146126_j = TooltipUtil.translate((String)("gui.dimstack.chunkgen" + Integer.toHexString(this.cfg.chunkGen)));
        } else {
            super.func_146284_a(b);
        }
    }
}

