/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.client.gui;

import cd4017be.dimstack.api.IDimension;
import cd4017be.dimstack.api.OreGeneration;
import cd4017be.dimstack.api.gen.IOreGenerator;
import cd4017be.dimstack.api.util.BlockPredicate;
import cd4017be.dimstack.client.RenderUtil;
import cd4017be.dimstack.client.gui.AutoCompletions;
import cd4017be.dimstack.client.gui.BlockStateCompletion;
import cd4017be.dimstack.client.gui.GuiBlockSel;
import cd4017be.dimstack.client.gui.GuiList;
import cd4017be.dimstack.client.gui.GuiMenuBase;
import cd4017be.dimstack.client.gui.IDrawableEntry;
import cd4017be.lib.util.TooltipUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiCustomOres
extends GuiMenuBase
implements GuiPageButtonList.GuiResponder {
    private static final int WIDTH = 308;
    private static final int HEIGHT = 184;
    private final OreGeneration cfg;
    private BlockStateCompletion complete;
    private GuiBlockSel block;
    private GuiBlockSel rock;
    private GuiTextField maxY;
    private GuiTextField minY;
    private GuiTextField mainY;
    private GuiButton mode;
    private GuiButton rem;
    private GuiSlider bpv;
    private GuiSlider vpc;
    private GuiList<Ore> list;

    public GuiCustomOres(GuiScreen parent, IDimension dim) {
        super(parent);
        this.cfg = dim.getSettings(OreGeneration.class, true);
    }

    @Override
    public void func_73866_w_() {
        List layers;
        super.func_73866_w_();
        this.complete = AutoCompletions.blockstates();
        this.title = TooltipUtil.translate((String)"gui.dimstack.newOre");
        int x = (this.field_146294_l - 308) / 2;
        int y = (this.field_146295_m - 184) / 2;
        if (this.list != null) {
            layers = this.list.list;
        } else {
            layers = new ArrayList();
            for (IOreGenerator gen : this.cfg.entries) {
                NBTTagCompound nbt = gen.writeNBT();
                nbt.func_74778_a("id", gen.getRegistryName());
                layers.add(new Ore(nbt));
            }
        }
        this.list = (GuiList)this.func_189646_b(new GuiList(1, x, y, 150, 162, 16, TooltipUtil.translate((String)"gui.dimstack.ore.list"), layers));
        this.func_189646_b((GuiButton)new GuiButtonExt(2, x, y + 184 - 20, 74, 20, TooltipUtil.translate((String)"gui.dimstack.new")));
        this.rem = this.func_189646_b((GuiButton)new GuiButtonExt(3, x + 76, y + 184 - 20, 74, 20, TooltipUtil.translate((String)"gui.dimstack.rem")));
        GuiLabel l = new GuiLabel(this.field_146289_q, 0, x += 158, y, 150, 10, 0x7F7F7F);
        this.field_146293_o.add(l);
        l.func_175202_a(TooltipUtil.translate((String)"gui.dimstack.ore.block"));
        this.block = new GuiBlockSel(4, this.field_146289_q, this.complete, x, y += 10, 150, 20);
        this.block.func_175207_a(this);
        this.textFields.add(this.block);
        l = new GuiLabel(this.field_146289_q, 1, x, y += 24, 150, 10, 0x7F7F7F);
        this.field_146293_o.add(l);
        l.func_175202_a(TooltipUtil.translate((String)"gui.dimstack.ore.repl"));
        this.rock = new GuiBlockSel(5, this.field_146289_q, this.complete, x, y += 10, 150, 20).enableList();
        this.rock.func_175207_a(this);
        this.textFields.add(this.rock);
        this.bpv = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider((GuiPageButtonList.GuiResponder)this, 6, x, y += 24, TooltipUtil.translate((String)"gui.dimstack.ore.bpv"), 1.0f, 128.0f, 0.0f, (id, name, val) -> String.format(name.startsWith("Format error: ") ? name.substring(14) : name, Float.valueOf(val))));
        this.bpv.func_175211_a(150);
        this.vpc = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider((GuiPageButtonList.GuiResponder)this, 7, x, y += 24, TooltipUtil.translate((String)"gui.dimstack.ore.vpc"), 0.33333334f, 48.0f, 0.0f, (id, name, val) -> String.format(name.startsWith("Format error: ") ? name.substring(14) : name, Float.valueOf(val))));
        this.vpc.func_175211_a(150);
        this.mode = this.func_189646_b((GuiButton)new GuiButtonExt(8, x, y += 24, 150, 20, ""));
        this.minY = new GuiTextField(9, this.field_146289_q, x + 75 - 30, y += 24, 30, 20);
        this.textFields.add(this.minY);
        this.minY.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.maxY = new GuiTextField(10, this.field_146289_q, x + 150 - 30, y, 30, 20);
        this.textFields.add(this.maxY);
        this.maxY.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.mainY = new GuiTextField(11, this.field_146289_q, x + 150 - 30, y += 24, 30, 20);
        this.textFields.add(this.mainY);
        this.mainY.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.select(-1);
    }

    private void select(int i) {
        this.list.sel = i;
        NBTTagCompound nbt = this.getSel();
        boolean enable = nbt != null;
        for (int j = this.field_146293_o.size() - 1; j >= 2; --j) {
            this.field_146293_o.remove(j);
        }
        this.minY.func_146189_e(false);
        this.maxY.func_146189_e(false);
        this.mainY.func_146189_e(false);
        if (enable) {
            GuiLabel l;
            this.vpc.func_175218_a(nbt.func_74760_g("vpc"), false);
            this.bpv.func_175218_a((float)nbt.func_74765_d("bpv"), false);
            this.block.func_146180_a(nbt.func_74779_i("ore"));
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (NBTBase tag : nbt.func_150295_c("target", 8)) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(((NBTTagString)tag).func_150285_a_());
            }
            this.rock.func_146180_a(sb.toString());
            String id = nbt.func_74779_i("id");
            this.mode.field_146126_j = TooltipUtil.translate((String)("dimstack.ore." + id));
            if (id.equals("even") || id.equals("center")) {
                l = new GuiLabel(this.field_146289_q, 2, this.minY.field_146209_f - 45, this.minY.field_146210_g, 45, 20, 0xFFFFFF).func_175203_a();
                this.field_146293_o.add(l);
                for (String s : TooltipUtil.translate((String)"gui.dimstack.layer.bot").split("\n", 2)) {
                    l.func_175202_a(s);
                }
                this.minY.func_146180_a(Integer.toString(nbt.func_74765_d("minY")));
                this.minY.func_146189_e(true);
                l = new GuiLabel(this.field_146289_q, 3, this.maxY.field_146209_f - 45, this.maxY.field_146210_g, 45, 20, 0xFFFFFF).func_175203_a();
                this.field_146293_o.add(l);
                for (String s : TooltipUtil.translate((String)"gui.dimstack.layer.top").split("\n", 2)) {
                    l.func_175202_a(s);
                }
                this.maxY.func_146180_a(Integer.toString(nbt.func_74765_d("maxY")));
                this.maxY.func_146189_e(true);
                if (id.equals("center")) {
                    l = new GuiLabel(this.field_146289_q, 4, this.mainY.field_146209_f - 120, this.mainY.field_146210_g, 120, 20, 0xFFFFFF).func_175203_a();
                    this.field_146293_o.add(l);
                    for (String s : TooltipUtil.translate((String)"gui.dimstack.ore.peak").split("\n", 2)) {
                        l.func_175202_a(s);
                    }
                    this.mainY.func_146180_a(Integer.toString(nbt.func_74765_d("mainY")));
                    this.mainY.func_146189_e(true);
                }
            } else if (id.equals("gauss")) {
                l = new GuiLabel(this.field_146289_q, 2, this.maxY.field_146209_f - 120, this.maxY.field_146210_g, 120, 20, 0xFFFFFF).func_175203_a();
                this.field_146293_o.add(l);
                for (String s : TooltipUtil.translate((String)"gui.dimstack.ore.main").split("\n", 2)) {
                    l.func_175202_a(s);
                }
                this.maxY.func_146180_a(Float.toString(nbt.func_74760_g("mainY")));
                this.maxY.func_146189_e(true);
                l = new GuiLabel(this.field_146289_q, 3, this.mainY.field_146209_f - 120, this.mainY.field_146210_g, 120, 20, 0xFFFFFF).func_175203_a();
                this.field_146293_o.add(l);
                for (String s : TooltipUtil.translate((String)"gui.dimstack.ore.dev").split("\n", 2)) {
                    l.func_175202_a(s);
                }
                this.mainY.func_146180_a(Float.toString(nbt.func_74760_g("devY")));
                this.mainY.func_146189_e(true);
            } else {
                l = new GuiLabel(this.field_146289_q, 2, this.mode.field_146128_h, this.mode.field_146129_i + 24, 150, 20, 0xFF4040).func_175203_a();
                this.field_146293_o.add(l);
                l.func_175202_a("Editing not supported,");
                l.func_175202_a("better don't modify!");
            }
        } else {
            this.block.func_146180_a("");
            this.rock.func_146180_a("");
            this.mode.field_146126_j = "";
        }
        this.block.func_146184_c(enable);
        this.rock.func_146184_c(enable);
        this.minY.func_146184_c(this.minY.func_146176_q());
        this.maxY.func_146184_c(this.maxY.func_146176_q());
        this.mainY.func_146184_c(this.mainY.func_146176_q());
        this.mode.field_146124_l = enable;
        this.vpc.field_146124_l = enable;
        this.bpv.field_146124_l = enable;
        this.rem.field_146124_l = enable;
    }

    private NBTTagCompound getSel() {
        return this.list.sel >= 0 && this.list.sel < this.list.list.size() ? ((Ore)this.list.list.get((int)this.list.sel)).nbt : null;
    }

    @Override
    public void func_73863_a(int mx, int my, float t) {
        super.func_73863_a(mx, my, t);
        this.block.drawOverlay();
        this.rock.drawOverlay();
    }

    @Override
    protected void func_146284_a(GuiButton b) throws IOException {
        int s = this.list.sel;
        switch (b.field_146127_k) {
            case 1: {
                this.select(this.list.sel);
                break;
            }
            case 2: {
                if (++s < 0 || s > this.list.list.size()) {
                    s = this.list.list.size();
                }
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("id", "even");
                this.list.list.add(s, new Ore(nbt));
                this.select(s);
                break;
            }
            case 3: {
                if (s < 0 || s >= this.list.list.size()) break;
                this.list.list.remove(s);
                this.select(-1);
                break;
            }
            case 8: {
                NBTTagCompound nbt = this.getSel();
                if (nbt == null) break;
                String id = nbt.func_74779_i("id");
                if (id.equals("even")) {
                    id = "center";
                } else if (id.equals("center")) {
                    id = "gauss";
                } else {
                    if (!id.equals("gauss")) break;
                    id = "even";
                }
                nbt.func_74778_a("id", id);
                this.select(s);
                break;
            }
            default: {
                super.func_146284_a(b);
            }
        }
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
        NBTTagCompound nbt = this.getSel();
        if (nbt == null) {
            return;
        }
        switch (id) {
            case 6: {
                nbt.func_74777_a("bpv", (short)Math.round(value));
                break;
            }
            case 7: {
                nbt.func_74776_a("vpc", value);
            }
        }
    }

    public void func_175319_a(int id, String value) {
        NBTTagCompound nbt = this.getSel();
        if (nbt == null) {
            return;
        }
        String m = nbt.func_74779_i("id");
        switch (id) {
            case 4: {
                nbt.func_74778_a("ore", value);
                break;
            }
            case 5: {
                NBTTagList list = new NBTTagList();
                if (!value.isEmpty()) {
                    for (String e : value.split(",")) {
                        list.func_74742_a((NBTBase)new NBTTagString(e.trim()));
                    }
                }
                nbt.func_74782_a("target", (NBTBase)list);
                break;
            }
            case 9: {
                try {
                    if (!m.equals("even") && !m.equals("center")) break;
                    nbt.func_74777_a("minY", (short)Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 10: {
                try {
                    if (m.equals("even") || m.equals("center")) {
                        nbt.func_74777_a("maxY", (short)Integer.parseInt(value));
                        break;
                    }
                    if (!m.equals("gauss")) break;
                    nbt.func_74776_a("mainY", Float.parseFloat(value));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 11: {
                try {
                    if (m.equals("center")) {
                        nbt.func_74777_a("mainY", (short)Integer.parseInt(value));
                        break;
                    }
                    if (!m.equals("gauss")) break;
                    nbt.func_74776_a("devY", Float.parseFloat(value));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public void func_146281_b() {
        NBTTagList tl = new NBTTagList();
        for (Ore l : this.list.list) {
            tl.func_74742_a((NBTBase)l.nbt);
        }
        this.cfg.deserializeNBT((NBTBase)tl);
        super.func_146281_b();
    }

    static class Ore
    implements IDrawableEntry {
        final NBTTagCompound nbt;

        Ore(NBTTagCompound nbt) {
            this.nbt = nbt;
        }

        @Override
        public void draw(Minecraft mc, int x, int y, int w, int h, float t) {
            String s = TooltipUtil.format((String)("dimstack.ore._" + this.nbt.func_74779_i("id")), (Object[])new Object[]{this.nbt.func_74765_d("minY"), this.nbt.func_74765_d("maxY"), Float.valueOf(this.nbt.func_74760_g("mainY")), Float.valueOf(this.nbt.func_74760_g("devY"))});
            mc.field_71466_p.func_78276_b(s, x + (h + 20 + w - mc.field_71466_p.func_78256_a(s)) / 2, y + (h - mc.field_71466_p.field_78288_b) / 2, -256);
            String block = this.nbt.func_74779_i("ore");
            RenderUtil.drawPortrait(BlockPredicate.parse(block), x + 22, y, 0.0f, h);
            s = TooltipUtil.format((String)"\\%0.2u", (Object[])new Object[]{Math.rint((double)(this.nbt.func_74760_g("vpc") * (float)this.nbt.func_74765_d("bpv")) * 10.0) / 10.0});
            mc.field_71466_p.func_78276_b(s, x + 22 - mc.field_71466_p.func_78256_a(s), y + (h - mc.field_71466_p.field_78288_b) / 2, 0x80FF80);
        }
    }
}

