/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.block;

import cd4017be.api.recipes.ItemOperand;
import cd4017be.lib.block.BaseBlock;
import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.Number;
import cd4017be.lib.script.obj.Text;
import cd4017be.lib.util.TooltipUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ProgressionBarrier
extends BaseBlock
implements IOperand {
    public static final PropertyInteger variant = PropertyInteger.func_177719_a((String)"var", (int)0, (int)15);
    public ItemStack[][] requiredTools = new ItemStack[16][];
    public float[] hardness = new float[16];
    public float[] resistance = new float[16];
    public short witherProof;

    public ProgressionBarrier(String id, Material m) {
        super(id, m);
    }

    public void func_190948_a(ItemStack stack, World player, List<String> list, ITooltipFlag advanced) {
        String name = this.func_149739_a();
        list.add(TooltipUtil.translate((String)(name + ".tools")));
        int i = stack.func_77960_j();
        ItemStack[] tools = this.requiredTools[i];
        if (tools == null) {
            IBlockState state = this.func_176203_a(i);
            String tool = this.getHarvestTool(state);
            if (tool != null) {
                list.add(TooltipUtil.format((String)("dimstack.toollvl." + tool), (Object[])new Object[]{this.getHarvestLevel(state)}));
            }
        } else {
            for (ItemStack tool : tools) {
                list.add("- " + tool.func_82833_r());
            }
        }
        list.add(TooltipUtil.format((String)(name + ".expl"), (Object[])new Object[]{this.resistance[i] > 1000000.0f}));
        list.add(TooltipUtil.format((String)(name + ".mob"), (Object[])new Object[]{(this.witherProof >> i & 1) != 0}));
        super.func_190948_a(stack, player, list, advanced);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < 16; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)variant);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        if (!this.canBreak(state, player.func_184614_ca()) && !this.canBreak(state, player.func_184592_cb())) {
            return 0.0f;
        }
        return ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
    }

    private boolean canBreak(IBlockState state, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        ItemStack[] ref = this.requiredTools[(Integer)state.func_177229_b((IProperty)variant)];
        if (ref == null) {
            String tool = this.getHarvestTool(state);
            return tool == null || stack.func_77973_b().getHarvestLevel(stack, tool, null, state) >= this.getHarvestLevel(state);
        }
        for (ItemStack r : ref) {
            if (r == null || !stack.func_185136_b(r)) continue;
            return true;
        }
        return false;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return this.getHarvestTool(world.func_180495_p(pos)) == null || super.canHarvestBlock(world, pos, player);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.hardness[(Integer)state.func_177229_b((IProperty)variant)] >= 0.0f) {
            return false;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!this.canBreak(state, stack)) {
            return false;
        }
        this.removedByPlayer(state, worldIn, pos, playerIn, true);
        this.func_180657_a(worldIn, playerIn, pos, state, null, stack);
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)variant, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)variant);
    }

    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        return this.hardness[(Integer)state.func_177229_b((IProperty)variant)];
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{variant});
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.resistance[(Integer)world.func_180495_p(pos).func_177229_b((IProperty)variant)] / 5.0f;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return (this.witherProof >> (Integer)state.func_177229_b((IProperty)variant) & 1) == 0;
    }

    public boolean asBool() throws Error {
        return true;
    }

    public Object value() {
        return this;
    }

    public IOperand get(IOperand idx) {
        int i = idx.asIndex();
        if (i < 0 || i >= 16) {
            return Nil.NIL;
        }
        Object[] tools = this.requiredTools[i];
        IBlockState state = this.func_176203_a(i);
        String tool = this.getHarvestTool(state);
        int lvl = this.getHarvestLevel(state);
        return new Array(new IOperand[]{tools == null ? Nil.NIL : new Array(tools, ItemOperand::new), new Text(tool == null ? "" : tool + ":" + lvl), new Number((double)this.hardness[i]), new Number((double)this.resistance[i]), new Number((double)(this.witherProof >> i & 1))});
    }

    public void put(IOperand idx, IOperand val) {
        int i = idx.asIndex();
        if (i < 0 || i >= 16) {
            return;
        }
        if (val instanceof Array) {
            Object[] arr = ((Array)val).value();
            switch (arr.length) {
                default: {
                    Object el = arr[4];
                    if (el instanceof Double) {
                        this.witherProof = (Double)el > 0.5 ? (short)(this.witherProof | 1 << i) : (short)(this.witherProof & ~(1 << i));
                    }
                }
                case 4: {
                    Object el = arr[3];
                    if (el instanceof Double) {
                        this.resistance[i] = ((Double)el).floatValue();
                    }
                }
                case 3: {
                    Object el = arr[2];
                    if (el instanceof Double) {
                        this.hardness[i] = ((Double)el).floatValue();
                    }
                }
                case 2: {
                    Object el = arr[1];
                    if (el instanceof String) {
                        String s = (String)el;
                        int p = s.indexOf(58);
                        int lvl = 0;
                        if (p >= 0) {
                            try {
                                lvl = Integer.parseInt(s.substring(p + 1));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            s = s.substring(0, p);
                        }
                        this.setHarvestLevel(s.isEmpty() ? null : s, lvl, this.func_176203_a(i));
                    }
                }
                case 1: {
                    Object el = arr[0];
                    this.requiredTools[i] = el instanceof ItemStack ? new ItemStack[]{(ItemStack)el} : (el instanceof Object[] ? (ItemStack[])Arrays.copyOf((Object[])el, ((Object[])el).length, ItemStack[].class) : null);
                }
                case 0: 
            }
        }
    }
}

