/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities.flying;

import com.Fishmod.mod_LavaCow.entities.flying.EntityFlyingMob;
import com.Fishmod.mod_LavaCow.init.Modkeys;
import com.Fishmod.mod_LavaCow.message.PacketMountSpecial;
import com.Fishmod.mod_LavaCow.mod_LavaCow;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRideableFlyingMob
extends EntityFlyingMob {
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(EntityRideableFlyingMob.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityRideableFlyingMob.class, (DataSerializer)DataSerializers.field_187191_a);
    public int abilityCooldown = 0;
    protected int spellTicks;

    public EntityRideableFlyingMob(World worldIn, int heightLimit) {
        super(worldIn, heightLimit);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AICastingSpell());
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SADDLED, (Object)false);
        this.func_184212_Q().func_187214_a(CONTROL_STATE, (Object)0);
    }

    public boolean isSpellcasting() {
        return this.spellTicks > 0;
    }

    public int getSpellTicks() {
        return this.spellTicks;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean actionResultType;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean flag = this.func_70877_b(itemstack);
        if (!flag && this.func_152114_e((EntityLivingBase)player) && this.getSaddled() && !this.func_184207_aI()) {
            if (itemstack.func_77973_b() instanceof ItemShears) {
                this.setSaddled(false);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_145779_a(Items.field_151141_av, 1);
                }
                return true;
            }
            if (!player.func_70093_af() && !player.func_184218_aH()) {
                player.func_184220_m((Entity)this);
                return true;
            }
        }
        if (actionResultType = itemstack.func_111282_a(player, (EntityLivingBase)this, hand)) {
            return actionResultType;
        }
        return super.func_184645_a(player, hand);
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.9;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z = passenger.field_70177_z;
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)passenger;
            if (!this.func_70909_n() || this.func_184753_b() == null || !this.func_184753_b().equals(player.func_110124_au())) continue;
            return player;
        }
        return null;
    }

    public boolean canBeControlledByRider() {
        return this.func_184179_bs() instanceof EntityPlayer;
    }

    public boolean isRidingPlayer(EntityPlayer player) {
        return this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer && this.func_184179_bs().func_110124_au().equals(player.func_110124_au());
    }

    public int abilityCooldown() {
        return 0;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        }
        if (this.spellTicks > 0) {
            --this.spellTicks;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        if (this.isUp() && !this.isDown()) {
            this.field_70181_x += (double)0.05f;
        }
        if (!this.isUp() && this.isDown()) {
            this.field_70181_x += (double)-0.05f;
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.ClientControl();
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void ClientControl() {
        Minecraft game = Minecraft.func_71410_x();
        if (this.abilityCooldown == 0 && Modkeys.MOUNT_SPECIAL.func_151470_d() && this.isRidingPlayer((EntityPlayer)game.field_71439_g) && this.getLandTimer() <= 10) {
            this.abilityCooldown = this.abilityCooldown();
            mod_LavaCow.NETWORK_WRAPPER.sendToServer((IMessage)new PacketMountSpecial(this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v));
        }
        if (this.isRidingPlayer((EntityPlayer)game.field_71439_g)) {
            this.setControlState(0, game.field_71474_y.field_74314_A.func_151470_d());
            this.setControlState(1, Modkeys.MOUNT_SPECIAL.func_151470_d());
        }
    }

    public void setSaddled(boolean saddled) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)this.getSaddled());
    }

    public boolean getSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    private boolean isUp() {
        return ((Byte)this.func_184212_Q().func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    private boolean isDown() {
        return ((Byte)this.func_184212_Q().func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    private void setControlState(int byteLoc, boolean stateIn) {
        byte prevState = (Byte)this.func_184212_Q().func_187225_a(CONTROL_STATE);
        if (stateIn) {
            this.func_184212_Q().func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << byteLoc)));
        } else {
            this.func_184212_Q().func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << byteLoc))));
        }
    }

    @Override
    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.getSaddled() && this.func_82171_bF()) {
                EntityLivingBase controller = (EntityLivingBase)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = controller.field_70177_z;
                this.field_70125_A = controller.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70761_aq = this.field_70177_z;
                this.field_70759_as = this.field_70177_z;
                this.field_70138_W = 1.0f;
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                strafe = controller.field_70702_br * 0.5f;
                forward = controller.field_191988_bg;
                if (this.func_184186_bw()) {
                    float f = (float)this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111126_e() * 0.6f;
                    this.func_70659_e(f);
                    super.func_191986_a(strafe, vertical, forward);
                } else {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d1 = this.field_70165_t - this.field_70169_q;
                double d0 = this.field_70161_v - this.field_70166_s;
                float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                super.func_191986_a(strafe, vertical, forward);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.getSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    public class AICastingSpell
    extends EntityAIBase {
        public AICastingSpell() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return EntityRideableFlyingMob.this.getSpellTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityRideableFlyingMob.this.field_70699_by.func_75499_g();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            if (EntityRideableFlyingMob.this.func_70638_az() != null) {
                EntityRideableFlyingMob.this.func_70671_ap().func_75651_a((Entity)EntityRideableFlyingMob.this.func_70638_az(), (float)EntityRideableFlyingMob.this.func_184649_cE(), (float)EntityRideableFlyingMob.this.func_70646_bf());
            }
        }
    }
}

