/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.fluid;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.config.NCConfig;
import nc.tile.ITile;
import nc.tile.fluid.IFluidSpread;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.passive.ITilePassive;
import nc.util.BlockHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public interface ITileFluid
extends ITile {
    @Nonnull
    public List<Tank> getTanks();

    default public boolean isNextToFill(@Nonnull EnumFacing side, int tankNumber, FluidStack resource) {
        if (!this.getInputTanksSeparated()) {
            return true;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (i == tankNumber || !this.getTankSorption(side, i).canFill() || this.getTanks().get(i).getFluid() == null || !this.getTanks().get(i).getFluid().isFluidEqual(resource)) continue;
            return false;
        }
        return true;
    }

    default public void clearTank(int tankNumber) {
        this.getTanks().get(tankNumber).setFluidStored(null);
    }

    default public void clearAllTanks() {
        for (Tank tank : this.getTanks()) {
            tank.setFluidStored(null);
        }
    }

    @Nonnull
    public FluidConnection[] getFluidConnections();

    public void setFluidConnections(@Nonnull FluidConnection[] var1);

    @Nonnull
    default public FluidConnection getFluidConnection(@Nonnull EnumFacing side) {
        return this.getFluidConnections()[side.func_176745_a()];
    }

    @Nonnull
    default public TankSorption getTankSorption(@Nonnull EnumFacing side, int tankNumber) {
        return this.getFluidConnections()[side.func_176745_a()].getTankSorption(tankNumber);
    }

    default public void setTankSorption(@Nonnull EnumFacing side, int tankNumber, @Nonnull TankSorption sorption) {
        this.getFluidConnections()[side.func_176745_a()].setTankSorption(tankNumber, sorption);
    }

    default public void toggleTankSorption(@Nonnull EnumFacing side, int tankNumber, TankSorption.Type type, boolean reverse) {
        if (!this.hasConfigurableFluidConnections()) {
            return;
        }
        this.getFluidConnection(side).toggleTankSorption(tankNumber, type, reverse);
        this.markDirtyAndNotify();
    }

    default public boolean canConnectFluid(@Nonnull EnumFacing side) {
        return this.getFluidConnection(side).canConnect();
    }

    public static FluidConnection[] fluidConnectionAll(@Nonnull List<TankSorption> sorptionList) {
        FluidConnection[] array = new FluidConnection[6];
        for (int i = 0; i < 6; ++i) {
            array[i] = new FluidConnection(sorptionList);
        }
        return array;
    }

    public static FluidConnection[] fluidConnectionAll(TankSorption sorption) {
        return ITileFluid.fluidConnectionAll(Lists.newArrayList((Object[])new TankSorption[]{sorption}));
    }

    default public boolean hasConfigurableFluidConnections() {
        return false;
    }

    @Nonnull
    default public IFluidTankProperties[] getTankProperties(@Nonnull EnumFacing side) {
        if (this.getTanks().isEmpty()) {
            return EmptyFluidHandler.EMPTY_TANK_PROPERTIES_ARRAY;
        }
        IFluidTankProperties[] properties = new IFluidTankProperties[this.getTanks().size()];
        for (int i = 0; i < this.getTanks().size(); ++i) {
            properties[i] = this.getTanks().get(i).getFluidTankProperties();
        }
        return properties;
    }

    default public int fill(@Nonnull EnumFacing side, FluidStack resource, boolean doFill) {
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (!this.getTankSorption(side, i).canFill() || !this.getTanks().get(i).canFillFluidType(resource) || !this.isNextToFill(side, i, resource) || this.getTanks().get(i).getFluidAmount() >= this.getTanks().get(i).getCapacity() || this.getTanks().get(i).getFluid() != null && !this.getTanks().get(i).getFluid().isFluidEqual(resource)) continue;
            return this.getTanks().get(i).fill(resource, doFill);
        }
        return 0;
    }

    default public FluidStack drain(@Nonnull EnumFacing side, FluidStack resource, boolean doDrain) {
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (!this.getTankSorption(side, i).canDrain() || this.getTanks().get(i).getFluidAmount() <= 0 || !resource.isFluidEqual(this.getTanks().get(i).getFluid()) || this.getTanks().get(i).drain(resource, false) == null || this.getTanks().get(i).drain(resource, false) == null) continue;
            return this.getTanks().get(i).drain(resource, doDrain);
        }
        return null;
    }

    default public FluidStack drain(@Nonnull EnumFacing side, int maxDrain, boolean doDrain) {
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (!this.getTankSorption(side, i).canDrain() || this.getTanks().get(i).getFluidAmount() <= 0 || this.getTanks().get(i).drain(maxDrain, false) == null || this.getTanks().get(i).drain(maxDrain, false) == null) continue;
            return this.getTanks().get(i).drain(maxDrain, doDrain);
        }
        return null;
    }

    @Nonnull
    public FluidTileWrapper[] getFluidSides();

    @Nonnull
    default public FluidTileWrapper getFluidSide(@Nonnull EnumFacing side) {
        return this.getFluidSides()[side.func_176745_a()];
    }

    @Nonnull
    public static FluidTileWrapper[] getDefaultFluidSides(@Nonnull ITileFluid tile) {
        return new FluidTileWrapper[]{new FluidTileWrapper(tile, EnumFacing.DOWN), new FluidTileWrapper(tile, EnumFacing.UP), new FluidTileWrapper(tile, EnumFacing.NORTH), new FluidTileWrapper(tile, EnumFacing.SOUTH), new FluidTileWrapper(tile, EnumFacing.WEST), new FluidTileWrapper(tile, EnumFacing.EAST)};
    }

    @Nonnull
    public GasTileWrapper getGasWrapper();

    default public void pushFluid() {
        if (this.getTanks().isEmpty()) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.pushFluidToSide(side);
        }
    }

    default public void spreadFluid() {
        if (!NCConfig.passive_permeation || this.getTanks().isEmpty()) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.spreadFluidToSide(side);
        }
    }

    default public void pushFluidToSide(@Nonnull EnumFacing side) {
        if (!this.getFluidConnection(side).canConnect()) {
            return;
        }
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (tile == null || tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
            return;
        }
        IFluidHandler adjStorage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        if (adjStorage == null) {
            return;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (!this.getTankSorption(side, i).canDrain() || this.getTanks().get(i).getFluid() == null) continue;
            this.getTanks().get(i).drain(adjStorage.fill(this.getTanks().get(i).drain(this.getTanks().get(i).getCapacity(), false), true), true);
        }
    }

    default public void spreadFluidToSide(@Nonnull EnumFacing side) {
        if (!this.getFluidConnection(side).canConnect()) {
            return;
        }
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (tile instanceof IFluidSpread) {
            if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
                return;
            }
            IFluidSpread other = (IFluidSpread)tile;
            for (int i = 0; i < this.getTanks().size(); ++i) {
                int diff = this.getTanks().get(i).getFluidAmount() - other.getTanks().get(0).getFluidAmount();
                if (diff <= 1) continue;
                this.getTanks().get(i).drain(other.getTanks().get(0).fillInternal(this.getTanks().get(i).drain(diff / 2, false), true), true);
            }
        }
    }

    default public NBTTagCompound writeTanks(NBTTagCompound nbt) {
        for (int i = 0; i < this.getTanks().size(); ++i) {
            this.getTanks().get(i).writeToNBT(nbt, i);
        }
        return nbt;
    }

    default public void readTanks(NBTTagCompound nbt) {
        if (nbt.func_74764_b("fluidName0")) {
            for (int i = 0; i < this.getTanks().size(); ++i) {
                if (nbt.func_74779_i("fluidName" + i).equals("nullFluid") || nbt.func_74762_e("fluidAmount" + i) == 0) {
                    this.getTanks().get(i).setFluidStored(null);
                    continue;
                }
                this.getTanks().get(i).setFluidStored(FluidRegistry.getFluid((String)nbt.func_74779_i("fluidName" + i)), nbt.func_74762_e("fluidAmount" + i));
            }
        } else {
            for (int i = 0; i < this.getTanks().size(); ++i) {
                this.getTanks().get(i).readFromNBT(nbt, i);
            }
        }
    }

    default public NBTTagCompound writeFluidConnections(NBTTagCompound nbt) {
        return this.writeFluidConnectionsNormalized(nbt, EnumFacing.WEST);
    }

    default public NBTTagCompound writeFluidConnectionsNormalized(NBTTagCompound nbt, EnumFacing facing) {
        this.getFluidConnection(BlockHelper.bottom(facing)).writeToNBT(nbt, EnumFacing.DOWN);
        this.getFluidConnection(BlockHelper.top(facing)).writeToNBT(nbt, EnumFacing.UP);
        this.getFluidConnection(BlockHelper.left(facing)).writeToNBT(nbt, EnumFacing.NORTH);
        this.getFluidConnection(BlockHelper.right(facing)).writeToNBT(nbt, EnumFacing.SOUTH);
        this.getFluidConnection(BlockHelper.front(facing)).writeToNBT(nbt, EnumFacing.WEST);
        this.getFluidConnection(BlockHelper.back(facing)).writeToNBT(nbt, EnumFacing.EAST);
        return nbt;
    }

    default public void readFluidConnections(NBTTagCompound nbt) {
        if (!this.hasConfigurableFluidConnections()) {
            return;
        }
        if (nbt.func_74764_b("fluidConnections0")) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (!nbt.func_74764_b("fluidConnections" + side.func_176745_a())) continue;
                for (int i = 0; i < this.getTanks().size(); ++i) {
                    this.getFluidConnection(side).setTankSorption(i, TankSorption.values()[nbt.func_74762_e("fluidConnections" + side.func_176745_a())]);
                }
            }
        } else {
            this.readFluidConnectionsNormalized(nbt, EnumFacing.WEST);
        }
    }

    default public void readFluidConnectionsNormalized(NBTTagCompound nbt, EnumFacing facing) {
        if (!this.hasConfigurableFluidConnections()) {
            return;
        }
        this.getFluidConnection(BlockHelper.bottom(facing)).readFromNBT(nbt, EnumFacing.DOWN);
        this.getFluidConnection(BlockHelper.top(facing)).readFromNBT(nbt, EnumFacing.UP);
        this.getFluidConnection(BlockHelper.left(facing)).readFromNBT(nbt, EnumFacing.NORTH);
        this.getFluidConnection(BlockHelper.right(facing)).readFromNBT(nbt, EnumFacing.SOUTH);
        this.getFluidConnection(BlockHelper.front(facing)).readFromNBT(nbt, EnumFacing.WEST);
        this.getFluidConnection(BlockHelper.back(facing)).readFromNBT(nbt, EnumFacing.EAST);
    }

    default public NBTTagCompound writeTankSettings(NBTTagCompound nbt) {
        nbt.func_74757_a("inputTanksSeparated", this.getInputTanksSeparated());
        for (int i = 0; i < this.getTanks().size(); ++i) {
            nbt.func_74757_a("voidUnusableFluidInput" + i, this.getVoidUnusableFluidInput(i));
            nbt.func_74768_a("tankOutputSetting" + i, this.getTankOutputSetting(i).ordinal());
        }
        return nbt;
    }

    default public void readTankSettings(NBTTagCompound nbt) {
        if (nbt.func_74764_b("areTanksShared")) {
            this.setInputTanksSeparated(nbt.func_74767_n("areTanksShared"));
            for (int i = 0; i < this.getTanks().size(); ++i) {
                this.setVoidUnusableFluidInput(i, nbt.func_74767_n("emptyUnusable"));
                int ordinal = nbt.func_74764_b("voidExcessOutputs") ? (nbt.func_74767_n("voidExcessOutputs") ? 1 : 0) : nbt.func_74762_e("tankOutputSetting" + i);
                this.setTankOutputSetting(i, TankOutputSetting.values()[ordinal]);
            }
        } else {
            this.setInputTanksSeparated(nbt.func_74767_n("inputTanksSeparated"));
            for (int i = 0; i < this.getTanks().size(); ++i) {
                this.setVoidUnusableFluidInput(i, nbt.func_74767_n("voidUnusableFluidInput" + i));
                int ordinal = nbt.func_74764_b("voidExcessFluidOutput" + i) ? (nbt.func_74767_n("voidExcessFluidOutput" + i) ? 1 : 0) : nbt.func_74762_e("tankOutputSetting" + i);
                this.setTankOutputSetting(i, TankOutputSetting.values()[ordinal]);
            }
        }
    }

    public boolean getInputTanksSeparated();

    public void setInputTanksSeparated(boolean var1);

    public boolean getVoidUnusableFluidInput(int var1);

    public void setVoidUnusableFluidInput(int var1, boolean var2);

    public TankOutputSetting getTankOutputSetting(int var1);

    public void setTankOutputSetting(int var1, TankOutputSetting var2);

    default public boolean hasFluidSideCapability(@Nullable EnumFacing side) {
        return side == null || this.getFluidConnection(side).canConnect();
    }
}

