/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.energy;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.tile.energy.TileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.InventoryTileWrapper;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.inventory.ITileInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEnergyInventory
extends TileEnergy
implements ITileInventory {
    @Nonnull
    private String inventoryName;
    @Nonnull
    private NonNullList<ItemStack> inventoryStacks;
    @Nonnull
    private InventoryConnection[] inventoryConnections;
    @Nonnull
    private InventoryTileWrapper invWrapper;
    @Nonnull
    private List<ItemOutputSetting> itemOutputSettings;

    public TileEnergyInventory(String name, int size, @Nonnull InventoryConnection[] inventoryConnections, int capacity, @Nonnull EnergyConnection[] energyConnections) {
        this(name, size, inventoryConnections, capacity, capacity, energyConnections);
    }

    public TileEnergyInventory(String name, int size, @Nonnull InventoryConnection[] inventoryConnections, int capacity, int maxTransfer, @Nonnull EnergyConnection[] energyConnections) {
        super(capacity, maxTransfer, energyConnections);
        this.inventoryName = "nuclearcraft.container." + name;
        this.inventoryStacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.inventoryConnections = inventoryConnections;
        this.invWrapper = new InventoryTileWrapper<TileEnergyInventory>(this);
        this.itemOutputSettings = new ArrayList<ItemOutputSetting>();
        for (int i = 0; i < size; ++i) {
            this.itemOutputSettings.add(ItemOutputSetting.DEFAULT);
        }
    }

    @Override
    public String getName() {
        return this.inventoryName;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacks() {
        return this.inventoryStacks;
    }

    @Override
    @Nonnull
    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    @Override
    public void setInventoryConnections(@Nonnull InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    @Override
    @Nonnull
    public InventoryTileWrapper getInventory() {
        return this.invWrapper;
    }

    @Override
    public ItemOutputSetting getItemOutputSetting(int slot) {
        return this.itemOutputSettings.get(slot);
    }

    @Override
    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
        this.itemOutputSettings.set(slot, setting);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        this.writeSlotSettings(nbt);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
        this.readSlotSettings(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return !this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side)) {
                return (T)this.getItemHandlerCapability(null);
            }
            return null;
        }
        return super.getCapability(capability, side);
    }
}

