/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.dummy;

import li.cil.oc.api.Network;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.recipe.NCRecipes;
import nc.tile.dummy.TileDummy;
import nc.tile.energyFluid.IBufferable;
import nc.tile.fluid.ITileFluid;
import nc.tile.generator.TileFusionCore;
import nc.tile.internal.fluid.TankSorption;
import nc.util.BlockFinder;
import nc.util.BlockPosHelper;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers")
public abstract class TileFusionDummy
extends TileDummy<TileFusionCore>
implements IBufferable,
Environment {
    Object oc_node;
    private BlockFinder finder;

    public TileFusionDummy(String name) {
        super(TileFusionCore.class, name, NCConfig.machine_update_rate, NCRecipes.fusion_valid_fluids.get(0), ITileFluid.fluidConnectionAll(TankSorption.BOTH));
    }

    @Override
    public void onAdded() {
        this.finder = new BlockFinder(this.field_174879_c, this.field_145850_b);
        super.onAdded();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (ModCheck.openComputersLoaded()) {
                this.refreshNode();
            }
            this.pushEnergy();
            if (this.checkCount == 0 && this.findAdjacentComparator()) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (ModCheck.openComputersLoaded()) {
            this.removeNode();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (ModCheck.openComputersLoaded()) {
            this.removeNode();
        }
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        if (this.hasMaster()) {
            return !((TileFusionCore)this.getMaster()).isHotEnough();
        }
        return false;
    }

    @Override
    public boolean canExtractEnergy(EnumFacing side) {
        if (this.hasMaster()) {
            return ((TileFusionCore)this.getMaster()).isHotEnough();
        }
        return false;
    }

    protected boolean findCore(BlockPos pos) {
        return this.finder.find(pos, NCBlocks.fusion_core);
    }

    public boolean findAdjacentComparator() {
        return this.finder.horizontalYCount(this.field_174879_c, 1, Blocks.field_150441_bU, Blocks.field_150455_bV) > 0;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        if (this.hasMaster()) {
            nbt.func_74780_a("processPower", ((TileFusionCore)this.getMaster()).processPower);
            nbt.func_74768_a("size", ((TileFusionCore)this.getMaster()).size);
        }
        return nbt;
    }

    @Optional.Method(modid="opencomputers")
    public void removeNode() {
        if (this.oc_node instanceof Node) {
            ((Node)this.oc_node).remove();
        }
    }

    @Optional.Method(modid="opencomputers")
    public void refreshNode() {
        if (this.node() == null) {
            this.oc_node = Network.newNode((Environment)this, (Visibility)Visibility.None).create();
        }
        if (this.node() != null && this.node().network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return (Node)this.oc_node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(Message message) {
    }

    public static class Top
    extends TileFusionDummy {
        public Top() {
            super("fusion_dummy_top");
        }

        @Override
        public void findMaster() {
            BlockPosHelper helper = new BlockPosHelper(this.field_174879_c);
            for (BlockPos pos : helper.cuboid(-1, -2, -1, 1, -2, 1)) {
                if (!this.findCore(pos)) continue;
                this.masterPosition = pos;
                return;
            }
            this.masterPosition = null;
        }
    }

    public static class Side
    extends TileFusionDummy {
        public Side() {
            super("fusion_dummy_side");
        }

        @Override
        public void findMaster() {
            BlockPosHelper helper = new BlockPosHelper(this.field_174879_c);
            for (BlockPos pos : helper.cuboid(-1, -1, -1, 1, 0, 1)) {
                if (!this.findCore(pos)) continue;
                this.masterPosition = pos;
                return;
            }
            this.masterPosition = null;
        }
    }
}

