/*
 * Decompiled with CFR 0.152.
 */
package nc.network.tile;

import io.netty.buffer.ByteBuf;
import nc.tile.ITile;
import nc.util.NCUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class TileUpdatePacket
implements IMessage {
    protected boolean messageValid = false;
    protected BlockPos pos;

    public abstract void readMessage(ByteBuf var1);

    public abstract void writeMessage(ByteBuf var1);

    public void fromBytes(ByteBuf buf) {
        try {
            this.readMessage(buf);
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        this.writeMessage(buf);
    }

    public static abstract class Handler<MESSAGE extends TileUpdatePacket, TILE>
    implements IMessageHandler<MESSAGE, IMessage> {
        public IMessage onMessage(MESSAGE message, MessageContext ctx) {
            if (!((TileUpdatePacket)message).messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.processMessage(message));
            return null;
        }

        protected void processMessage(MESSAGE message) {
            TileEntity tile = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175625_s(((TileUpdatePacket)message).pos);
            if (tile instanceof ITile) {
                this.onPacket(message, tile);
            }
        }

        protected abstract void onPacket(MESSAGE var1, TILE var2);
    }
}

