/*
 * Decompiled with CFR 0.152.
 */
package nc.network.gui;

import io.netty.buffer.ByteBuf;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.inventory.ITileInventory;
import nc.util.NCUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ToggleItemOutputSettingPacket
implements IMessage {
    boolean messageValid;
    BlockPos pos;
    int slot;
    int setting;

    public ToggleItemOutputSettingPacket() {
        this.messageValid = false;
    }

    public ToggleItemOutputSettingPacket(ITileInventory machine, int slot, ItemOutputSetting setting) {
        this.pos = machine.getTilePos();
        this.slot = slot;
        this.setting = setting.ordinal();
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.slot = buf.readInt();
            this.setting = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.slot);
        buf.writeInt(this.setting);
    }

    public static class Handler
    implements IMessageHandler<ToggleItemOutputSettingPacket, IMessage> {
        public IMessage onMessage(ToggleItemOutputSettingPacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(ToggleItemOutputSettingPacket message, MessageContext ctx) {
            TileEntity tile = ctx.getServerHandler().field_147369_b.func_71121_q().func_175625_s(message.pos);
            if (tile instanceof ITileInventory) {
                ITileInventory machine = (ITileInventory)tile;
                ItemOutputSetting setting = ItemOutputSetting.values()[message.setting];
                machine.setItemOutputSetting(message.slot, setting);
                if (setting == ItemOutputSetting.VOID) {
                    machine.getInventoryStacks().set(message.slot, (Object)ItemStack.field_190927_a);
                }
                machine.markDirtyAndNotify();
            }
        }
    }
}

