/*
 * Decompiled with CFR 0.152.
 */
package nc.network.gui;

import io.netty.buffer.ByteBuf;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.TankSorption;
import nc.util.NCUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ResetTankSorptionsPacket
implements IMessage {
    boolean messageValid;
    BlockPos pos;
    int tank;
    boolean defaults;

    public ResetTankSorptionsPacket() {
        this.messageValid = false;
    }

    public ResetTankSorptionsPacket(ITileFluid machine, int tank, boolean defaults) {
        this.pos = machine.getTilePos();
        this.tank = tank;
        this.defaults = defaults;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.tank = buf.readInt();
            this.defaults = buf.readBoolean();
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.tank);
        buf.writeBoolean(this.defaults);
    }

    public static class Handler
    implements IMessageHandler<ResetTankSorptionsPacket, IMessage> {
        public IMessage onMessage(ResetTankSorptionsPacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(ResetTankSorptionsPacket message, MessageContext ctx) {
            TileEntity tile = ctx.getServerHandler().field_147369_b.func_71121_q().func_175625_s(message.pos);
            if (tile instanceof ITileFluid) {
                ITileFluid machine = (ITileFluid)tile;
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    if (message.defaults) {
                        machine.setTankSorption(side, message.tank, machine.getFluidConnection(side).getDefaultTankSorption(message.tank));
                        continue;
                    }
                    machine.setTankSorption(side, message.tank, TankSorption.NON);
                }
                machine.markDirtyAndNotify();
            }
        }
    }
}

