/*
 * Decompiled with CFR 0.152.
 */
package nc.network.gui;

import io.netty.buffer.ByteBuf;
import nc.NuclearCraft;
import nc.tile.IGui;
import nc.util.NCUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class OpenTileGuiPacket
implements IMessage {
    boolean messageValid;
    BlockPos pos;

    public OpenTileGuiPacket() {
        this.messageValid = false;
    }

    public OpenTileGuiPacket(IGui machine) {
        this.pos = machine.getTilePos();
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    public static class Handler
    implements IMessageHandler<OpenTileGuiPacket, IMessage> {
        public IMessage onMessage(OpenTileGuiPacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(OpenTileGuiPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            TileEntity tile = player.func_71121_q().func_175625_s(message.pos);
            if (tile instanceof IGui) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)NuclearCraft.instance, (int)((IGui)tile).getGuiID(), (World)player.func_71121_q(), (int)message.pos.func_177958_n(), (int)message.pos.func_177956_o(), (int)message.pos.func_177952_p());
                ((IGui)tile).beginUpdatingPlayer((EntityPlayer)player);
            }
        }
    }
}

