/*
 * Decompiled with CFR 0.152.
 */
package nc.item.energy;

import gregtech.api.capability.IElectricItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import nc.config.NCConfig;
import nc.tile.internal.energy.EnergyStorage;
import nc.util.EnergyHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="gregtech.api.capability.IElectricItem", modid="gregtech")
public class ItemEnergyWrapperGT
implements IElectricItem {
    protected ItemStack stack;
    protected EnergyStorage storage;
    protected int energyTier;
    public List<BiConsumer<ItemStack, Long>> listeners = new ArrayList<BiConsumer<ItemStack, Long>>();

    public ItemEnergyWrapperGT(ItemStack stack, EnergyStorage storage, int energyTier) {
        this.stack = stack;
        this.storage = storage;
        this.energyTier = energyTier;
    }

    @Optional.Method(modid="gregtech")
    public boolean canProvideChargeExternally() {
        return true;
    }

    @Optional.Method(modid="gregtech")
    public boolean chargeable() {
        return true;
    }

    @Optional.Method(modid="gregtech")
    public void addChargeListener(BiConsumer<ItemStack, Long> chargeListener) {
        this.listeners.add(chargeListener);
    }

    @Optional.Method(modid="gregtech")
    public long charge(long amount, int chargerTier, boolean ignoreTransferLimit, boolean simulate) {
        if (this.storage.canReceive() && this.energyTier >= chargerTier) {
            if (!ignoreTransferLimit) {
                amount = Math.min(amount, (long)EnergyHelper.getMaxEUFromTier(this.energyTier));
            }
            int charged = (int)Math.min(Math.min(amount, this.getMaxCharge() - this.getCharge()), Integer.MAX_VALUE);
            if (!simulate) {
                this.changeCharge(charged);
            }
            return charged;
        }
        return 0L;
    }

    @Optional.Method(modid="gregtech")
    public long discharge(long amount, int dischargerTier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if ((this.storage.canExtract() || !externally) && dischargerTier >= this.energyTier) {
            if (!ignoreTransferLimit) {
                amount = Math.min(amount, (long)EnergyHelper.getMaxEUFromTier(this.energyTier));
            }
            int discharged = (int)Math.min(Math.min(amount, this.getCharge()), Integer.MAX_VALUE);
            if (!simulate) {
                this.changeCharge(-discharged);
            }
            return discharged;
        }
        return 0L;
    }

    public long getCharge() {
        return this.storage.getEnergyStored() / NCConfig.rf_per_eu;
    }

    public void changeCharge(int change) {
        this.storage.changeEnergyStored(change * NCConfig.rf_per_eu);
        this.listeners.forEach(listener -> listener.accept(this.stack, Long.valueOf(change)));
    }

    @Optional.Method(modid="gregtech")
    public long getMaxCharge() {
        return this.storage.getMaxEnergyStored() / NCConfig.rf_per_eu;
    }

    @Optional.Method(modid="gregtech")
    public long getTransferLimit() {
        return EnergyHelper.getMaxEUFromTier(1 + this.energyTier);
    }

    @Optional.Method(modid="gregtech")
    public boolean canUse(long amount) {
        return this.getCharge() >= amount;
    }

    @Optional.Method(modid="gregtech")
    public int getTier() {
        return this.energyTier;
    }
}

