/*
 * Decompiled with CFR 0.152.
 */
package nc.item;

import java.util.List;
import javax.annotation.Nullable;
import nc.init.NCItems;
import nc.item.NCItem;
import nc.tile.fluid.ITileFluid;
import nc.tile.inventory.ITileInventory;
import nc.util.SoundHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemConfigurationBlueprint
extends NCItem {
    boolean isEmpty;

    public ItemConfigurationBlueprint(boolean isEmpty) {
        super(new String[0]);
        this.isEmpty = isEmpty;
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.isEmpty) {
            super.func_150895_a(tab, items);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K && playerIn.func_70093_af()) {
            ItemConfigurationBlueprint.playSoundAt(playerIn, SoundEvents.field_187750_dc, 0.5f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(NCItems.configuration_blueprint_empty));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ITileFluid fluids;
        if (world.field_72995_K && !player.func_70093_af()) {
            return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
        }
        TileEntity te = world.func_175625_s(pos);
        ITileInventory items = te instanceof ITileInventory ? (ITileInventory)te : null;
        ITileFluid iTileFluid = fluids = te instanceof ITileFluid ? (ITileFluid)te : null;
        if (items == null || !items.hasConfigurableInventoryConnections()) {
            return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
        }
        EnumFacing facing = items.getFacingHorizontal();
        if (player.func_70093_af()) {
            ItemConfigurationBlueprint.playSoundAt(player, SoundEvents.field_187604_bf, 0.5f, 1.0f);
            ItemStack stack = new ItemStack(NCItems.configuration_blueprint);
            NBTTagCompound stackNbt = new NBTTagCompound();
            stackNbt.func_74782_a("inventory_connections", (NBTBase)items.writeInventoryConnectionsNormalized(new NBTTagCompound(), facing));
            stackNbt.func_74782_a("slot_settings", (NBTBase)items.writeSlotSettings(new NBTTagCompound()));
            stackNbt.func_74757_a("redstone_control", items.getRedstoneControl());
            if (fluids != null && fluids.hasConfigurableFluidConnections()) {
                stackNbt.func_74782_a("fluid_connections", (NBTBase)fluids.writeFluidConnectionsNormalized(new NBTTagCompound(), facing));
                stackNbt.func_74782_a("tank_settings", (NBTBase)fluids.writeTankSettings(new NBTTagCompound()));
            }
            stackNbt.func_74778_a("name", items.getName());
            stackNbt.func_74778_a("class", items.getClass().getName());
            stack.func_77982_d(stackNbt);
            player.func_184611_a(hand, stack);
            return EnumActionResult.SUCCESS;
        }
        if (!this.isEmpty) {
            NBTTagCompound nbt = player.func_184586_b(hand).func_77978_p();
            if (nbt != null && nbt.func_74779_i("class").equals(items.getClass().getName())) {
                ItemConfigurationBlueprint.playSoundAt(player, SoundEvents.field_187604_bf, 0.5f, SoundHelper.getPitch(-1.0));
                items.readInventoryConnectionsNormalized(nbt.func_74775_l("inventory_connections"), facing);
                items.readSlotSettings(nbt.func_74775_l("slot_settings"));
                items.setRedstoneControl(nbt.func_74767_n("redstone_control"));
                if (fluids != null && nbt.func_74764_b("fluid_connections")) {
                    fluids.readFluidConnectionsNormalized(nbt.func_74775_l("fluid_connections"), facing);
                    fluids.readTankSettings(nbt.func_74775_l("tank_settings"));
                }
                items.markDirtyAndNotify();
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, tooltip, flag);
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("name")) {
            tooltip.add(I18n.func_135052_a((String)nbt.func_74779_i("name"), (Object[])new Object[0]));
        }
    }

    private static void playSoundAt(EntityPlayer player, SoundEvent sound, float volume, float pitch) {
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, SoundCategory.PLAYERS, volume, pitch);
    }
}

