/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.tconstruct.conarm;

import c4.conarm.common.armor.traits.ArmorTraits;
import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.materials.ArmorMaterials;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import nc.config.NCConfig;
import nc.integration.tconstruct.TConstructHelper;
import nc.integration.tconstruct.conarm.trait.NCArmorTraits;
import nc.util.CollectionHelper;
import nc.util.NCMath;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;

public class ConArmMaterials
extends ArmorMaterials {
    public static void preInit() {
        if (NCConfig.armor_conarm_register[0]) {
            ConArmMaterials.addArmorMaterial("boron", 0, NCConfig.armor_boron);
        }
        if (NCConfig.armor_conarm_register[1]) {
            ConArmMaterials.addArmorMaterial("tough", 1, NCConfig.armor_tough);
        }
        if (NCConfig.armor_conarm_register[2]) {
            ConArmMaterials.addArmorMaterial("hard_carbon", 2, NCConfig.armor_hard_carbon);
        }
        if (NCConfig.armor_conarm_register[3]) {
            ConArmMaterials.addArmorMaterial("boron_nitride", 3, NCConfig.armor_boron_nitride);
        }
        if (NCConfig.armor_conarm_register[4]) {
            ConArmMaterials.addArmorMaterial("thorium", 19.0, 15.5, 0.8, 0.75);
        }
        if (NCConfig.armor_conarm_register[5]) {
            ConArmMaterials.addArmorMaterial("uranium", 20.0, 14.5, 0.6, 0.8);
        }
        if (NCConfig.armor_conarm_register[6]) {
            ConArmMaterials.addArmorMaterial("magnesium", 17.5, 12.5, 0.2, 1.0);
        }
        if (NCConfig.armor_conarm_register[7]) {
            ConArmMaterials.addArmorMaterial("chocolate", 1.4, 1.2, 0.0, 0.15);
        }
    }

    private static void addArmorMaterial(String materialName, double durability, double fullSetProtection, double toughness, double modifier) {
        Material material = TinkerRegistry.getMaterial((String)materialName);
        if (material == Material.UNKNOWN) {
            return;
        }
        TConstructHelper.addMaterialStats(material, new IMaterialStats[]{new CoreMaterialStats((float)NCMath.round(0.5 * durability, 1), (float)fullSetProtection), new PlatesMaterialStats((float)modifier, (float)NCMath.round(0.25 * modifier * durability, 1), (float)Math.min(5.0, NCMath.round(toughness / modifier, 1))), new TrimMaterialStats((float)NCMath.round(0.4 * modifier * fullSetProtection, 1))});
    }

    private static void addArmorMaterial(String materialName, int armorNumber, int[] protectionArray) {
        ConArmMaterials.addArmorMaterial(materialName, NCConfig.armor_durability[armorNumber], CollectionHelper.sum(protectionArray), NCConfig.armor_toughness[armorNumber], NCConfig.tool_handle_modifier[armorNumber]);
    }

    public static void init() {
        ConArmMaterials.addArmorTraits("boron", new ITrait[]{ArmorTraits.dense, ArmorTraits.indomitable}, new ITrait[]{ArmorTraits.indomitable});
        ConArmMaterials.addArmorTraits("tough", new ITrait[]{ArmorTraits.ambitious, ArmorTraits.steady}, new ITrait[]{ArmorTraits.steady});
        ConArmMaterials.addArmorTraits("hard_carbon", new ITrait[]{ArmorTraits.lightweight, ArmorTraits.prideful}, new ITrait[]{ArmorTraits.lightweight});
        ConArmMaterials.addArmorTraits("boron_nitride", new ITrait[]{ArmorTraits.ambitious, ArmorTraits.spiny}, new ITrait[]{ArmorTraits.spiny});
        ConArmMaterials.addArmorTraits("thorium", new ITrait[]{NCArmorTraits.WITHERING}, new ITrait[]{ArmorTraits.heavy, NCArmorTraits.WITHERING});
        ConArmMaterials.addArmorTraits("uranium", new ITrait[]{NCArmorTraits.POISONOUS}, new ITrait[]{ArmorTraits.heavy, NCArmorTraits.POISONOUS});
        ConArmMaterials.addArmorTraits("magnesium", new ITrait[]{ArmorTraits.blessed, ArmorTraits.featherweight}, new ITrait[]{ArmorTraits.featherweight});
        ConArmMaterials.addArmorTraits("chocolate", new ITrait[]{NCArmorTraits.MOLDABLE_II, ArmorTraits.tasty}, new ITrait[]{NCArmorTraits.MOLDABLE_I, NCArmorTraits.UPLIFTING});
    }

    private static void addArmorTraits(String materialName, ITrait[] coreTraits, ITrait[] extraTraits) {
        Material material = TinkerRegistry.getMaterial((String)materialName);
        if (material == Material.UNKNOWN) {
            return;
        }
        for (ITrait coreTrait : coreTraits) {
            material.addTrait(coreTrait, ArmorMaterialType.CORE);
        }
        for (ITrait extraTrait : extraTraits) {
            material.addTrait(extraTrait, ArmorMaterialType.PLATES);
            material.addTrait(extraTrait, ArmorMaterialType.TRIM);
        }
    }
}

