/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.tconstruct;

import java.util.ArrayList;
import nc.init.NCItems;
import nc.util.OreDictHelper;
import nc.util.StringHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class TConstructExtras {
    public static void init() {
        TConstructExtras.registerGemSmelteryRecipes("diamond");
        TConstructExtras.registerMelting("coal", "coal", 100);
        TConstructExtras.registerMelting("dustCoal", "coal", 100);
        TConstructExtras.registerMelting("blockCoal", "coal", 900);
        TConstructExtras.registerMelting("ingotGraphite", "coal", 100);
        TConstructExtras.registerMelting("dustGraphite", "coal", 100);
        TConstructExtras.registerMelting("blockGraphite", "coal", 900);
        TConstructExtras.registerTableCasting(OreDictHelper.getPrioritisedCraftingStack(ItemStack.field_190927_a, "coal"), TinkerSmeltery.castGem, "coal", 100);
        TConstructExtras.registerBasinCasting(OreDictHelper.getPrioritisedCraftingStack(ItemStack.field_190927_a, "blockCoal"), null, "coal", 900);
        TConstructExtras.registerTableCasting(OreDictHelper.getPrioritisedCraftingStack(ItemStack.field_190927_a, "ingotGraphite"), TinkerSmeltery.castIngot, "coal", 100);
        TinkerRegistry.registerMelting((ItemStack)new ItemStack(NCItems.ground_cocoa_nibs), (Fluid)FluidRegistry.getFluid((String)"chocolate_liquor"), (int)144);
        TinkerRegistry.registerMelting((ItemStack)new ItemStack(Items.field_151102_aT), (Fluid)FluidRegistry.getFluid((String)"sugar"), (int)144);
        TinkerRegistry.registerMelting((ItemStack)new ItemStack(NCItems.gelatin), (Fluid)FluidRegistry.getFluid((String)"gelatin"), (int)144);
        TConstructExtras.registerAlloyRecipe("steel", 9, "iron", 9, "coal", 25);
        TConstructExtras.registerAlloyRecipe("ferroboron", 2, "steel", 1, "boron", 1);
        TConstructExtras.registerAlloyRecipe("tough", 2, "ferroboron", 1, "lithium", 1);
        TConstructExtras.registerAlloyRecipe("hard_carbon", 144, "coal", 100, "diamond", 333);
        TConstructExtras.registerAlloyRecipe("magnesium_diboride", 3, "magnesium", 1, "boron", 2);
        TConstructExtras.registerAlloyRecipe("lithium_manganese_dioxide", 2, "lithium", 1, "manganese_dioxide", 1);
        TConstructExtras.registerAlloyRecipe("extreme", 1, "tough", 1, "hard_carbon", 1);
        TConstructExtras.registerAlloyRecipe("thermoconducting", 16, "extreme", 8, "boron_arsenide", 37);
        TConstructExtras.registerAlloyRecipe("lead_platinum", 4, "lead", 3, "platinum", 1);
        TConstructExtras.registerAlloyRecipe("enderium", 72, "lead_platinum", 72, "ender", 125);
        TConstructExtras.registerAlloyRecipe("unsweetened_chocolate", 2, "chocolate_liquor", 1, "cocoa_butter", 1);
        TConstructExtras.registerAlloyRecipe("dark_chocolate", 2, "unsweetened_chocolate", 2, "sugar", 1);
        TConstructExtras.registerAlloyRecipe("milk_chocolate", 144, "dark_chocolate", 72, "milk", 125);
        TConstructExtras.registerAlloyRecipe("hydrated_gelatin", 36, "gelatin", 36, "water", 125);
        TConstructExtras.registerAlloyRecipe("marshmallow", 2, "hydrated_gelatin", 2, "sugar", 1);
    }

    public static void registerGemSmelteryRecipes(String name) {
        TConstructExtras.registerGemSmelteryRecipes(StringHelper.capitalize(name), name);
    }

    public static void registerGemSmelteryRecipes(String oreSuffix, String fluidName) {
        TConstructExtras.registerGemMelting(oreSuffix, fluidName);
        TConstructExtras.registerGemCasting(oreSuffix, fluidName);
    }

    public static void registerGemMelting(String oreSuffix, String fluidName) {
        TConstructExtras.registerMelting("gem" + oreSuffix, fluidName, 666);
        TConstructExtras.registerMelting("dust" + oreSuffix, fluidName, 666);
        TConstructExtras.registerMelting("nugget" + oreSuffix, fluidName, 74);
        TConstructExtras.registerMelting("block" + oreSuffix, fluidName, 5994);
    }

    public static void registerMelting(String inputName, String fluidName, int fluidAmount) {
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid != null) {
            TinkerRegistry.registerMelting((String)inputName, (Fluid)fluid, (int)fluidAmount);
        }
    }

    public static void registerGemCasting(String oreSuffix, String fluidName) {
        TConstructExtras.registerTableCasting(OreDictHelper.getPrioritisedCraftingStack(ItemStack.field_190927_a, "gem" + oreSuffix), TinkerSmeltery.castGem, fluidName, 666);
        TConstructExtras.registerTableCasting(OreDictHelper.getPrioritisedCraftingStack(ItemStack.field_190927_a, "nugget" + oreSuffix), TinkerSmeltery.castNugget, fluidName, 74);
        TConstructExtras.registerBasinCasting(OreDictHelper.getPrioritisedCraftingStack(ItemStack.field_190927_a, "block" + oreSuffix), null, fluidName, 5994);
    }

    public static void registerTableCasting(ItemStack output, ItemStack cast, String fluidName, int fluidAmount) {
        Fluid fluid;
        if (output != null && !output.func_190926_b() && (fluid = FluidRegistry.getFluid((String)fluidName)) != null) {
            TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(output, cast == null ? null : RecipeMatch.of((ItemStack)cast), fluid, fluidAmount));
        }
    }

    public static void registerBasinCasting(ItemStack output, ItemStack cast, String fluidName, int fluidAmount) {
        Fluid fluid;
        if (output != null && !output.func_190926_b() && (fluid = FluidRegistry.getFluid((String)fluidName)) != null) {
            TinkerRegistry.registerBasinCasting((ICastingRecipe)new CastingRecipe(output, cast == null ? null : RecipeMatch.of((ItemStack)cast), fluid, fluidAmount));
        }
    }

    public static void registerAlloyRecipe(Object ... objects) {
        Fluid fluid;
        if (objects.length >= 6 && (objects.length & 1) == 0 && (fluid = FluidRegistry.getFluid((String)((String)objects[0]))) != null) {
            FluidStack result = new FluidStack(fluid, ((Integer)objects[1]).intValue());
            ArrayList<FluidStack> inputs = new ArrayList<FluidStack>();
            for (int i = 1; i < objects.length / 2; ++i) {
                fluid = FluidRegistry.getFluid((String)((String)objects[2 * i]));
                if (fluid == null) {
                    return;
                }
                inputs.add(new FluidStack(fluid, ((Integer)objects[2 * i + 1]).intValue()));
            }
            TinkerRegistry.registerAlloy((FluidStack)result, (FluidStack[])inputs.toArray(new FluidStack[inputs.size()]));
        }
    }
}

