/*
 * Decompiled with CFR 0.152.
 */
package nc.capability.radiation.entity;

import nc.capability.ICapability;
import nc.capability.radiation.IRadiation;
import nc.config.NCConfig;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public interface IEntityRads
extends IRadiation,
ICapability<IEntityRads> {
    @CapabilityInject(value=IEntityRads.class)
    public static final Capability<IEntityRads> CAPABILITY_ENTITY_RADS = null;
    public static final ResourceLocation CAPABILITY_ENTITY_RADS_NAME = new ResourceLocation("nuclearcraft", "capability_entity_rads");

    public double getTotalRads();

    public void setTotalRads(double var1, boolean var3);

    default public boolean isTotalRadsNegligible() {
        return this.getTotalRads() < NCConfig.radiation_lowest_rate;
    }

    public double getMaxRads();

    default public double getRadsPercentage() {
        return Math.min(100.0, 100.0 * this.getTotalRads() / this.getMaxRads());
    }

    default public double getRawRadiationLevel() {
        return this.getFullRadiationResistance() > 0.0 ? 0.5 * (this.getRadiationLevel() + Math.sqrt(this.getRadiationLevel() * (this.getRadiationLevel() + 4.0 * this.getFullRadiationResistance()))) : (this.getFullRadiationResistance() < 0.0 ? this.getRadiationLevel() / (1.0 - this.getFullRadiationResistance()) : this.getRadiationLevel());
    }

    @Override
    default public boolean isRadiationUndetectable() {
        return this.getRawRadiationLevel() < NCConfig.radiation_lowest_rate * NCConfig.max_player_rads;
    }

    public double getInternalRadiationResistance();

    public void setInternalRadiationResistance(double var1);

    public double getExternalRadiationResistance();

    public void setExternalRadiationResistance(double var1);

    default public double getFullRadiationResistance() {
        return this.getInternalRadiationResistance() + this.getExternalRadiationResistance();
    }

    public boolean getRadXUsed();

    public void setRadXUsed(boolean var1);

    public boolean getRadXWoreOff();

    public void setRadXWoreOff(boolean var1);

    public double getRadawayBuffer(boolean var1);

    public void setRadawayBuffer(boolean var1, double var2);

    public double getPoisonBuffer();

    public void setPoisonBuffer(double var1);

    default public boolean isFatal() {
        return this.getTotalRads() >= this.getMaxRads();
    }

    public boolean getConsumedMedicine();

    public void setConsumedMedicine(boolean var1);

    public double getRadawayCooldown();

    public void setRadawayCooldown(double var1);

    public boolean canConsumeRadaway();

    public double getRecentRadawayAddition();

    public void setRecentRadawayAddition(double var1);

    public void resetRecentRadawayAddition();

    public double getRadXCooldown();

    public void setRadXCooldown(double var1);

    public boolean canConsumeRadX();

    public double getRecentRadXAddition();

    public void setRecentRadXAddition(double var1);

    public void resetRecentRadXAddition();

    public double getRecentPoisonAddition();

    public void setRecentPoisonAddition(double var1);

    public void resetRecentPoisonAddition();

    public double getRadiationImmunityTime();

    public void setRadiationImmunityTime(double var1);

    public boolean getRadiationImmunityStage();

    public void setRadiationImmunityStage(boolean var1);

    default public boolean isImmune() {
        return this.getRadiationImmunityStage() || this.getRadiationImmunityTime() > 0.0;
    }

    public boolean getShouldWarn();

    public void setShouldWarn(boolean var1);
}

