/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile.processor;

import java.util.Random;
import nc.block.property.BlockProperties;
import nc.block.tile.BlockSidedTile;
import nc.block.tile.IActivatable;
import nc.block.tile.ITileType;
import nc.enumm.BlockEnums;
import nc.util.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockProcessor
extends BlockSidedTile
implements IActivatable,
ITileType {
    public final boolean isActive;
    public final boolean isActivatable;
    protected final BlockEnums.ProcessorType type;

    public BlockProcessor(BlockEnums.ProcessorType type) {
        super(Material.field_151573_f);
        this.isActivatable = false;
        this.isActive = false;
        if (!this.isActive && type.getCreativeTab() != null) {
            this.func_149647_a(type.getCreativeTab());
        }
        this.type = type;
    }

    public BlockProcessor(BlockEnums.ProcessorType type, boolean isActive) {
        super(Material.field_151573_f);
        this.isActive = isActive;
        this.isActivatable = true;
        if (!isActive && type.getCreativeTab() != null) {
            this.func_149647_a(type.getCreativeTab());
        }
        this.type = type;
    }

    protected String getActiveSuffix(boolean isActive) {
        return isActive ? "_active" : "_idle";
    }

    @Override
    public String getTileName() {
        return this.isActivatable ? this.type.func_176610_l() + this.getActiveSuffix(this.isActive) : this.type.func_176610_l();
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.type.getTile();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.type.getIdleBlock());
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(this.type.getIdleBlock());
    }

    @Override
    public Block getBlockType(boolean active) {
        return active ? this.type.getActiveBlock() : this.type.getIdleBlock();
    }

    @Override
    public void setState(boolean isActive, TileEntity tile) {
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        IBlockState state = world.func_180495_p(pos);
        keepInventory = true;
        if (isActive) {
            world.func_180501_a(pos, this.type.getActiveBlock().func_176223_P().func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)((EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL))), 3);
        } else {
            world.func_180501_a(pos, this.type.getIdleBlock().func_176223_P().func_177226_a((IProperty)BlockProperties.FACING_HORIZONTAL, (Comparable)((EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL))), 3);
        }
        keepInventory = false;
        tile.func_145829_t();
        world.func_175690_a(pos, tile);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (!this.isActive) {
            return;
        }
        BlockHelper.spawnParticleOnProcessor(state, world, pos, rand, (EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL), this.type.getParticle1());
        BlockHelper.spawnParticleOnProcessor(state, world, pos, rand, (EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL), this.type.getParticle2());
        BlockProcessor blockProcessor = this;
        BlockHelper.playSoundOnProcessor(world, pos, rand, blockProcessor.type.getSound());
    }
}

