/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.logic;

import ejektaflex.bountiful.Bountiful;
import ejektaflex.bountiful.api.ext.ExtMiscKt;
import ejektaflex.bountiful.api.logic.picked.IPickedEntry;
import ejektaflex.bountiful.api.logic.picked.PickedEntryEntity;
import ejektaflex.bountiful.api.logic.picked.PickedEntryStack;
import ejektaflex.bountiful.data.BountyData;
import ejektaflex.bountiful.registry.ValueRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ,\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\nJ2\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u0010J&\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\u001f"}, d2={"Lejektaflex/bountiful/logic/BountyChecker;", "", "()V", "checkNestedCompound", "", "bountyCompound", "Lnet/minecraft/nbt/NBTTagCompound;", "stackCompound", "compareStackTags", "stack", "Lnet/minecraft/item/ItemStack;", "bountystack", "hasEntitiesFulfilled", "data", "Lejektaflex/bountiful/data/BountyData;", "hasItems", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "inv", "Lnet/minecraft/util/NonNullList;", "rewardItems", "", "bountyItem", "takeItems", "matched", "tryTakeEntities", "bounty", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "validStackCheck", "Bountiful"})
public final class BountyChecker {
    public static final BountyChecker INSTANCE;

    private final boolean validStackCheck(ItemStack stack, ItemStack bountystack) {
        if (Bountiful.INSTANCE.getConfig().getRequireExactNbt()) {
            return stack.func_185136_b(bountystack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)bountystack);
        }
        return stack.func_185136_b(bountystack) && this.compareStackTags(stack, bountystack);
    }

    private final boolean compareStackTags(ItemStack stack, ItemStack bountystack) {
        NBTTagCompound bountyCompound = bountystack.func_77978_p();
        if (bountyCompound == null || bountyCompound.func_82582_d()) {
            return true;
        }
        return this.checkNestedCompound(bountyCompound, stack.func_77978_p());
    }

    private final boolean checkNestedCompound(NBTTagCompound bountyCompound, NBTTagCompound stackCompound) {
        if (stackCompound == null) {
            return false;
        }
        for (String key : bountyCompound.func_150296_c()) {
            NBTBase a = bountyCompound.func_74781_a(key);
            NBTBase b = stackCompound.func_74781_a(key);
            if (a != null) {
                if (a instanceof NBTTagCompound && b instanceof NBTTagCompound) {
                    if (this.checkNestedCompound((NBTTagCompound)a, (NBTTagCompound)b)) continue;
                    return false;
                }
                if (a.equals((Object)b)) continue;
                return false;
            }
            if (b == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<ItemStack> hasItems(@NotNull EntityPlayer player, @NotNull NonNullList<ItemStack> inv, @NotNull BountyData data) {
        boolean bl;
        List prereqItems;
        block14: {
            Iterable $receiver$iv;
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            Intrinsics.checkParameterIsNotNull(inv, (String)"inv");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Iterable iterable = $receiver$iv2 = (Iterable)((ValueRegistry)data.getToGet()).getItems();
            Iterable<PickedEntryStack> destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv2;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Iterator iterator;
                Object element$iv$iv = element$iv$iv$iv;
                IPickedEntry it = (IPickedEntry)element$iv$iv;
                IPickedEntry iPickedEntry = it;
                if (!(iPickedEntry instanceof PickedEntryStack)) {
                    iPickedEntry = null;
                }
                if ((PickedEntryStack)iPickedEntry == null) continue;
                PickedEntryStack it$iv$iv = iterator;
                destination$iv$iv.add(it$iv$iv);
            }
            List stackPicked = (List)destination$iv$iv;
            System.out.println(stackPicked);
            Object $receiver$iv3 = (Iterable)inv;
            destination$iv$iv = $receiver$iv3;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                boolean bl2;
                block13: {
                    ItemStack invItem = (ItemStack)element$iv$iv;
                    $receiver$iv = stackPicked;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            PickedEntryStack picked = (PickedEntryStack)element$iv;
                            ItemStack itemStack = picked.getItemStack();
                            if (!(itemStack != null && itemStack.func_185136_b(invItem))) continue;
                            bl2 = true;
                            break block13;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            prereqItems = (List)destination$iv$iv2;
            $receiver$iv3 = "Prereq items: " + prereqItems;
            System.out.println($receiver$iv3);
            Iterable $receiver$iv4 = stackPicked;
            if ($receiver$iv4 instanceof Collection && ((Collection)$receiver$iv4).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv4) {
                    boolean hasEnough;
                    ItemStack it;
                    void $receiver$iv$iv3;
                    Iterable $receiver$iv5;
                    PickedEntryStack picked = (PickedEntryStack)element$iv;
                    $receiver$iv = $receiver$iv5 = (Iterable)prereqItems;
                    Collection destination$iv$iv3 = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv3) {
                        ItemStack itemStack = it = (ItemStack)element$iv$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"it");
                        ItemStack itemStack2 = picked.getItemStack();
                        if (itemStack2 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!INSTANCE.validStackCheck(itemStack, itemStack2)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    List stacksMatching = (List)destination$iv$iv3;
                    $receiver$iv = stacksMatching;
                    int sum$iv = 0;
                    for (Object element$iv2 : $receiver$iv) {
                        it = (ItemStack)element$iv2;
                        int n = sum$iv;
                        ItemStack itemStack = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"it");
                        int n2 = itemStack.func_190916_E();
                        sum$iv = n + n2;
                    }
                    boolean bl3 = hasEnough = sum$iv >= picked.getAmount();
                    if (!hasEnough) {
                        ExtMiscKt.sendTranslation((ICommandSender)player, "bountiful.cannot.fulfill");
                    }
                    if (hasEnough) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        boolean hasAllItems = bl;
        return hasAllItems ? prereqItems : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void takeItems(@NotNull EntityPlayer player, @NotNull NonNullList<ItemStack> inv, @NotNull BountyData data, @NotNull List<ItemStack> matched) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull(inv, (String)"inv");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull(matched, (String)"matched");
        Iterable $receiver$iv = ((ValueRegistry)data.getToGet()).getItems();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            PickedEntryStack pickedEntryStack;
            Object element$iv$iv = element$iv$iv$iv;
            IPickedEntry it = (IPickedEntry)element$iv$iv;
            IPickedEntry iPickedEntry = it;
            if (!(iPickedEntry instanceof PickedEntryStack)) {
                iPickedEntry = null;
            }
            if ((PickedEntryStack)iPickedEntry == null) continue;
            PickedEntryStack it$iv$iv = pickedEntryStack;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        block1: for (Object element$iv : $receiver$iv) {
            void $receiver$iv$iv2;
            Object element$iv$iv$iv;
            PickedEntryStack picked = (PickedEntryStack)element$iv;
            Iterable $receiver$iv2 = matched;
            element$iv$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                ItemStack it = (ItemStack)element$iv$iv;
                ItemStack itemStack = picked.getItemStack();
                if (itemStack == null) {
                    Intrinsics.throwNpe();
                }
                if (!INSTANCE.validStackCheck(it, itemStack)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List stacksToChange = (List)destination$iv$iv2;
            for (ItemStack stack : stacksToChange) {
                if (picked.getAmount() == 0) continue block1;
                int n = stack.func_190916_E();
                int n2 = picked.getAmount();
                int amountToRemove = Math.min(n, n2);
                ItemStack itemStack = stack;
                itemStack.func_190920_e(itemStack.func_190916_E() - amountToRemove);
                PickedEntryStack pickedEntryStack = picked;
                pickedEntryStack.setAmount(pickedEntryStack.getAmount() - amountToRemove);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void tryTakeEntities(@NotNull EntityPlayer player, @NotNull BountyData data, @NotNull ItemStack bounty, @NotNull EntityLivingBase entity) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)bounty, (String)"bounty");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        World world = player.field_70170_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"player.world");
        if (data.hasExpired(world)) {
            return;
        }
        Iterable $receiver$iv = ((ValueRegistry)data.getToGet()).getItems();
        Object object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            PickedEntryEntity pickedEntryEntity;
            Object element$iv$iv = element$iv$iv$iv;
            IPickedEntry it = (IPickedEntry)element$iv$iv;
            IPickedEntry iPickedEntry = it;
            if (!(iPickedEntry instanceof PickedEntryEntity)) {
                iPickedEntry = null;
            }
            if ((PickedEntryEntity)iPickedEntry == null) continue;
            PickedEntryEntity it$iv$iv = pickedEntryEntity;
            destination$iv$iv.add(it$iv$iv);
        }
        List bountyEntities = (List)destination$iv$iv;
        $receiver$iv = bountyEntities;
        object = $receiver$iv.iterator();
        while (object.hasNext()) {
            ResourceLocation resourceLocation = ExtMiscKt.getRegistryName((Entity)entity);
            Object element$iv = object.next();
            PickedEntryEntity picked = (PickedEntryEntity)element$iv;
            EntityEntry entityEntry = picked.getEntityEntry();
            if (!Intrinsics.areEqual((Object)(entityEntry != null && (entityEntry = entityEntry.getRegistryName()) != null ? entityEntry.toString() : null), (Object)(resourceLocation != null ? resourceLocation.toString() : null)) || picked.getKilledAmount() >= picked.getAmount()) continue;
            PickedEntryEntity pickedEntryEntity = picked;
            int n = pickedEntryEntity.getKilledAmount();
            pickedEntryEntity.setKilledAmount(n + 1);
        }
        bounty.func_77982_d(data.serializeNBT());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasEntitiesFulfilled(@NotNull BountyData data) {
        boolean bl;
        block7: {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Iterable $receiver$iv = ((ValueRegistry)data.getToGet()).getItems();
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                PickedEntryEntity pickedEntryEntity;
                Object element$iv$iv = element$iv$iv$iv;
                IPickedEntry it = (IPickedEntry)element$iv$iv;
                IPickedEntry iPickedEntry = it;
                if (!(iPickedEntry instanceof PickedEntryEntity)) {
                    iPickedEntry = null;
                }
                if ((PickedEntryEntity)iPickedEntry == null) continue;
                PickedEntryEntity it$iv$iv = pickedEntryEntity;
                destination$iv$iv.add(it$iv$iv);
            }
            List bountyEntities = (List)destination$iv$iv;
            if (bountyEntities.isEmpty()) {
                bl = true;
            } else {
                $receiver$iv = bountyEntities;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        PickedEntryEntity it = (PickedEntryEntity)element$iv;
                        if (it.getKilledAmount() == it.getAmount()) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    public final void rewardItems(@NotNull EntityPlayer player, @NotNull BountyData data, @NotNull ItemStack bountyItem) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)bountyItem, (String)"bountyItem");
        Iterable $receiver$iv = ((ValueRegistry)data.getRewards()).getItems();
        for (Object element$iv : $receiver$iv) {
            int stackSize;
            PickedEntryStack reward = (PickedEntryStack)element$iv;
            List stacksToGive = new ArrayList();
            for (int amountNeededToGive = reward.getAmount(); amountNeededToGive > 0; amountNeededToGive -= stackSize) {
                ItemStack newStack;
                ItemStack itemStack;
                int n = bountyItem.func_77976_d();
                stackSize = Math.min(amountNeededToGive, n);
                ItemStack itemStack2 = reward.getItemStack();
                if (itemStack2 == null) {
                    Intrinsics.throwNpe();
                }
                ItemStack $receiver = itemStack = itemStack2.func_77946_l();
                $receiver.func_190920_e(stackSize);
                ItemStack itemStack3 = newStack = itemStack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"newStack");
                stacksToGive.add(itemStack3);
            }
            Iterable $receiver$iv2 = stacksToGive;
            for (Object element$iv2 : $receiver$iv2) {
                ItemStack stack = (ItemStack)element$iv2;
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
            }
        }
    }

    private BountyChecker() {
    }

    static {
        BountyChecker bountyChecker;
        INSTANCE = bountyChecker = new BountyChecker();
    }
}

