/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.wrapper;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import tschipp.callablehorses.common.HorseManager;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.config.CallableHorsesConfig;
import tschipp.callablehorses.common.helper.HorseHelper;

public abstract class CallableHorsesWrapper {
    public static void applyCallableHorseDeath(Entity entity) {
        IStoredHorse horse;
        if (entity instanceof AbstractHorse && !entity.field_70170_p.field_72995_K && (horse = HorseHelper.getHorseCap((Entity)entity)).isOwned()) {
            EntityPlayer owner = HorseHelper.getPlayerFromUUID((String)horse.getOwnerUUID(), (World)entity.field_70170_p);
            if (owner != null) {
                IHorseOwner horseOwner = HorseHelper.getOwnerCap((EntityPlayer)owner);
                if (CallableHorsesConfig.settings.deathIsPermanent) {
                    horseOwner.clearHorse();
                    owner.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_74838_a((String)"callablehorses.alert.death")));
                } else {
                    AbstractHorse deadHorse = horseOwner.getHorseEntity(owner.field_70170_p);
                    HorseManager.prepDeadHorseForRespawning((Entity)deadHorse);
                    horseOwner.setHorseNBT(deadHorse.serializeNBT());
                    horseOwner.setLastSeenPosition(BlockPos.field_177992_a);
                }
            } else {
                HorseHelper.getWorldData((World)entity.field_70170_p).markKilled(horse.getStorageUUID());
            }
        }
    }
}

