/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.mixin.rustic;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import rlmixins.handlers.ConfigHandler;
import rustic.common.blocks.fluids.FluidBooze;
import rustic.common.blocks.fluids.ModFluids;

@Mixin(value={ModFluids.class})
public abstract class ModFluids_ConfigMixin {
    @Shadow(remap=false)
    public static Fluid ALE;
    @Shadow(remap=false)
    public static Fluid CIDER;
    @Shadow(remap=false)
    public static Fluid IRON_WINE;
    @Shadow(remap=false)
    public static Fluid MEAD;
    @Shadow(remap=false)
    public static Fluid WILDBERRY_WINE;
    @Shadow(remap=false)
    public static Fluid WINE;

    @Redirect(method={"init"}, at=@At(value="FIELD", target="Lrustic/common/blocks/fluids/ModFluids;ALE:Lnet/minecraftforge/fluids/Fluid;", opcode=179), remap=false)
    private static void rlmixins_rusticModFluids_initAle(Fluid value) {
        ALE = new FluidBooze("ale", new ResourceLocation("rustic:blocks/fluids/booze/ale_still"), new ResourceLocation("rustic:blocks/fluids/booze/ale_flow")){

            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality > 0.5f) {
                    float saturation = 4.0f * quality;
                    player.func_71024_bL().func_75122_a(2, saturation);
                    int duration = (int)(ConfigHandler.RUSTIC_CONFIG.aleMaxDurationPositive * (quality - 0.5f) * 2.0f);
                    player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)ConfigHandler.RUSTIC_CONFIG.aleEffect), duration));
                } else {
                    int duration = (int)(ConfigHandler.RUSTIC_CONFIG.aleMaxDurationHunger * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, duration));
                    duration = (int)(ConfigHandler.RUSTIC_CONFIG.aleMaxDurationNausea * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(ConfigHandler.RUSTIC_CONFIG.aleInebriationChance).setDensity(1004).setViscosity(1016);
    }

    @Redirect(method={"init"}, at=@At(value="FIELD", target="Lrustic/common/blocks/fluids/ModFluids;CIDER:Lnet/minecraftforge/fluids/Fluid;", opcode=179), remap=false)
    private static void rlmixins_rusticModFluids_initCider(Fluid value) {
        CIDER = new FluidBooze("cider", new ResourceLocation("rustic:blocks/fluids/booze/cider_still"), new ResourceLocation("rustic:blocks/fluids/booze/cider_flow")){

            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality > 0.5f) {
                    float saturation = 2.0f * quality;
                    player.func_71024_bL().func_75122_a(1, saturation);
                    int duration = (int)(ConfigHandler.RUSTIC_CONFIG.ciderMaxDurationPositive * (quality - 0.5f) * 2.0f);
                    player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)ConfigHandler.RUSTIC_CONFIG.ciderEffect), duration));
                } else {
                    int duration = (int)(ConfigHandler.RUSTIC_CONFIG.ciderMaxDurationPoison * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration));
                    duration = (int)(ConfigHandler.RUSTIC_CONFIG.ciderMaxDurationNausea * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(ConfigHandler.RUSTIC_CONFIG.ciderInebriationChance).setDensity(1004).setViscosity(1400);
    }

    @Redirect(method={"init"}, at=@At(value="FIELD", target="Lrustic/common/blocks/fluids/ModFluids;IRON_WINE:Lnet/minecraftforge/fluids/Fluid;", opcode=179), remap=false)
    private static void rlmixins_rusticModFluids_initIronWine(Fluid value) {
        IRON_WINE = new FluidBooze("ironwine", new ResourceLocation("rustic:blocks/fluids/booze/iron_wine_still"), new ResourceLocation("rustic:blocks/fluids/booze/iron_wine_flow")){

            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality > 0.5f) {
                    float saturation = 2.0f * quality;
                    player.func_71024_bL().func_75122_a(1, saturation);
                    float absorption = ConfigHandler.RUSTIC_CONFIG.ironWineMaxAbsorption * (quality - 0.5f) * 2.0f;
                    player.func_110149_m(Math.max(Math.min(player.func_110139_bj() + absorption, 20.0f), player.func_110139_bj()));
                } else {
                    int duration = (int)(ConfigHandler.RUSTIC_CONFIG.ironWineMaxDurationNausea * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                    float damage = ConfigHandler.RUSTIC_CONFIG.ironWineMaxDamage * 2.0f * Math.max(0.5f - quality, 0.0f) + 1.0f;
                    player.func_70097_a(DamageSource.field_76376_m, damage);
                }
            }
        }.setInebriationChance(ConfigHandler.RUSTIC_CONFIG.ironWineInebriationChance).setDensity(1034).setViscosity(1400);
    }

    @Redirect(method={"init"}, at=@At(value="FIELD", target="Lrustic/common/blocks/fluids/ModFluids;MEAD:Lnet/minecraftforge/fluids/Fluid;", opcode=179), remap=false)
    private static void rlmixins_rusticModFluids_initMead(Fluid value) {
        MEAD = new FluidBooze("mead", new ResourceLocation("rustic:blocks/fluids/booze/mead_still"), new ResourceLocation("rustic:blocks/fluids/booze/mead_flow")){

            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality > 0.5f) {
                    float saturation = 2.0f * quality;
                    player.func_71024_bL().func_75122_a(1, saturation);
                    int duration = (int)(ConfigHandler.RUSTIC_CONFIG.meadMaxDurationPositive * (quality - 0.5f) * 2.0f);
                    player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)ConfigHandler.RUSTIC_CONFIG.meadEffect), duration));
                } else {
                    int duration = (int)(ConfigHandler.RUSTIC_CONFIG.meadMaxDurationWither * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_82731_v, duration));
                    duration = (int)(ConfigHandler.RUSTIC_CONFIG.meadMaxDurationNausea * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(ConfigHandler.RUSTIC_CONFIG.meadInebriationChance).setDensity(1034).setViscosity(1500);
    }

    @Redirect(method={"init"}, at=@At(value="FIELD", target="Lrustic/common/blocks/fluids/ModFluids;WILDBERRY_WINE:Lnet/minecraftforge/fluids/Fluid;", opcode=179), remap=false)
    private static void rlmixins_rusticModFluids_initWildberryWine(Fluid value) {
        WILDBERRY_WINE = new FluidBooze("wildberrywine", new ResourceLocation("rustic:blocks/fluids/booze/wildberry_wine_still"), new ResourceLocation("rustic:blocks/fluids/booze/wildberry_wine_flow")){

            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality > 0.5f) {
                    PotionEffect[] effects;
                    float saturation = 2.0f * quality;
                    player.func_71024_bL().func_75122_a(1, saturation);
                    for (PotionEffect potionEffect : effects = player.func_70651_bq().toArray(new PotionEffect[0])) {
                        if (potionEffect.func_188419_a().func_76398_f() || potionEffect.func_76458_c() >= ConfigHandler.RUSTIC_CONFIG.wildberryWineMaxAmplifier || !(world.field_73012_v.nextFloat() <= (quality - 0.5f) * 2.0f)) continue;
                        player.func_70690_d(new PotionEffect(potionEffect.func_188419_a(), potionEffect.func_76459_b(), Math.min(potionEffect.func_76458_c() + ConfigHandler.RUSTIC_CONFIG.wildberryWineMaxAmplifierIncrease, ConfigHandler.RUSTIC_CONFIG.wildberryWineMaxAmplifier), potionEffect.func_82720_e(), potionEffect.func_188418_e()));
                    }
                } else {
                    PotionEffect[] effects;
                    for (PotionEffect effect : effects = player.func_70651_bq().toArray(new PotionEffect[0])) {
                        if (effect.func_188419_a().func_76398_f()) continue;
                        int amp = effect.func_76458_c() - ConfigHandler.RUSTIC_CONFIG.wildberryWineAmplifierDecrease;
                        player.func_184589_d(effect.func_188419_a());
                        if (amp < 0) continue;
                        player.func_70690_d(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), amp, effect.func_82720_e(), effect.func_188418_e()));
                    }
                    int duration = (int)(ConfigHandler.RUSTIC_CONFIG.wildberryWineMaxDurationNausea * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(ConfigHandler.RUSTIC_CONFIG.wildberryWineInebriationChance).setDensity(1034).setViscosity(1500);
    }

    @Redirect(method={"init"}, at=@At(value="FIELD", target="Lrustic/common/blocks/fluids/ModFluids;WINE:Lnet/minecraftforge/fluids/Fluid;", opcode=179), remap=false)
    private static void rlmixins_rusticModFluids_initWine(Fluid value) {
        WINE = new FluidBooze("wine", new ResourceLocation("rustic:blocks/fluids/booze/wine_still"), new ResourceLocation("rustic:blocks/fluids/booze/wine_flow")){

            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality > 0.5f) {
                    PotionEffect[] effects;
                    float saturation = 2.0f * quality;
                    player.func_71024_bL().func_75122_a(1, saturation);
                    for (PotionEffect effect : effects = player.func_70651_bq().toArray(new PotionEffect[0])) {
                        int durationIncrease = (int)(ConfigHandler.RUSTIC_CONFIG.wineMaximumDurationIncrease * (quality - 0.5f) * 2.0f);
                        if (effect.func_188419_a().func_76398_f() || effect.func_76459_b() >= (int)ConfigHandler.RUSTIC_CONFIG.wineMaximumDuration) continue;
                        int duration = Math.max(Math.min(effect.func_76459_b() + durationIncrease, (int)ConfigHandler.RUSTIC_CONFIG.wineMaximumDuration), effect.func_76459_b());
                        player.func_70690_d(new PotionEffect(effect.func_188419_a(), duration, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
                    }
                } else {
                    PotionEffect[] effects;
                    for (PotionEffect effect : effects = player.func_70651_bq().toArray(new PotionEffect[0])) {
                        int durationDecrease = (int)(ConfigHandler.RUSTIC_CONFIG.wineMaximumDurationDecrease * Math.max(0.5f - quality, 0.0f));
                        if (effect.func_188419_a().func_76398_f()) continue;
                        int duration = effect.func_76459_b() - durationDecrease;
                        player.func_184589_d(effect.func_188419_a());
                        if (duration <= 0) continue;
                        player.func_70690_d(new PotionEffect(effect.func_188419_a(), duration, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
                    }
                    int duration = (int)(ConfigHandler.RUSTIC_CONFIG.wineMaxDurationNausea * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(ConfigHandler.RUSTIC_CONFIG.wineInebriationChance).setDensity(1034).setViscosity(1500);
    }
}

