/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.mixin.lycanitesmobs;

import com.lycanitesmobs.core.item.equipment.ItemEquipment;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rlmixins.handlers.ConfigHandler;

@Mixin(value={ItemEquipment.class})
public abstract class ItemEquipment_EnchantTooltipMixin {
    @Shadow(remap=false)
    public abstract NonNullList<ItemStack> getEquipmentPartStacks(ItemStack var1);

    @Shadow(remap=false)
    public abstract ItemEquipmentPart getEquipmentPart(ItemStack var1);

    @Inject(method={"addInformation"}, at={@At(value="TAIL")})
    private void rlmixins_lycanitesMobsItemEquipment_addInformation(ItemStack itemStack, World world, List<String> tooltip, ITooltipFlag tooltipFlag, CallbackInfo ci) {
        if (this.rlmixins$arePartLevelsValid(itemStack)) {
            if (itemStack.func_77948_v()) {
                if (ConfigHandler.LYCANITESMOBS_CONFIG.enchantsPreventDisassembling) {
                    tooltip.add(I18n.func_135052_a((String)"item.lycanitesequipment.description.enchlock", (Object[])new Object[0]));
                } else {
                    tooltip.add(I18n.func_135052_a((String)"item.lycanitesequipment.description.enchremove", (Object[])new Object[0]));
                }
            } else {
                tooltip.add(I18n.func_135052_a((String)"item.lycanitesequipment.description.enchantable", (Object[])new Object[0]));
            }
        } else if (ConfigHandler.LYCANITESMOBS_CONFIG.minimumPartLevelTooltip) {
            tooltip.add(I18n.func_135052_a((String)"item.lycanitesequipment.description.enchrequirement", (Object[])new Object[]{ConfigHandler.LYCANITESMOBS_CONFIG.minimumPartLevelForEnchants}));
        }
    }

    @Unique
    private boolean rlmixins$arePartLevelsValid(ItemStack equipment) {
        int lowest = ConfigHandler.LYCANITESMOBS_CONFIG.minimumPartLevelForEnchants;
        if (lowest <= 0) {
            return true;
        }
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipment)) {
            int partLevel;
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null || (partLevel = equipmentPart.getLevel(equipmentPartStack)) >= lowest) continue;
            return false;
        }
        return true;
    }
}

