/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.mixin.lycanitesmobs;

import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.item.equipment.ItemEquipment;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import rlmixins.handlers.ConfigHandler;

@Mixin(value={ItemEquipment.class})
public abstract class ItemEquipment_EnchantMixin
extends ItemBase {
    @Shadow(remap=false)
    public abstract NonNullList<ItemStack> getEquipmentPartStacks(ItemStack var1);

    @Shadow(remap=false)
    public abstract ItemEquipmentPart getEquipmentPart(ItemStack var1);

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        if (!this.rlmixins$arePartLevelsValid(stack)) {
            return false;
        }
        if (ConfigHandler.LYCANITESMOBS_CONFIG.getEquipmentEnchantmentBlacklist().contains(enchantment)) {
            return false;
        }
        if (enchantment != Enchantments.field_191530_r && (enchantment.field_77351_y == EnumEnchantmentType.WEAPON || enchantment == Enchantments.field_185305_q)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Unique
    private boolean rlmixins$arePartLevelsValid(ItemStack equipment) {
        int lowest = ConfigHandler.LYCANITESMOBS_CONFIG.minimumPartLevelForEnchants;
        if (lowest <= 0) {
            return true;
        }
        for (ItemStack equipmentPartStack : this.getEquipmentPartStacks(equipment)) {
            int partLevel;
            ItemEquipmentPart equipmentPart = this.getEquipmentPart(equipmentPartStack);
            if (equipmentPart == null || (partLevel = equipmentPart.getLevel(equipmentPartStack)) >= lowest) continue;
            return false;
        }
        return true;
    }
}

