/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class EnchantSpecific
extends LootFunction {
    List<Tuple<Enchantment, RandomValueRange>> enchantmentList;

    public EnchantSpecific(LootCondition[] conditionsIn, List<Tuple<Enchantment, RandomValueRange>> enchantmentList) {
        super(conditionsIn);
        this.enchantmentList = enchantmentList;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (this.enchantmentList != null && !this.enchantmentList.isEmpty()) {
            boolean book;
            boolean bl = book = stack.func_77973_b() == Items.field_151122_aG;
            if (book) {
                stack = new ItemStack(Items.field_151134_bR);
            }
            for (Tuple<Enchantment, RandomValueRange> pair : this.enchantmentList) {
                int i = ((RandomValueRange)pair.func_76340_b()).func_186511_a(rand);
                if (book) {
                    ItemEnchantedBook.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData((Enchantment)pair.func_76341_a(), i));
                    continue;
                }
                stack.func_77966_a((Enchantment)pair.func_76341_a(), i);
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<EnchantSpecific> {
        public Serializer() {
            super(new ResourceLocation("rlmixins:enchant_specific"), EnchantSpecific.class);
        }

        public void serialize(JsonObject object, EnchantSpecific functionClazz, JsonSerializationContext serializationContext) {
            if (functionClazz.enchantmentList != null && !functionClazz.enchantmentList.isEmpty()) {
                if (functionClazz.enchantmentList.size() == 1) {
                    Tuple<Enchantment, RandomValueRange> pair = functionClazz.enchantmentList.get(0);
                    ResourceLocation loc = (ResourceLocation)Enchantment.field_185264_b.func_177774_c(pair.func_76341_a());
                    if (loc == null) {
                        throw new IllegalArgumentException("Don't know how to serialize enchantment " + pair.func_76341_a());
                    }
                    object.add("enchantment", (JsonElement)new JsonPrimitive(loc.toString()));
                    object.add("levels", serializationContext.serialize(pair.func_76340_b()));
                } else {
                    JsonArray jsonArray = new JsonArray();
                    for (Tuple<Enchantment, RandomValueRange> pair : functionClazz.enchantmentList) {
                        ResourceLocation loc = (ResourceLocation)Enchantment.field_185264_b.func_177774_c(pair.func_76341_a());
                        if (loc == null) {
                            throw new IllegalArgumentException("Don't know how to serialize enchantment " + pair.func_76341_a());
                        }
                        JsonObject object1 = new JsonObject();
                        object1.add("enchantment", (JsonElement)new JsonPrimitive(loc.toString()));
                        object1.add("levels", serializationContext.serialize(pair.func_76340_b()));
                        jsonArray.add((JsonElement)object1);
                    }
                    object.add("enchantments", (JsonElement)jsonArray);
                }
            }
        }

        public EnchantSpecific deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            ArrayList<Tuple<Enchantment, RandomValueRange>> enchantmentList = new ArrayList<Tuple<Enchantment, RandomValueRange>>();
            if (object.has("enchantment")) {
                String s = JsonUtils.func_151200_h((JsonObject)object, (String)"enchantment");
                Enchantment ench = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation(s));
                if (ench == null) {
                    throw new JsonSyntaxException("Unknown enchantment '" + s + "'");
                }
                RandomValueRange lvl = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)object, (String)"levels", (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
                enchantmentList.add((Tuple<Enchantment, RandomValueRange>)new Tuple((Object)ench, (Object)lvl));
            } else if (object.has("enchantments")) {
                for (JsonElement jsonElement : JsonUtils.func_151214_t((JsonObject)object, (String)"enchantments")) {
                    JsonObject object1;
                    if (!(jsonElement instanceof JsonObject) || !(object1 = (JsonObject)jsonElement).has("enchantment")) continue;
                    String s = JsonUtils.func_151200_h((JsonObject)object1, (String)"enchantment");
                    Enchantment ench = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation(s));
                    if (ench == null) {
                        throw new JsonSyntaxException("Unknown enchantment '" + s + "'");
                    }
                    RandomValueRange lvl = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)object1, (String)"levels", (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
                    enchantmentList.add((Tuple<Enchantment, RandomValueRange>)new Tuple((Object)ench, (Object)lvl));
                }
            }
            return new EnchantSpecific(conditionsIn, enchantmentList);
        }
    }
}

