/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.handlers.somanyenchantments;

import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.EnchantmentRegistry;
import com.shultrea.rin.util.compat.CompatUtil;
import com.shultrea.rin.util.compat.RLCombatCompat;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import yeelp.distinctdamagedescriptions.api.DDDDamageType;
import yeelp.distinctdamagedescriptions.api.impl.DDDBuiltInDamageType;
import yeelp.distinctdamagedescriptions.event.classification.DetermineDamageEvent;
import yeelp.distinctdamagedescriptions.registries.DDDRegistries;

public class SubjectGeographyHandler {
    @SubscribeEvent
    public static void onDetermineDamage(DetermineDamageEvent event) {
        if (!EnchantmentRegistry.subjectGeography.isEnabled()) {
            return;
        }
        if (!EnchantmentBase.isDamageSourceAllowed((DamageSource)event.getSource())) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getTrueAttacker();
        int lvl = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.subjectGeography, (ItemStack)attacker.func_184614_ca());
        if (lvl <= 0) {
            return;
        }
        float strengthMulti = CompatUtil.isRLCombatLoaded() ? RLCombatCompat.getAttackEntityFromStrength() : 1.0f;
        float percentage = strengthMulti * (float)lvl / (float)EnchantmentRegistry.subjectGeography.func_77325_b();
        Set types = BiomeDictionary.getTypes((Biome)attacker.field_70170_p.func_180494_b(attacker.func_180425_c()));
        if (types.contains(BiomeDictionary.Type.HOT) || types.contains(BiomeDictionary.Type.NETHER)) {
            SubjectGeographyHandler.setDmgToType(event, DDDBuiltInDamageType.FIRE, percentage);
        } else if (types.contains(BiomeDictionary.Type.COLD) || types.contains(BiomeDictionary.Type.SNOWY)) {
            SubjectGeographyHandler.setDmgToType(event, DDDBuiltInDamageType.COLD, percentage);
        } else if (types.contains(BiomeDictionary.Type.SWAMP)) {
            SubjectGeographyHandler.setDmgToType(event, DDDBuiltInDamageType.POISON, percentage);
        } else if (types.contains(BiomeDictionary.Type.WASTELAND)) {
            SubjectGeographyHandler.setDmgToType(event, DDDBuiltInDamageType.ACID, percentage);
        } else if (types.contains(BiomeDictionary.Type.SPOOKY) || types.contains(BiomeDictionary.Type.DEAD)) {
            SubjectGeographyHandler.setDmgToType(event, DDDBuiltInDamageType.NECROTIC, percentage);
        } else if (types.contains(BiomeDictionary.Type.MAGICAL)) {
            SubjectGeographyHandler.setDmgToType(event, DDDBuiltInDamageType.RADIANT, percentage);
        }
    }

    private static void setDmgToType(DetermineDamageEvent event, DDDDamageType type, float percentage) {
        double totalDmg = DDDRegistries.damageTypes.getAll().stream().mapToDouble(arg_0 -> ((DetermineDamageEvent)event).getDamage(arg_0)).sum();
        double dmgNewType = (double)percentage * totalDmg;
        DDDRegistries.damageTypes.getAll().forEach(dmgType -> event.setDamage(dmgType, event.getDamage(dmgType) * (1.0f - percentage)));
        event.setDamage(type, (float)((double)event.getDamage(type) + dmgNewType));
    }
}

