/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.config;

import fermiumbooter.annotations.MixinConfig;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.config.Config;
import org.apache.logging.log4j.Level;
import rlmixins.RLMixins;

@MixinConfig(name="rlmixins")
public class SRParasitesConfig {
    @Config.Comment(value={"Replaces Living and Sentient armor models with custom models"})
    @Config.Name(value="Replace Parasite Armor Models (SRParasites)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.rlmixins.late.srparasites.armormodel.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="srparasites", desired=true, reason="Requires mod to properly function")
    public boolean replaceParasiteArmorModels = false;
    @Config.Comment(value={"Makes Parasite armor cure/lower the effect of Fear"})
    @Config.Name(value="Parasite Armor Fear Cure")
    @Config.RequiresMcRestart
    public boolean armorFearCure = false;
    @Config.Comment(value={"Maximum amplifier of Fear while wearing Parasite armor (-1 = cures it)\nRequires \"Parasite Armor Fear Cure\" enabled"})
    @Config.Name(value="Parasite Armor Fear Cure Max Amplifier")
    @Config.RangeInt(min=-1, max=10)
    public int armorFearCureMax = 1;
    @Config.Comment(value={"Makes Parasite armor cure/lower the effect of Viral"})
    @Config.Name(value="Parasite Armor Viral Cure")
    @Config.RequiresMcRestart
    public boolean armorViralCure = false;
    @Config.Comment(value={"Maximum amplifier of Viral while wearing Parasite armor (-1 = cures it)\nRequires \"Parasite Armor Viral Cure\" enabled"})
    @Config.Name(value="Parasite Armor Viral Cure Max Amplifier")
    @Config.RangeInt(min=-1, max=10)
    public int armorViralCureMax = 2;
    @Config.Comment(value={"Makes callable horses register as dead when converted to parasites"})
    @Config.Name(value="Horse Death On Conversion (SRParasites/CallableHorses)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.rlmixins.late.srparasites.horse.json", defaultValue=false)
    @MixinConfig.CompatHandlingContainer(value={@MixinConfig.CompatHandling(modid="srparasites", desired=true, reason="Requires mod to properly function"), @MixinConfig.CompatHandling(modid="callablehorses", desired=true, reason="Requires mod to properly function")})
    public boolean horseDeathOnConversion = false;
    @Config.Comment(value={"Rehandles and rebalances the scythe and maul AOE"})
    @Config.Name(value="Rehandle AOE Weapons (SRParasites/RLCombat)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.rlmixins.late.srparasites.aoeweapon.json", defaultValue=false)
    @MixinConfig.CompatHandlingContainer(value={@MixinConfig.CompatHandling(modid="srparasites", desired=true, reason="Requires mod to properly function"), @MixinConfig.CompatHandling(modid="bettercombatmod", desired=true, reason="Requires mod to properly function")})
    public boolean rehandleAOEWeapons = false;
    @Config.Comment(value={"Allows for replacing the cleaver effect with a config defined effect"})
    @Config.Name(value="Modify Cleaver Effect (SRParasites)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.rlmixins.late.srparasites.cleaver.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="srparasites", desired=true, reason="Requires mod to properly function")
    public boolean modifyCleaverEffect = false;
    @Config.Comment(value={"Effect given by the cleaver when hitting an entity\nRequires \"Modify Cleaver Effect (SRParasites)\" enabled"})
    @Config.Name(value="Cleaver Effect")
    public String cleaverEffect = "potioncore:vulnerable";
    @Config.Comment(value={"Amplifier given by living cleaver when hitting an entity\nRequires \"Modify Cleaver Effect (SRParasites)\" enabled"})
    @Config.Name(value="Living Cleaver Amplifier")
    @Config.RangeInt(min=0, max=10)
    public int livingCleaverAmplifier = 0;
    @Config.Comment(value={"Amplifier given by sentient cleaver when hitting an entity\nRequires \"Modify Cleaver Effect (SRParasites)\" enabled"})
    @Config.Name(value="Sentient Cleaver Amplifier")
    @Config.RangeInt(min=0, max=10)
    public int sentientCleaverAmplifier = 1;
    private Potion cleaverEffectPotion = null;

    public Potion getCleaverEffect() {
        if (this.cleaverEffectPotion == null) {
            this.cleaverEffectPotion = Potion.func_180142_b((String)this.cleaverEffect);
            if (this.cleaverEffectPotion == null) {
                RLMixins.LOGGER.log(Level.ERROR, "Invalid Cleaver Effect: " + this.cleaverEffect);
                this.cleaverEffectPotion = MobEffects.field_76436_u;
            }
        }
        return this.cleaverEffectPotion;
    }

    public void refreshConfig() {
        this.cleaverEffectPotion = null;
    }
}

