/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.config;

import fermiumbooter.annotations.MixinConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@MixinConfig(name="rlmixins")
public class RLMixinsConfig {
    @Config.Comment(value={"Adds and registers Steel armor with custom models"})
    @Config.Name(value="Steel Armor")
    @Config.RequiresMcRestart
    public boolean steelArmor = false;
    @Config.Comment(value={"Adds and registers Scarlite armor with custom models"})
    @Config.Name(value="Scarlite Armor")
    @Config.RequiresMcRestart
    public boolean scarliteArmor = false;
    @Config.Comment(value={"Adds and registers the Antimagic Talisman, and a recipe for crafting it with enchanted items"})
    @Config.Name(value="Antimagic Talisman")
    @Config.RequiresMcRestart
    public boolean antimagicTalisman = false;
    @Config.Comment(value={"Adds and registers the Lesser Fire Resistance potion effect"})
    @Config.Name(value="Lesser Fire Resistance Potion Effect")
    @Config.RequiresMcRestart
    public boolean lesserFireResistancePotionEffect = false;
    @Config.Comment(value={"Adds and registers the Cow potion effect"})
    @Config.Name(value="Cow Potion Effect")
    @Config.RequiresMcRestart
    public boolean cowPotionEffect = false;
    @Config.Comment(value={"Adds and registers additional useful loot functions for json loot tables"})
    @Config.Name(value="Additional Loot Functions")
    @Config.RequiresMcRestart
    public boolean additionalLootFunctions = false;
    @Config.Comment(value={"Allows for defining effects to affect player movement inputs to simulate stumbling, such as nausea"})
    @Config.Name(value="Player Nausea Movement Effects")
    @Config.RequiresMcRestart
    public boolean playerNauseaMovementEffects = false;
    @Config.Comment(value={"Allows for defining effects to affect mob movement to simulate stumbling, such as nausea"})
    @Config.Name(value="Mob Nausea Movement Effects")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.rlmixins.early.rlmixins.mobnausea.json", defaultValue=false)
    public boolean mobNauseaMovementEffects = false;
    @Config.Comment(value={"Effects that should affect movement to simulate stumbling"})
    @Config.Name(value="Nausea Movement Effects List")
    public String[] nauseaMovementEffectsList = new String[]{"minecraft:nausea", "minecraft:blindness", "rustic:tipsy"};
    @Config.Comment(value={"Adds bouncy sides to slime blocks similar to Quark's feature but much less laggy"})
    @Config.Name(value="Slime Block Bouncy Sides")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.rlmixins.early.rlmixins.slimebouncysides.json", defaultValue=false)
    public boolean slimeBouncySides = false;
    private List<Potion> nauseaMovementPotionSet = null;

    public List<Potion> getNauseaMovementPotions() {
        if (this.nauseaMovementPotionSet == null) {
            this.nauseaMovementPotionSet = new ArrayList<Potion>();
            for (String name : this.nauseaMovementEffectsList) {
                Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(name));
                if (potion == null) continue;
                this.nauseaMovementPotionSet.add(potion);
            }
        }
        return this.nauseaMovementPotionSet;
    }

    public void refreshConfig() {
        this.nauseaMovementPotionSet = null;
    }
}

