/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.config;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;

public class RLCombatConfig {
    @Config.Comment(value={"Enables the Nether Bane weapon effect to deal bonus damage to nether mobs"})
    @Config.Name(value="Enable Nether Bane")
    @Config.RequiresMcRestart
    public boolean enableNetherBane = false;
    @Config.Comment(value={"List of mobs to be classed as nether mobs for the Nether Bane effect"})
    @Config.Name(value="Nether Bane Mob List")
    public String[] netherBaneMobs = new String[]{"minecraft:wither_skeleton", "minecraft:zombie_pigman", "minecraft:blaze", "minecraft:magma_cube", "minecraft:wither"};
    @Config.Comment(value={"List of weapons to have the Nether Bane effect"})
    @Config.Name(value="Nether Bane Weapon List")
    public String[] netherBaneWeapons = new String[]{""};
    @Config.Comment(value={"If true, Nether Bane effect will multiply damage, if false, additive"})
    @Config.Name(value="Nether Bane Multiply/Add")
    public boolean netherBaneMultiply = false;
    @Config.Comment(value={"Value to either multiply damage by or add to damage for the Nether Bane effect"})
    @Config.Name(value="Nether Bane Damage Value")
    public double netherBaneValue = 4.0;
    private Set<ResourceLocation> netherBaneMobsSet = null;
    private Set<ResourceLocation> netherBaneWeaponsSet = null;

    public Set<ResourceLocation> getNetherBaneMobs() {
        if (this.netherBaneMobsSet == null) {
            this.netherBaneMobsSet = new HashSet<ResourceLocation>();
            for (String name : this.netherBaneMobs) {
                this.netherBaneMobsSet.add(new ResourceLocation(name));
            }
        }
        return this.netherBaneMobsSet;
    }

    public Set<ResourceLocation> getNetherBaneWeapons() {
        if (this.netherBaneWeaponsSet == null) {
            this.netherBaneWeaponsSet = new HashSet<ResourceLocation>();
            for (String name : this.netherBaneWeapons) {
                this.netherBaneWeaponsSet.add(new ResourceLocation(name));
            }
        }
        return this.netherBaneWeaponsSet;
    }

    public void refreshConfig() {
        this.netherBaneMobsSet = null;
        this.netherBaneWeaponsSet = null;
    }
}

