/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.config;

import fermiumbooter.annotations.MixinConfig;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;
import rlmixins.RLMixins;

@MixinConfig(name="rlmixins")
public class LycanitesMobsConfig {
    @Config.Comment(value={"Stops mobs from attempting to target mobs that are stone statues, or tagged with NoAI"})
    @Config.Name(value="Mob Targeting Fix (LycanitesMobs/InFRLCraft)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.rlmixins.late.lycanitesmobs.stonetarget.json", defaultValue=false)
    @MixinConfig.CompatHandlingContainer(value={@MixinConfig.CompatHandling(modid="lycanitesmobs", desired=true, reason="Requires mod to properly function"), @MixinConfig.CompatHandling(modid="iceandfire", desired=true, reason="Requires mod to properly function")})
    public boolean mobTargetingFix = false;
    @Config.Comment(value={"Allows forged equipment to be enchanted\nAllows all WEAPON enchantments except Sweeping Edge\nAllows Efficiency as the only TOOL enchantment\nDurability enchantments, such as Unbreaking and Mending, are not allowed"})
    @Config.Name(value="Enchant Forged Equipment (LycanitesMobs)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.rlmixins.late.lycanitesmobs.equipmentenchantments.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="lycanitesmobs", desired=true, reason="Requires mod to properly function")
    public boolean enchantForgedEquipment = false;
    @Config.Comment(value={"Minimum level all parts of equipment must be in order to enchant"})
    @Config.Name(value="Minimum Part Level For Enchants")
    public int minimumPartLevelForEnchants = 0;
    @Config.Comment(value={"If equipment should give a warning tooltip if it has parts that are not high enough level to be enchanted"})
    @Config.Name(value="Minimum Part Level Tooltip")
    public boolean minimumPartLevelTooltip = true;
    @Config.Comment(value={"If equipment should be prevented from being disassembled if it is enchanted"})
    @Config.Name(value="Enchants Prevent Disassembling")
    public boolean enchantsPreventDisassembling = true;
    @Config.Comment(value={"List of enchants to additionally blacklist from being applicable to equipment\nFormat: modid:path"})
    @Config.Name(value="Equipment Enchantment Blacklist")
    public String[] equipmentEnchantmentBlacklist = new String[0];
    private Set<Enchantment> equipmentEnchantmentBlacklistSet = null;

    public Set<Enchantment> getEquipmentEnchantmentBlacklist() {
        if (this.equipmentEnchantmentBlacklistSet == null) {
            this.equipmentEnchantmentBlacklistSet = new HashSet<Enchantment>();
            for (String name : this.equipmentEnchantmentBlacklist) {
                if ((name = name.trim()).isEmpty()) continue;
                Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(name));
                if (enchant == null) {
                    RLMixins.LOGGER.log(Level.WARN, "Invalid enchantment " + name + " in blacklist for Lycanite equipment enchanting");
                    continue;
                }
                this.equipmentEnchantmentBlacklistSet.add(enchant);
            }
        }
        return this.equipmentEnchantmentBlacklistSet;
    }

    public void refreshConfig() {
        this.equipmentEnchantmentBlacklistSet = null;
    }
}

