/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util;

import meldexun.renderlib.util.Vec4;

public class Vec3 {
    public final float x;
    public final float y;
    public final float z;

    public Vec3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3(float[] data) {
        this(data[0], data[1], data[2]);
    }

    public Vec3 add(Vec3 other) {
        return new Vec3(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vec3 mult(float f) {
        return new Vec3(this.x * f, this.y * f, this.z * f);
    }

    public Vec3 cross(Vec3 other) {
        return new Vec3(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public Vec3 cross(Vec4 other) {
        return new Vec3(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public float dot(Vec3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vec3 normalize() {
        return this.mult(1.0f / this.length());
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSqr());
    }

    public float lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }
}

