/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import meldexun.matrixutil.Matrix4f;
import meldexun.memoryutil.UnsafeBufferUtil;
import meldexun.memoryutil.UnsafeFloatBuffer;
import meldexun.renderlib.RenderLib;
import meldexun.renderlib.config.RenderLibConfig;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL44;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.GLContext;

public class GLUtil {
    public static ContextCapabilities CAPS;
    private static final UnsafeFloatBuffer FLOAT_BUFFER;
    private static boolean blend;
    private static int blendSrcFactor;
    private static int blendDstFactor;
    private static int blendSrcFactorAlpha;
    private static int blendDstFactorAlpha;
    private static boolean depthTest;
    private static int depthFunc;
    private static boolean depthMask;
    private static boolean cull;
    private static int cullFace;
    private static boolean colorMaskRed;
    private static boolean colorMaskGreen;
    private static boolean colorMaskBlue;
    private static boolean colorMaskAlpha;

    public static void init() {
        CAPS = GLContext.getCapabilities();
        RenderLib.LOGGER.info("OpenGL Vendor: {}", (Object)GL11.glGetString((int)7936));
        RenderLib.LOGGER.info("OpenGL Renderer: {}", (Object)GL11.glGetString((int)7937));
        RenderLib.LOGGER.info("OpenGL Version: {}", (Object)GL11.glGetString((int)7938));
        if (!RenderLibConfig.openGLLogExtensions) {
            return;
        }
        RenderLib.LOGGER.info("OpenGL Extensions:");
        int longestExtensionName = GLUtil.streamExtensionFields().map(Field::getName).mapToInt(String::length).max().orElse(0);
        GLUtil.streamExtensionFields().forEach(field -> {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(field.getName());
                while (sb.length() < longestExtensionName + 1) {
                    sb.append(' ');
                }
                sb.append(field.getBoolean(CAPS));
                RenderLib.LOGGER.info((CharSequence)sb);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                RenderLib.LOGGER.error("Failed logging OpenGL extension with name '{}'", (Object)field.getName(), (Object)e);
            }
        });
    }

    private static Stream<Field> streamExtensionFields() {
        return Arrays.stream(ContextCapabilities.class.getFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> field.getType() == Boolean.TYPE);
    }

    public static UnsafeFloatBuffer getFloat(int pname) {
        GL11.glGetFloat((int)pname, (FloatBuffer)((FloatBuffer)FLOAT_BUFFER.getBuffer()));
        return FLOAT_BUFFER;
    }

    public static Matrix4f getMatrix(int matrix) {
        GL11.glGetFloat((int)matrix, (FloatBuffer)((FloatBuffer)FLOAT_BUFFER.getBuffer()));
        Matrix4f m = new Matrix4f();
        m.load(FLOAT_BUFFER.getAddress());
        return m;
    }

    public static void setMatrix(int uniform, Matrix4f matrix) {
        matrix.store(FLOAT_BUFFER.getAddress());
        GL20.glUniformMatrix4((int)uniform, (boolean)false, (FloatBuffer)((FloatBuffer)FLOAT_BUFFER.getBuffer()));
    }

    public static int createBuffer(long size, int flags, int usage) {
        if (GLUtil.CAPS.OpenGL45) {
            int buffer = GL45.glCreateBuffers();
            GL45.glNamedBufferStorage((int)buffer, (long)size, (int)flags);
            return buffer;
        }
        if (GLUtil.CAPS.OpenGL44) {
            int buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)buffer);
            GL44.glBufferStorage((int)34962, (long)size, (int)flags);
            GL15.glBindBuffer((int)34962, (int)0);
            return buffer;
        }
        int buffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)buffer);
        GL15.glBufferData((int)34962, (long)size, (int)usage);
        GL15.glBindBuffer((int)34962, (int)0);
        return buffer;
    }

    public static ByteBuffer map(int buffer, long length, int accessRange, int access, @Nullable ByteBuffer oldBuffer) {
        if (GLUtil.CAPS.OpenGL45) {
            return GL45.glMapNamedBufferRange((int)buffer, (long)0L, (long)length, (int)accessRange, (ByteBuffer)oldBuffer);
        }
        if (GLUtil.CAPS.OpenGL30) {
            if (!GLUtil.CAPS.OpenGL44) {
                accessRange &= 0xFFFFFF3F;
            }
            GL15.glBindBuffer((int)34962, (int)buffer);
            ByteBuffer byteBuffer = GL30.glMapBufferRange((int)34962, (long)0L, (long)length, (int)accessRange, (ByteBuffer)oldBuffer);
            GL15.glBindBuffer((int)34962, (int)0);
            return byteBuffer;
        }
        GL15.glBindBuffer((int)34962, (int)buffer);
        ByteBuffer byteBuffer = GL15.glMapBuffer((int)34962, (int)access, (long)length, (ByteBuffer)oldBuffer);
        GL15.glBindBuffer((int)34962, (int)0);
        return byteBuffer;
    }

    public static void unmap(int buffer) {
        if (GLUtil.CAPS.OpenGL45) {
            GL45.glUnmapNamedBuffer((int)buffer);
        } else {
            GL15.glBindBuffer((int)34962, (int)buffer);
            GL15.glUnmapBuffer((int)34962);
            GL15.glBindBuffer((int)34962, (int)0);
        }
    }

    public static void saveShaderGLState() {
        blend = GlStateManager.field_179157_e.field_179213_a.field_179201_b;
        blendSrcFactor = GlStateManager.field_179157_e.field_179211_b;
        blendDstFactor = GlStateManager.field_179157_e.field_179212_c;
        blendSrcFactorAlpha = GlStateManager.field_179157_e.field_179209_d;
        blendDstFactorAlpha = GlStateManager.field_179157_e.field_179210_e;
        depthTest = GlStateManager.field_179154_f.field_179052_a.field_179201_b;
        depthFunc = GlStateManager.field_179154_f.field_179051_c;
        depthMask = GlStateManager.field_179154_f.field_179050_b;
        cull = GlStateManager.field_179167_h.field_179054_a.field_179201_b;
        cullFace = GlStateManager.field_179167_h.field_179053_b;
        colorMaskRed = GlStateManager.field_179171_s.field_179188_a;
        colorMaskGreen = GlStateManager.field_179171_s.field_179186_b;
        colorMaskBlue = GlStateManager.field_179171_s.field_179187_c;
        colorMaskAlpha = GlStateManager.field_179171_s.field_179185_d;
    }

    public static void restoreShaderGLState() {
        if (blend) {
            GlStateManager.func_179147_l();
        } else {
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179120_a((int)blendSrcFactor, (int)blendDstFactor, (int)blendSrcFactorAlpha, (int)blendDstFactorAlpha);
        if (depthTest) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179143_c((int)depthFunc);
        GlStateManager.func_179132_a((boolean)depthMask);
        if (cull) {
            GlStateManager.func_179089_o();
        } else {
            GlStateManager.func_179129_p();
        }
        GlStateManager.func_179107_e((int)cullFace);
        GlStateManager.func_179135_a((boolean)colorMaskRed, (boolean)colorMaskGreen, (boolean)colorMaskBlue, (boolean)colorMaskAlpha);
    }

    static {
        FLOAT_BUFFER = UnsafeBufferUtil.allocateFloat(16L);
    }
}

