/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util;

import java.util.ArrayList;
import meldexun.matrixutil.Matrix4f;
import meldexun.renderlib.integration.Optifine;
import meldexun.renderlib.util.Vec3;
import meldexun.renderlib.util.Vec4;

public class Frustum {
    private final Vec4[] planes;
    private final double cameraX;
    private final double cameraY;
    private final double cameraZ;

    public Frustum(Matrix4f matrix, double cameraX, double cameraY, double cameraZ) {
        if (Optifine.isOptifineDetected() && Optifine.isShadowPass()) {
            matrix = Optifine.getProjectionMatrix().copy();
            matrix.multiply(Optifine.getModelViewMatrix());
            Vec3 lightPosition = Optifine.getShadowLightPositionVector();
            Vec4[] planes = new Vec4[]{new Vec4(matrix.m30 + matrix.m00, matrix.m31 + matrix.m01, matrix.m32 + matrix.m02, matrix.m33 + matrix.m03), new Vec4(matrix.m30 - matrix.m00, matrix.m31 - matrix.m01, matrix.m32 - matrix.m02, matrix.m33 - matrix.m03), new Vec4(matrix.m30 + matrix.m10, matrix.m31 + matrix.m11, matrix.m32 + matrix.m12, matrix.m33 + matrix.m13), new Vec4(matrix.m30 - matrix.m10, matrix.m31 - matrix.m11, matrix.m32 - matrix.m12, matrix.m33 - matrix.m13), new Vec4(matrix.m30 + matrix.m20, matrix.m31 + matrix.m21, matrix.m32 + matrix.m22, matrix.m33 + matrix.m23), new Vec4(matrix.m30 - matrix.m20, matrix.m31 - matrix.m21, matrix.m32 - matrix.m22, matrix.m33 - matrix.m23)};
            float[] distances = new float[]{planes[0].dot(lightPosition), planes[1].dot(lightPosition), planes[2].dot(lightPosition), planes[3].dot(lightPosition), planes[4].dot(lightPosition), planes[5].dot(lightPosition)};
            ArrayList<Vec4> list = new ArrayList<Vec4>();
            for (int i = 0; i < 6; ++i) {
                if (distances[i] < 0.0f) continue;
                list.add(planes[i]);
                if (!(distances[i] > 0.0f)) continue;
                for (int j = 2; j < 6; ++j) {
                    int k = ((i & 0xFFFFFFFE) + j) % planes.length;
                    if (distances[k] >= 0.0f) continue;
                    Vec4 plane1 = planes[i];
                    Vec4 plane2 = planes[k];
                    Vec3 v = plane1.cross(plane2);
                    Vec3 n = v.cross(lightPosition).normalize();
                    Vec3 p = v.cross(plane2).mult(plane1.w).add(plane1.cross(v).mult(plane2.w)).mult(1.0f / v.lengthSqr());
                    list.add(new Vec4(n.x, n.y, n.z, Math.abs(p.dot(n))));
                }
            }
            this.planes = list.toArray(new Vec4[list.size()]);
        } else {
            this.planes = new Vec4[6];
            this.planes[0] = new Vec4(matrix.m30 + matrix.m00, matrix.m31 + matrix.m01, matrix.m32 + matrix.m02, matrix.m33 + matrix.m03);
            this.planes[1] = new Vec4(matrix.m30 - matrix.m00, matrix.m31 - matrix.m01, matrix.m32 - matrix.m02, matrix.m33 - matrix.m03);
            this.planes[2] = new Vec4(matrix.m30 + matrix.m10, matrix.m31 + matrix.m11, matrix.m32 + matrix.m12, matrix.m33 + matrix.m13);
            this.planes[3] = new Vec4(matrix.m30 - matrix.m10, matrix.m31 - matrix.m11, matrix.m32 - matrix.m12, matrix.m33 - matrix.m13);
            this.planes[4] = new Vec4(matrix.m30 + matrix.m20, matrix.m31 + matrix.m21, matrix.m32 + matrix.m22, matrix.m33 + matrix.m23);
            this.planes[5] = new Vec4(matrix.m30 - matrix.m20, matrix.m31 - matrix.m21, matrix.m32 - matrix.m22, matrix.m33 - matrix.m23);
        }
        this.cameraX = cameraX;
        this.cameraY = cameraY;
        this.cameraZ = cameraZ;
    }

    public boolean isAABBInFrustum(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.isAABBInFrustum((float)(minX - this.cameraX), (float)(minY - this.cameraY), (float)(minZ - this.cameraZ), (float)(maxX - this.cameraX), (float)(maxY - this.cameraY), (float)(maxZ - this.cameraZ));
    }

    private boolean isAABBInFrustum(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        for (Vec4 plane : this.planes) {
            float f = plane.x * (plane.x >= 0.0f ? maxX : minX) + plane.y * (plane.y >= 0.0f ? maxY : minY);
            float f2 = plane.z;
            float f3 = plane.z >= 0.0f ? maxZ : minZ;
            if (!(f + f2 * f3 + plane.w < 0.0f)) continue;
            return false;
        }
        return true;
    }
}

