/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/teamwizardry/librarianlib/features/math/AllocationWindow;", "", "()V", "average", "", "getAverage", "()D", "times", "Lit/unimi/dsi/fastutil/longs/LongArrayFIFOQueue;", "getTimes", "()Lit/unimi/dsi/fastutil/longs/LongArrayFIFOQueue;", "values", "getValues", "windowSize", "", "getWindowSize", "()I", "setWindowSize", "(I)V", "sample", "", "value", "", "librarianlib-1.12.2"})
public final class AllocationWindow {
    private int windowSize = 5000;
    @NotNull
    private final LongArrayFIFOQueue values = new LongArrayFIFOQueue();
    @NotNull
    private final LongArrayFIFOQueue times = new LongArrayFIFOQueue();

    public final int getWindowSize() {
        return this.windowSize;
    }

    public final void setWindowSize(int n) {
        this.windowSize = n;
    }

    @NotNull
    public final LongArrayFIFOQueue getValues() {
        return this.values;
    }

    @NotNull
    public final LongArrayFIFOQueue getTimes() {
        return this.times;
    }

    public final void sample(long value) {
        long now = System.currentTimeMillis();
        long cutoff = now - (long)this.windowSize;
        while (!this.times.isEmpty() && this.times.firstLong() < cutoff) {
            this.times.dequeueLong();
            this.values.dequeueLong();
        }
        this.times.enqueue(now);
        this.values.enqueue(value);
    }

    public final double getAverage() {
        if (this.values.isEmpty()) {
            return 0.0;
        }
        long timeDelta = this.times.lastLong() - this.times.firstLong();
        if (timeDelta == 0L) {
            return 0.0;
        }
        long valueDelta = this.values.lastLong() - this.values.firstLong();
        return (double)((long)1000 * valueDelta) / (double)timeDelta;
    }
}

