/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.qualitytools.config;

import com.google.common.collect.HashMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.tmtravlr.qualitytools.QualityToolsMod;
import com.tmtravlr.qualitytools.config.CustomMaterial;
import com.tmtravlr.qualitytools.config.QualityEntry;
import com.tmtravlr.qualitytools.config.QualityItem;
import com.tmtravlr.qualitytools.config.QualityType;
import com.tmtravlr.qualitytools.network.SToCMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;

public class ConfigLoader {
    public static HashMap<String, QualityType> qualityTypes = new HashMap();
    public static File configFolder;
    public static Configuration config;
    public static String typeDeserializing;
    public static ArrayList<String> problems;
    public static SToCMessage reforgeMaterialPacket;
    public static HashMultimap<CustomMaterial, CustomMaterial> customReforgeMaterials;
    public static CustomMaterial universalReforgeItem;
    public static boolean useRepairItem;
    public static boolean allowStackableItems;
    public static boolean ignoreUnknownItems;

    public static void loadPreInit(FMLPreInitializationEvent event) {
        configFolder = new File(event.getSuggestedConfigurationFile().getParentFile(), "qualitytools");
        if (!configFolder.isDirectory()) {
            configFolder.mkdirs();
        }
        config = new Configuration(new File(configFolder, "general.cfg"));
    }

    public static void reloadConfigs() {
        qualityTypes.clear();
        universalReforgeItem = null;
        customReforgeMaterials.clear();
        problems.clear();
        ConfigLoader.reloadGeneralConfig();
        ConfigLoader.loadQualitites();
        ConfigLoader.loadCustomReforgingMaterials();
    }

    public static void reloadGeneralConfig() {
        config.load();
        useRepairItem = config.getBoolean("use repair item", "general", true, "If true, allows you to use repair items to reforge tools (like iron ingots with an iron sword).");
        allowStackableItems = config.getBoolean("allow stackable items", "general", false, "If true, allows qualities on stackable items. Could behave weirdly.");
        ignoreUnknownItems = config.getBoolean("ignore unknown items", "general", false, "If true, the config files will still load if there are items in them that don't exist (could\nbe useful if you want to add modded items that may not be present).");
        config.save();
    }

    public static void notifyProblems(EntityPlayer player) {
        TextComponentTranslation message = new TextComponentTranslation("message.qualitytoolsreload.problems", new Object[]{problems.size()});
        message.func_150256_b().func_150238_a(TextFormatting.RED);
        player.func_145747_a((ITextComponent)message);
        for (String problem : problems) {
            player.func_145747_a((ITextComponent)new TextComponentString(problem));
        }
        message = new TextComponentTranslation("message.qualitytoolsreload.problems.saved", new Object[0]);
        message.func_150256_b().func_150238_a(TextFormatting.RED);
        player.func_145747_a((ITextComponent)message);
        try {
            File problemFile = new File(configFolder, "problems.txt");
            if (!problemFile.exists()) {
                problemFile.createNewFile();
            }
            FileOutputStream output = new FileOutputStream(problemFile);
            OutputStreamWriter writer = new OutputStreamWriter(output);
            for (String problem : problems) {
                writer.write(problem + "\n");
            }
            writer.close();
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        problems.clear();
    }

    private static void loadQualitites() {
        if (configFolder == null) {
            return;
        }
        File qualitiesFolder = new File(configFolder, "Quailities");
        if (!qualitiesFolder.isDirectory()) {
            qualitiesFolder.mkdirs();
            ConfigLoader.createDefaultQualities(qualitiesFolder);
        }
        if (qualitiesFolder.listFiles().length > 0) {
            for (File file : qualitiesFolder.listFiles()) {
                typeDeserializing = file.getName();
                try {
                    InputStreamReader reader = new InputStreamReader(new FileInputStream(file));
                    Gson gson = new GsonBuilder().registerTypeAdapter(QualityType.class, (Object)new QualityType.Serializer()).registerTypeAdapter(QualityEntry.class, (Object)new QualityEntry.Serializer()).registerTypeAdapter(QualityItem.class, (Object)new QualityItem.Serializer()).create();
                    JsonParser parser = new JsonParser();
                    JsonElement rootElement = parser.parse((Reader)reader);
                    QualityType type = (QualityType)gson.fromJson(rootElement, QualityType.class);
                    qualityTypes.put(FilenameUtils.getBaseName((String)typeDeserializing), type);
                }
                catch (Exception e) {
                    FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"[Quality Tools] Problem while loading quality file %s. Skipping it.", (Object[])new Object[]{typeDeserializing});
                    problems.add(typeDeserializing + ": " + (e.getMessage() == null ? e.toString() : e.getMessage()));
                }
            }
        }
    }

    private static void createDefaultQualities(File qualitiesFolder) {
        try {
            FileUtils.writeStringToFile((File)new File(qualitiesFolder, "boots.json"), (String)"{\n    \"comment\": \"These qualities will apply for all boots! For more info\n                about how to edit this file and add more files, visit \n                https://bitbucket.org/Tmtravlr/qualitytools/wiki/Home\",\n    \n    \"slot\": \"feet\",\n    \"whitelist\": [\n      {\n        \"slot\": \"feet\"\n      }\n    ],\n    \"blacklist\": [\n    \n    ],\n    \"qualities\": [\n      {\n        \"name\": \"quality.crumbling.name\",\n        \"color\": \"dark_red\",\n        \"weight\": 8,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": -1.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.armorToughness\",\n            \"amount\": -1,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": -1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.dented.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": -1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.heavy.name\",\n        \"color\": \"red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"normal\",\n        \"weight\": 100\n      },\n      {\n        \"name\": \"quality.thick.name\",\n        \"color\": \"yellow\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.tough.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armorToughness\",\n            \"amount\": 1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.protective.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.arcane.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": 1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.tall.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.stepHeight\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.speedy.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": 0.1,\n\t\t\t   \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.masterful.name\",\n        \"color\": \"light_purple\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.armorToughness\",\n            \"amount\": 1,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"potioncore.stepHeight\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": 0.1,\n            \"operation\": 2\n          }\n        ]\n      }\n    ]\n}");
            FileUtils.writeStringToFile((File)new File(qualitiesFolder, "bows.json"), (String)"{\n    \"comment\": \"These qualities will apply for bows, and possibly for guns from\n                other mods if they extend the vanilla bow class. For more info\n                about how to edit this file and add more files, visit \n                https://bitbucket.org/Tmtravlr/qualitytools/wiki/Home\",\n    \n    \"slot\": [\n        \"mainhand\",\n        \"offhand\"\n    ],\n    \"whitelist\": [\n      {\n        \"class\": \"ItemBow\"\n      }\n    ],\n    \"blacklist\": [\n    \n    ],\n    \"qualities\": [\n      {\n        \"name\": \"quality.cracked.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.projectileDamage\",\n            \"amount\": -0.15,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.clumsy.name\",\n        \"color\": \"red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.projectileDamage\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"normal\",\n        \"weight\": 50\n      },\n      {\n        \"name\": \"quality.light.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.projectileDamage\",\n            \"amount\": 0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.powerful.name\",\n        \"color\": \"aqua\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.projectileDamage\",\n            \"amount\": 0.1,\n            \"operation\": 2\n          }\n        ]\n      }\n    ]\n}");
            FileUtils.writeStringToFile((File)new File(qualitiesFolder, "chestplates.json"), (String)"{\n    \"comment\": \"These qualities will apply for all chestplates, which also includes\n                the vanilla elytra. For more info about how to edit this file and\n                add more files, visit\n                https://bitbucket.org/Tmtravlr/qualitytools/wiki/Home\",\n    \n    \"slot\": \"chest\",\n    \"whitelist\": [\n      {\n        \"slot\": \"chest\"\n      }\n    ],\n    \"blacklist\": [\n    \n    ],\n    \"qualities\": [\n      {\n        \"name\": \"quality.crumbling.name\",\n        \"color\": \"dark_red\",\n        \"weight\": 8,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": -1.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.armorToughness\",\n            \"amount\": -1,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": -1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.cumbersome.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.digSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.dented.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": -1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.heavy.name\",\n        \"color\": \"red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"normal\",\n        \"weight\": 100\n      },\n      {\n        \"name\": \"quality.thick.name\",\n        \"color\": \"yellow\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.tough.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armorToughness\",\n            \"amount\": 1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.protective.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.arcane.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": 1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.solid.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.knockbackResistance\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.masterful.name\",\n        \"color\": \"light_purple\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.armorToughness\",\n            \"amount\": 1,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.knockbackResistance\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      }\n    ]\n}");
            FileUtils.writeStringToFile((File)new File(qualitiesFolder, "fishing rods.json"), (String)"{\n    \"comment\": \"These qualities will apply for all fishing rods! For more info\n                about how to edit this file and add more files, visit \n                https://bitbucket.org/Tmtravlr/qualitytools/wiki/Home\",\n    \n    \"slot\": [\n        \"mainhand\"\n    ],\n    \"whitelist\": [\n      {\n        \"class\": \"ItemFishingRod\"\n      }\n    ],\n    \"blacklist\": [\n    \n    ],\n    \"qualities\": [\n      {\n        \"name\": \"quality.unlucky.name\",\n        \"color\": \"red\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"generic.luck\",\n            \"amount\": -0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"normal\",\n        \"weight\": 50\n      },\n      {\n        \"name\": \"quality.lucky.name\",\n        \"color\": \"blue\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"generic.luck\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      }\n    ]\n}");
            FileUtils.writeStringToFile((File)new File(qualitiesFolder, "helmets.json"), (String)"{\n    \"comment\": \"These qualities will apply for all helmets! For more info\n                about how to edit this file and add more files, visit \n                https://bitbucket.org/Tmtravlr/qualitytools/wiki/Home\",\n    \n    \"slot\": \"head\",\n    \"whitelist\": [\n      {\n        \"slot\": \"head\"\n      }\n    ],\n    \"blacklist\": [\n    \n    ],\n    \"qualities\": [\n      {\n        \"name\": \"quality.crumbling.name\",\n        \"color\": \"dark_red\",\n        \"weight\": 8,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": -1.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.armorToughness\",\n            \"amount\": -1,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": -1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.dented.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": -1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.heavy.name\",\n        \"color\": \"red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"normal\",\n        \"weight\": 100\n      },\n      {\n        \"name\": \"quality.thick.name\",\n        \"color\": \"yellow\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.tough.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armorToughness\",\n            \"amount\": 1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.protective.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.arcane.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": 1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.lucky.name\",\n        \"color\": \"aqua\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.luck\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.masterful.name\",\n        \"color\": \"light_purple\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.armorToughness\",\n            \"amount\": 1,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.luck\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      }\n    ]\n}");
            FileUtils.writeStringToFile((File)new File(qualitiesFolder, "horse armor.json"), (String)"{\n    \"comment\": \"These qualities will apply for all horse armor. It may or may not\n                work with modded horse armor. If not, you can add the items manually.\n                For more info about how to edit this file and add more files, visit \n                https://bitbucket.org/Tmtravlr/qualitytools/wiki/Home\",\n    \n    \"slot\": \"horse\",\n    \"whitelist\": [\n      {\n        \"slot\": \"horse\"\n      }\n    ],\n    \"blacklist\": [\n    \n    ],\n    \"qualities\": [\n      {\n        \"name\": \"quality.crumbling.name\",\n        \"color\": \"dark_red\",\n        \"weight\": 8,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": -2,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": -1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.dented.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": -1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.heavy.name\",\n        \"color\": \"red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"normal\",\n        \"weight\": 100\n      },\n      {\n        \"name\": \"quality.thick.name\",\n        \"color\": \"yellow\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 2,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.protective.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 2,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.arcane.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": 1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.speedy.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": 0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.masterful.name\",\n        \"color\": \"light_purple\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 2,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": 0.1,\n            \"operation\": 2\n          }\n        ]\n      }\n    ]\n}");
            FileUtils.writeStringToFile((File)new File(qualitiesFolder, "leggings.json"), (String)"{\n    \"comment\": \"These qualities will apply for all leggings! For more info\n                about how to edit this file and add more files, visit \n                https://bitbucket.org/Tmtravlr/qualitytools/wiki/Home\",\n    \n    \"slot\": \"legs\",\n    \"whitelist\": [\n      {\n        \"slot\": \"legs\"\n      }\n    ],\n    \"blacklist\": [\n    \n    ],\n    \"qualities\": [\n      {\n        \"name\": \"quality.crumbling.name\",\n        \"color\": \"dark_red\",\n        \"weight\": 8,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": -1.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.armorToughness\",\n            \"amount\": -1,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": -1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.dented.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": -1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.heavy.name\",\n        \"color\": \"red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"normal\",\n        \"weight\": 100\n      },\n      {\n        \"name\": \"quality.thick.name\",\n        \"color\": \"yellow\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.tough.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armorToughness\",\n            \"amount\": 1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.protective.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.arcane.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": 1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.springy.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.jumpHeight\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.masterful.name\",\n        \"color\": \"light_purple\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.armorToughness\",\n            \"amount\": 1,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"potioncore.jumpHeight\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      }\n    ]\n}");
            FileUtils.writeStringToFile((File)new File(qualitiesFolder, "magic.json"), (String)"{\n    \"comment\": \"There aren't any magic weapons by default, but you can add\n                the items yourself here. For more info about how to edit \n                this file and add more files, visit \n                https://bitbucket.org/Tmtravlr/qualitytools/wiki/Home\",\n    \n    \"slot\": [\n        \"mainhand\",\n        \"offhand\"\n    ],\n    \"whitelist\": [\n    \n    ],\n    \"blacklist\": [\n    \n    ],\n    \"qualities\": [\n      {\n        \"name\": \"quality.inept.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.magicDamage\",\n            \"amount\": -0.15,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.ineffective.name\",\n        \"color\": \"red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.magicDamage\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"normal\",\n        \"weight\": 50\n      },\n      {\n        \"name\": \"quality.enhancing.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.magicDamage\",\n            \"amount\": 0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.mystical.name\",\n        \"color\": \"aqua\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.magicDamage\",\n            \"amount\": 0.1,\n            \"operation\": 2\n          }\n        ]\n      }\n    ]\n}");
            FileUtils.writeStringToFile((File)new File(qualitiesFolder, "shields.json"), (String)"{\n    \"comment\": \"These qualities will apply for all shields! For more info\n                about how to edit this file and add more files, visit \n                https://bitbucket.org/Tmtravlr/qualitytools/wiki/Home\",\n    \n    \"slot\": [\n        \"offhand\"\n    ],\n    \"whitelist\": [\n      {\n        \"class\": \"ItemShield\"\n      }\n    ],\n    \"blacklist\": [\n    \n    ],\n    \"qualities\": [\n      {\n        \"name\": \"quality.heavy.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"normal\",\n        \"weight\": 60\n      },\n      {\n        \"name\": \"quality.thick.name\",\n        \"color\": \"yellow\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.armor\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.arcane.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": 1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.solid.name\",\n        \"color\": \"blue\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"generic.knockbackResistance\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      }\n    ]\n}");
            FileUtils.writeStringToFile((File)new File(qualitiesFolder, "tools.json"), (String)"{\n    \"comment\": \"These qualities will apply for all basic weapons and\n                tools, including swords, pickaxes, axes, shovels, hoes, \n                and shears! For more info about how to edit this file \n                and add more files, visit \n                https://bitbucket.org/Tmtravlr/qualitytools/wiki/Home\",\n    \n    \"slot\": \"mainhand\",\n    \"whitelist\": [\n      {\n        \"class\": \"ItemTool\"\n      },\n      {\n        \"class\": \"ItemHoe\"\n      },\n      {\n        \"class\": \"ItemShears\"\n      },\n      {\n        \"class\": \"ItemSword\"\n      }\n    ],\n    \"blacklist\": [\n    \n    ],\n    \"qualities\": [\n      {\n        \"name\": \"quality.worthless.name\",\n        \"color\": \"dark_red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.digSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"generic.reachDistance\",\n            \"amount\": -1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.broken.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": -0.15,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.bulky.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": -0.15,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.digSpeed\",\n            \"amount\": -0.15,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.rusted.name\",\n        \"color\": \"red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.digSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.clumsy.name\",\n        \"color\": \"red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.digSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.chipped.name\",\n        \"color\": \"red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.short.name\",\n        \"color\": \"red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.reachDistance\",\n            \"amount\": -1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"normal\",\n        \"weight\": 100\n      },\n      {\n        \"name\": \"quality.broad.name\",\n        \"color\": \"yellow\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": 0.1,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.digSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.thin.name\",\n        \"color\": \"yellow\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": 0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.pokey.name\",\n        \"color\": \"yellow\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": 0.05,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.digSpeed\",\n            \"amount\": -0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.vicious.name\",\n        \"color\": \"yellow\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": 0.15,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"generic.reachDistance\",\n            \"amount\": -0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.long.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.reachDistance\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.sharp.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": 0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.keen.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": 0.1,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": 0.1,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.graceful.name\",\n        \"color\": \"aqua\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.digSpeed\",\n            \"amount\": 0.15,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": 0.15,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.sweeping.name\",\n        \"color\": \"aqua\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.reachDistance\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": 0.2,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.legendary.name\",\n        \"color\": \"light_purple\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": 0.15,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.digSpeed\",\n            \"amount\": 0.1,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"generic.reachDistance\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": 0.1,\n            \"operation\": 2\n          }\n        ]\n      }\n    ]\n}");
            FileUtils.writeStringToFile((File)new File(qualitiesFolder, "trinkets.json"), (String)"{\n    \"comment\": \"These qualities will apply for anything that can go \n                in baubles slots, and also the totem of undying (which can\n                be held in the offhand slot). For more info about how to\n                edit this file and add more files, visit \n                https://bitbucket.org/Tmtravlr/qualitytools/wiki/Home\",\n    \n    \"slot\": [\n        \"baubles_trinket\",\n        \"offhand\"\n    ],\n    \"whitelist\": [\n      {\n        \"slot\": \"baubles_trinket\"\n      },\n      {\n        \"item\": \"qualitytools:emerald_ring\"\n      },\n      {\n        \"item\": \"qualitytools:emerald_amulet\"\n      },\n      {\n        \"item\": \"minecraft:totem_of_undying\"\n      }\n    ],\n    \"blacklist\": [\n    \n    ],\n    \"qualities\": [\n      {\n        \"name\": \"quality.horrible.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.projectileDamage\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.magicDamage\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.clunky.name\",\n        \"color\": \"dark_gray\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.digSpeed\",\n            \"amount\": -0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.unlucky.name\",\n        \"color\": \"red\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.luck\",\n            \"amount\": -0.2,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"normal\",\n        \"weight\": 100\n      },\n      {\n        \"name\": \"quality.lucky.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.luck\",\n            \"amount\": 0.2,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.healthy.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.maxHealth\",\n            \"amount\": 2,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.armored.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.damageResistance\",\n            \"amount\": 0.03,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.speedy.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": 0.05,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.springy.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.jumpHeight\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.prospecting.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.digSpeed\",\n            \"amount\": 0.03,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.flailing.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": 0.03,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.shielding.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": 1,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.focusing.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.magicDamage\",\n            \"amount\": 0.03,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.aiming.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"potioncore.projectileDamage\",\n            \"amount\": 0.03,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.strengthening.name\",\n        \"color\": \"blue\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": 0.03,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.graceful.name\",\n        \"color\": \"aqua\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackSpeed\",\n            \"amount\": 0.03,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.digSpeed\",\n            \"amount\": 0.03,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.athletic.name\",\n        \"color\": \"aqua\",\n        \"weight\": 10,\n        \"attributes\": [\n          {\n            \"name\": \"generic.movementSpeed\",\n            \"amount\": 0.05,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.jumpHeight\",\n            \"amount\": 0.5,\n            \"operation\": 0\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.punishing.name\",\n        \"color\": \"light_purple\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"generic.attackDamage\",\n            \"amount\": 0.03,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.projectileDamage\",\n            \"amount\": 0.03,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.magicDamage\",\n            \"amount\": 0.03,\n            \"operation\": 2\n          }\n        ]\n      },\n      {\n        \"name\": \"quality.undying.name\",\n        \"color\": \"light_purple\",\n        \"weight\": 5,\n        \"attributes\": [\n          {\n            \"name\": \"generic.maxHealth\",\n            \"amount\": 2,\n            \"operation\": 0\n          },\n          {\n            \"name\": \"potioncore.damageResistance\",\n            \"amount\": 0.03,\n            \"operation\": 2\n          },\n          {\n            \"name\": \"potioncore.magicShielding\",\n            \"amount\": 1,\n            \"operation\": 0\n          }\n        ]\n      }\n    ]\n}");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadCustomReforgingMaterials() {
        if (configFolder == null || FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        File customReforgingFile = new File(configFolder, "reforging materials.json");
        if (!customReforgingFile.exists()) {
            try {
                FileUtils.writeStringToFile((File)customReforgingFile, (String)"[\n  {\n    \"comment\": \"This file contains custom reforging materials. By default, you can reforge\n                a tool with its repair item (like iron ingots for an iron sword), but some\n                items don't have a repair item, like bows. This adds items to reforge those.\n                It can also add an item for 'any', which will work for any item that can't be\n                reforged otherwise. For more info about how to add materials, visit:\n                https://bitbucket.org/Tmtravlr/qualitytools/wiki/Home\",\n    \"tool\": \"any\",\n    \"material\": {\n        \"item\": \"minecraft:nether_star\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"minecraft:bow\"\n    },\n    \"material\": {\n        \"ore_dict\": \"plankWood\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"minecraft:fishing_rod\"\n    },\n    \"material\": {\n        \"ore_dict\": \"plankWood\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"minecraft:wooden_hoe\"\n    },\n    \"material\": {\n        \"ore_dict\": \"plankWood\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"minecraft:stone_hoe\"\n    },\n    \"material\": {\n        \"ore_dict\": \"cobblestone\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"minecraft:iron_hoe\"\n    },\n    \"material\": {\n        \"ore_dict\": \"ingotIron\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"minecraft:shears\"\n    },\n    \"material\": {\n        \"ore_dict\": \"ingotIron\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"minecraft:iron_horse_armor\"\n    },\n    \"material\": {\n        \"ore_dict\": \"ingotIron\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"minecraft:golden_hoe\"\n    },\n    \"material\": {\n        \"ore_dict\": \"ingotGold\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"minecraft:golden_horse_armor\"\n    },\n    \"material\": {\n        \"ore_dict\": \"ingotGold\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"minecraft:diamond_hoe\"\n    },\n    \"material\": {\n        \"ore_dict\": \"gemDiamond\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"minecraft:diamond_horse_armor\"\n    },\n    \"material\": {\n        \"ore_dict\": \"gemDiamond\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"qualitytools:emerald_ring\"\n    },\n    \"material\": {\n        \"ore_dict\": \"gemEmerald\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"qualitytools:emerald_amulet\"\n    },\n    \"material\": {\n        \"ore_dict\": \"gemEmerald\"\n    }\n  },\n  {\n    \"tool\": {\n        \"item\": \"minecraft:totem_of_undying\"\n    },\n    \"material\": {\n        \"ore_dict\": \"gemEmerald\"\n    }\n  }\n]");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            NBTTagCompound packetInfo = new NBTTagCompound();
            NBTTagList materialInfoList = new NBTTagList();
            InputStreamReader reader = new InputStreamReader(new FileInputStream(customReforgingFile));
            Gson gson = new GsonBuilder().registerTypeAdapter(CustomMaterial.class, (Object)new CustomMaterial.Serializer()).create();
            JsonParser parser = new JsonParser();
            JsonElement rootElement = parser.parse((Reader)reader);
            if (!rootElement.isJsonArray()) {
                throw new JsonParseException("Expected reforging materials.json to contain a list.");
            }
            for (JsonElement jsonElement : rootElement.getAsJsonArray()) {
                NBTTagCompound toolInfo = new NBTTagCompound();
                JsonObject json = JsonUtils.func_151210_l((JsonElement)jsonElement, (String)"");
                JsonObject materialJson = JsonUtils.func_152754_s((JsonObject)json, (String)"material");
                CustomMaterial material = (CustomMaterial)gson.fromJson((JsonElement)materialJson, CustomMaterial.class);
                if (material != null) {
                    CustomMaterial tool;
                    if (json.get("tool").isJsonObject()) {
                        JsonObject toolJson = JsonUtils.func_152754_s((JsonObject)json, (String)"tool");
                        tool = (CustomMaterial)gson.fromJson((JsonElement)toolJson, CustomMaterial.class);
                        if (tool != null) {
                            toolInfo.func_74782_a("Tool", (NBTBase)tool.writeToNBT(new NBTTagCompound()));
                            toolInfo.func_74782_a("Material", (NBTBase)material.writeToNBT(new NBTTagCompound()));
                        }
                    } else {
                        String itemName = JsonUtils.func_151200_h((JsonObject)json, (String)"tool");
                        if (itemName.equalsIgnoreCase("any")) {
                            packetInfo.func_74782_a("Universal", (NBTBase)material.writeToNBT(new NBTTagCompound()));
                        } else {
                            tool = new CustomMaterial();
                            tool.item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName));
                            if (tool.item != null) {
                                tool.meta = Short.MAX_VALUE;
                                toolInfo.func_74782_a("Tool", (NBTBase)tool.writeToNBT(new NBTTagCompound()));
                                toolInfo.func_74782_a("Material", (NBTBase)material.writeToNBT(new NBTTagCompound()));
                            } else if (ignoreUnknownItems) {
                                FMLLog.warning((String)"[Quality Tools] Unknown item %s in reforging materials.json. Ignoring.", (Object[])new Object[]{itemName});
                            } else {
                                throw new JsonParseException("Unknown item " + itemName);
                            }
                        }
                    }
                }
                if (toolInfo.func_82582_d()) continue;
                materialInfoList.func_74742_a((NBTBase)toolInfo);
            }
            if (materialInfoList.func_74745_c() > 0) {
                packetInfo.func_74782_a("Materials", (NBTBase)materialInfoList);
            }
            if (!packetInfo.func_82582_d()) {
                ConfigLoader.loadReforgingToolsFromNBT(packetInfo);
                PacketBuffer out = new PacketBuffer(Unpooled.buffer());
                out.writeInt(1);
                out.func_150786_a(packetInfo);
                reforgeMaterialPacket = new SToCMessage((ByteBuf)out);
                ConfigLoader.sendReforgingMaterialsToClient(null);
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"[Quality Tools] Problem while loading reforging materials.", (Object[])new Object[0]);
            problems.add("reforging materials.json: " + (e.getMessage() == null ? e.toString() : e.getMessage()));
        }
    }

    public static void loadReforgingToolsFromNBT(NBTTagCompound packetTag) {
        if (packetTag.func_74764_b("Universal")) {
            universalReforgeItem = new CustomMaterial().readFromNBT(packetTag.func_74775_l("Universal"));
        }
        if (packetTag.func_74764_b("Materials")) {
            NBTTagList tagList = packetTag.func_150295_c("Materials", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound materialTag = tagList.func_150305_b(i);
                CustomMaterial material = null;
                CustomMaterial tool = null;
                if (materialTag.func_74764_b("Material")) {
                    material = new CustomMaterial().readFromNBT(materialTag.func_74775_l("Material"));
                }
                if (materialTag.func_74764_b("Tool")) {
                    tool = new CustomMaterial().readFromNBT(materialTag.func_74775_l("Tool"));
                }
                if (material == null || tool == null) continue;
                customReforgeMaterials.put((Object)tool, (Object)material);
            }
        }
    }

    public static void sendReforgingMaterialsToClient(EntityPlayerMP player) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() != null && reforgeMaterialPacket != null) {
            if (player != null) {
                QualityToolsMod.networkWrapper.sendTo((IMessage)reforgeMaterialPacket, player);
            } else if (FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al() != null) {
                QualityToolsMod.networkWrapper.sendToAll((IMessage)reforgeMaterialPacket);
            }
        }
    }

    static {
        problems = new ArrayList();
        customReforgeMaterials = HashMultimap.create();
    }
}

