/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.expression;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.lib.expression.DynamicVariantList;
import org.orecruncher.lib.expression.Expression;
import org.orecruncher.lib.expression.IDynamicVariant;
import org.orecruncher.lib.expression.IVariant;
import org.orecruncher.lib.expression.LazyVariant;
import org.orecruncher.lib.expression.StringValue;
import org.orecruncher.lib.expression.Variant;
import org.orecruncher.lib.logging.ModLog;

public final class ExpressionCache {
    protected final ModLog logger;
    protected final List<IDynamicVariant> variants = new ArrayList<IDynamicVariant>();
    protected final Map<String, LazyVariant> cache = new Reference2ObjectOpenHashMap();
    protected final List<String> naughtyList = new ArrayList<String>();

    public ExpressionCache(@Nonnull ModLog logger) {
        this.logger = logger;
    }

    public void add(@Nonnull DynamicVariantList dvl) {
        this.variants.addAll(dvl.getList());
        Collections.sort(this.variants, (o1, o2) -> o1.getName().compareTo(o2.getName()));
    }

    @Nonnull
    public List<String> getNaughtyList() {
        return this.naughtyList;
    }

    @Nonnull
    public List<IDynamicVariant> getVariantList() {
        return new ArrayList<IDynamicVariant>(this.variants);
    }

    public void reset() {
        this.variants.forEach(IDynamicVariant::reset);
    }

    @Nonnull
    private LazyVariant compile(@Nonnull String expression) {
        LazyVariant exp = null;
        try {
            exp = this.cache.get(expression);
            if (exp == null) {
                Expression x = new Expression(expression);
                this.variants.forEach(v -> x.addVariable((Variant)((Object)v)));
                exp = x.getProgram();
                this.cache.put(expression, exp);
            }
        }
        catch (Throwable t) {
            this.naughtyList.add(expression);
            exp = new StringValue(t.getMessage());
            this.cache.put(expression, exp);
            this.logger.warn("Unable to compile [%s]: %s", expression, t.getMessage());
        }
        return exp;
    }

    @Nonnull
    public IVariant eval(@Nonnull String script) {
        return this.compile(script.intern()).eval();
    }

    public boolean check(@Nonnull String expression) {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return true;
        }
        return this.eval(expression).asBoolean();
    }
}

