/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.network;

import bettercombat.mod.util.Helpers;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketMainhandAttack
implements IMessage {
    private int entityId;
    private double motionX;
    private double motionY;
    private double motionZ;

    public PacketMainhandAttack() {
    }

    public PacketMainhandAttack(int parEntityId) {
        this.entityId = parEntityId;
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
    }

    public PacketMainhandAttack(int parEntityId, double motionX, double motionY, double motionZ) {
        this.entityId = parEntityId;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        this.motionX = buf.readDouble();
        this.motionY = buf.readDouble();
        this.motionZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.entityId, (int)4);
        buf.writeDouble(this.motionX);
        buf.writeDouble(this.motionY);
        buf.writeDouble(this.motionZ);
    }

    public static class Handler
    implements IMessageHandler<PacketMainhandAttack, IMessage> {
        public IMessage onMessage(PacketMainhandAttack message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> Handler.handle(message, ctx));
            return null;
        }

        private static void handle(PacketMainhandAttack message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Entity theEntity = player.field_70170_p.func_73045_a(message.entityId);
            if (theEntity != null) {
                if (player.field_71134_c.func_73081_b() == GameType.SPECTATOR) {
                    player.func_175399_e(theEntity);
                } else {
                    Helpers.attackTargetEntityItem((EntityPlayer)player, theEntity, false, message.motionX, message.motionY, message.motionZ);
                }
            }
            ((WorldServer)player.field_70170_p).func_73039_n().func_151247_a((Entity)player, (Packet)new SPacketAnimation((Entity)player, 0));
        }
    }
}

