/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.client.animation.util;

import bettercombat.mod.client.animation.AnimationChop;
import bettercombat.mod.client.animation.AnimationDig;
import bettercombat.mod.client.animation.AnimationPunch;
import bettercombat.mod.client.animation.AnimationStab;
import bettercombat.mod.client.animation.AnimationStabCaestus;
import bettercombat.mod.client.animation.AnimationSweep;
import bettercombat.mod.client.animation.AnimationSweep2;
import bettercombat.mod.client.animation.util.IAnimation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public enum AnimationEnum {
    SWEEP_COMBO(new AnimationSweep(), new AnimationSweep2()),
    SWEEP_1(new AnimationSweep()),
    SWEEP_2(new AnimationSweep2()),
    CHOP(new AnimationChop()),
    DIG(new AnimationDig()),
    STAB(new AnimationStab()),
    STAB_CAESTUS(new AnimationStabCaestus()),
    PUNCH(new AnimationPunch());

    private static final Random rand;
    private final List<IAnimation> animations = new ArrayList<IAnimation>();

    private AnimationEnum(IAnimation ... entries) {
        this.animations.addAll(Arrays.asList(entries));
    }

    public IAnimation getAnimation() {
        int index = 0;
        if (this.animations.size() > 1) {
            index = rand.nextInt(this.animations.size());
        }
        return this.animations.get(index);
    }

    static {
        rand = new Random();
    }
}

