/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.client.animation;

import bettercombat.mod.client.animation.AnimationSweep;
import bettercombat.mod.client.animation.util.BetterCombatHand;
import bettercombat.mod.client.handler.AnimationHandler;
import bettercombat.mod.client.handler.EventHandlersClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;

public class AnimationSweep2
extends AnimationSweep {
    @Override
    public void animationMainhand(boolean rightHanded, float swingProgress, float partialTick) {
        this.animateSwing(rightHanded, swingProgress, partialTick, EventHandlersClient.betterCombatMainhand);
    }

    @Override
    public void animationOffhand(boolean rightHanded, float swingProgress, float partialTick) {
        this.animateSwing(!rightHanded, swingProgress, partialTick, EventHandlersClient.betterCombatOffhand);
    }

    @Override
    public void setActive(BetterCombatHand hand) {
        hand.setSwingTimestampSound(0.4f);
        hand.moveRightVariance = hand.randomMoveVariance();
        hand.moveUpVariance = hand.randomMoveVariance();
        hand.moveCloseVariance = hand.randomMoveVariance();
        hand.rotateUpVariance = hand.randomPreciseRotationVariance();
        hand.rotateCounterClockwiseVariance = hand.randomRotationVariance();
        hand.rotateLeftVariance = hand.randomRotationVariance();
    }

    private void animateSwing(boolean rightHanded, float swingProgress, float partialTick, BetterCombatHand hand) {
        int i = rightHanded ? 1 : -1;
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = 0.0f;
        float rotateLeft = 0.0f;
        float closeCap = 1.0f - (AnimationHandler.lastTooCloseAmount + (AnimationHandler.tooCloseAmount - AnimationHandler.lastTooCloseAmount) * partialTick) * 2.5f;
        if (swingProgress > 0.2f) {
            if (swingProgress > 0.6f) {
                float energy = swingProgress - 0.6f;
                rotateCounterClockwise = energy * -400.0f;
                moveUp = 0.2f - energy * 0.5f;
                moveRight = -1.55f + energy * 30.0f;
                rotateLeft = 83.0f + energy * 12.5f;
                moveClose = -energy * 3.0f * closeCap;
            } else if (swingProgress > 0.4f) {
                float energy = swingProgress - 0.4f;
                moveUp = 0.2f;
                moveRight = -1.5f - energy * 0.25f;
                rotateLeft = 75.0f + energy * 40.0f;
                moveClose = (0.2f - energy) * closeCap;
            } else {
                float energy = swingProgress - 0.2f;
                moveUp = -0.2f + MathHelper.func_76126_a((float)(energy * (float)Math.PI * 2.5f)) * 0.4f;
                moveRight = -1.2f - MathHelper.func_76126_a((float)(energy * (float)Math.PI * 2.5f)) * 0.3f;
                rotateLeft = 25.0f + energy * 250.0f;
                moveClose = swingProgress * 0.5f * closeCap;
            }
        } else {
            moveUp = -swingProgress;
            moveRight = swingProgress * -6.0f;
            rotateLeft = swingProgress * 125.0f;
            moveClose = swingProgress * 0.5f * closeCap;
        }
        GlStateManager.func_179109_b((float)(0.75f * (float)i * moveRight * hand.moveRightVariance), (float)(1.15f * moveUp * hand.moveUpVariance), (float)(moveClose * hand.moveCloseVariance));
        GlStateManager.func_179114_b((float)(rotateUp * hand.rotateUpVariance), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)i * rotateCounterClockwise * hand.rotateCounterClockwiseVariance), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)i * rotateLeft * hand.rotateLeftVariance), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    @Override
    public float getCameraPitchMult() {
        return -0.5f;
    }

    @Override
    public float getCameraYawMult() {
        return 1.0f;
    }
}

