/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui;

import java.util.List;
import net.mcft.copy.backpacks.client.gui.Direction;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiLabel
extends GuiElementBase {
    public static final int SHADOW_DISABLED = -1;
    public static final int SHADOW_AUTOMATIC = -2;
    private String _text = "";
    private TextAlign _align = TextAlign.LEFT;
    private boolean _expands;
    private int _color = GuiElementBase.Color.WHITE;
    private int _disabledColor = -6250336;
    private int _shadowColor = -2;

    public GuiLabel(String text) {
        this(text, TextAlign.LEFT);
    }

    public GuiLabel(String text, TextAlign align) {
        this(0, 0, text, align);
    }

    public GuiLabel(int x, int y, String text) {
        this(x, y, text, TextAlign.LEFT);
    }

    public GuiLabel(int x, int y, String text, TextAlign align) {
        this._expands = true;
        this.setPosition(x, y);
        this.setText(text);
        this.setTextAlign(align);
    }

    public GuiLabel(int width, String text) {
        this(width, text, TextAlign.LEFT);
    }

    public GuiLabel(int width, String text, TextAlign align) {
        this(0, 0, width, text, align);
    }

    public GuiLabel(int x, int y, int width, String text) {
        this(x, y, width, LINE_HEIGHT, text, TextAlign.LEFT);
    }

    public GuiLabel(int x, int y, int width, String text, TextAlign align) {
        this(x, y, width, LINE_HEIGHT, text, align);
    }

    public GuiLabel(int x, int y, int width, int height, String text) {
        this(x, y, width, height, text, TextAlign.LEFT);
    }

    public GuiLabel(int x, int y, int width, int height, String text, TextAlign align) {
        this._expands = false;
        this.setPosition(x, y);
        this.setSize(width, height);
        this.setText(text);
        this.setTextAlign(align);
    }

    public boolean getExpands() {
        return this._expands;
    }

    public TextAlign getTextAlign() {
        return this._align;
    }

    public void setTextAlign(TextAlign value) {
        this._align = value;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException("Argument text can't be null");
        }
        if (text.equals(this._text)) {
            return;
        }
        this._text = text;
        if (this._expands) {
            FontRenderer fontRenderer = GuiLabel.getFontRenderer();
            int width = fontRenderer.func_78256_a(this._text);
            int height = fontRenderer.func_78267_b(this._text, Integer.MAX_VALUE);
            this.setSize(width, height);
            this._expands = true;
        }
    }

    public int getColor() {
        return this._color;
    }

    public void setColor(int value) {
        this._color = value;
    }

    public int getDisabledColor() {
        return this._disabledColor;
    }

    public void setDisabledColor(int value) {
        this._disabledColor = value;
    }

    public int getShadowColor() {
        return this._shadowColor;
    }

    public void setShadowColor(int value) {
        if (value < -2) {
            throw new IllegalArgumentException(String.format("'%d' is not a valid special shadow value", value));
        }
        this._shadowColor = value;
    }

    public void setShadowDisabled() {
        this.setShadowColor(-1);
    }

    @Override
    public void onSizeChanged(Direction direction) {
        super.onSizeChanged(direction);
        this._expands = false;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        if (!this.isVisible()) {
            return;
        }
        FontRenderer fontRenderer = GuiLabel.getFontRenderer();
        List lines = fontRenderer.func_78271_c(this._text, Integer.MAX_VALUE);
        int yPos = 1;
        for (String line : lines) {
            int lineWidth = fontRenderer.func_78256_a(line);
            if (!this._expands && lineWidth > this.getWidth()) {
                line = fontRenderer.func_78269_a(line, this.getWidth() - ELLIPSIS_WIDTH) + "...";
                lineWidth = fontRenderer.func_78256_a(line);
            }
            int xPos = 0;
            switch (this._align) {
                case LEFT: {
                    xPos = 0;
                    break;
                }
                case RIGHT: {
                    xPos = this.getWidth() - lineWidth;
                    break;
                }
                case CENTER: {
                    xPos = (this.getWidth() - lineWidth) / 2;
                }
            }
            int color = this.isEnabled() ? this.getColor() : this.getDisabledColor();
            int shadowColor = this.getShadowColor();
            if (shadowColor >= 0) {
                fontRenderer.func_78276_b(line, xPos + 1, yPos + 1, shadowColor);
            }
            if (shadowColor == -2) {
                fontRenderer.func_175063_a(line, (float)xPos, (float)yPos, color);
            } else {
                fontRenderer.func_78276_b(line, xPos, yPos, color);
            }
            yPos += LINE_HEIGHT;
        }
    }

    public static enum TextAlign {
        LEFT,
        RIGHT,
        CENTER;

    }
}

