/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui;

import java.util.Stack;
import net.mcft.copy.backpacks.client.gui.ElementInfo;
import net.mcft.copy.backpacks.client.gui.GuiContainerScreen;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiContext {
    public static boolean DEBUG = false;
    public static boolean DEBUG_TEXT = false;
    private GuiElementBase _focused;
    private GuiElementBase _pressed;
    private GuiContainerScreen _screen;
    private Stack<ScissorRegion> _scissorStack = new Stack();

    public GuiElementBase getFocused() {
        return this._focused;
    }

    void setFocused(GuiElementBase value) {
        this._focused = value;
    }

    public GuiElementBase getPressed() {
        return this._pressed;
    }

    void setPressed(GuiElementBase value) {
        this._pressed = value;
    }

    public GuiContainerScreen getScreen() {
        return this._screen;
    }

    void setScreen(GuiContainerScreen value) {
        this._screen = value;
    }

    public void pushScissor(GuiElementBase element, int x, int y, int width, int height) {
        ElementInfo info = ElementInfo.getElementHierarchy(element).getFirst();
        this.pushScissor(info.globalX + x, info.globalY + y, width, height);
    }

    public void pushScissor(int globalX, int globalY, int width, int height) {
        ScissorRegion region = !this._scissorStack.empty() ? this._scissorStack.peek().merge(globalX, globalY, width, height) : new ScissorRegion(globalX, globalY, width, height);
        this._scissorStack.push(region);
        this.setScissor(region);
    }

    public void popScissor() {
        this._scissorStack.pop();
        this.setScissor(!this._scissorStack.empty() ? this._scissorStack.peek() : null);
    }

    private void setScissor(ScissorRegion region) {
        if (region != null) {
            Minecraft mc = Minecraft.func_71410_x();
            int scale = new ScaledResolution(mc).func_78325_e();
            GL11.glScissor((int)(region.globalX * scale), (int)(mc.field_71440_d - (region.globalY + region.height) * scale), (int)(region.width * scale), (int)(region.height * scale));
            GL11.glEnable((int)3089);
        } else {
            GL11.glDisable((int)3089);
        }
    }

    private static class ScissorRegion {
        public final int globalX;
        public final int globalY;
        public final int width;
        public final int height;

        public ScissorRegion(int globalX, int globalY, int width, int height) {
            this.globalX = globalX;
            this.globalY = globalY;
            this.width = width;
            this.height = height;
        }

        public ScissorRegion merge(int globalX, int globalY, int width, int height) {
            return new ScissorRegion(Math.max(globalX, this.globalX), Math.max(globalY, this.globalY), Math.min(globalX + width, this.globalX + this.width) - Math.max(globalX, this.globalX), Math.min(globalY + height, this.globalY + this.height) - Math.max(globalY, this.globalY));
        }
    }
}

