/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.reskillable.playerexpansion.wrapper;

import codersafterdark.compatskills.utils.CheckMethods;
import codersafterdark.reskillable.api.skill.Skill;
import crafttweaker.annotations.ZenRegister;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="mods.compatskills.Skill")
@ZenRegister
public class CTSkill {
    final Skill skill;

    public CTSkill(Skill skill) {
        this.skill = skill;
    }

    @ZenGetter(value="key")
    @ZenMethod
    public String getKey() {
        return this.skill.getKey();
    }

    @ZenGetter(value="name")
    @ZenMethod
    public String getName() {
        return this.skill.getName();
    }

    @ZenGetter(value="backgroundLocation")
    @ZenMethod
    public String getBackgroundLocation() {
        return this.skill.getBackground().toString();
    }

    @ZenSetter(value="backgroundLocation")
    @ZenMethod
    public void setBackgroundLocation(String resourceLocation) {
        if (CheckMethods.checkResourceLocation(resourceLocation)) {
            this.skill.setBackground(new ResourceLocation(resourceLocation));
        }
    }

    @ZenGetter(value="cap")
    @ZenMethod
    public int getCap() {
        return this.skill.getCap();
    }

    @ZenSetter(value="cap")
    @ZenMethod
    public void setCap(int cap) {
        this.skill.getSkillConfig().setLevelCap(cap);
    }

    @ZenGetter(value="enabled")
    @ZenMethod
    public boolean getEnabled() {
        return this.skill.isEnabled();
    }

    @ZenSetter(value="enabled")
    @ZenMethod
    public void setEnabled(boolean enabled) {
        this.skill.getSkillConfig().setEnabled(enabled);
    }

    @ZenGetter(value="hidden")
    @ZenMethod
    public boolean isHidden() {
        return this.skill.isHidden();
    }

    @ZenSetter(value="hidden")
    @ZenMethod
    public void setHidden(boolean hidden) {
        this.skill.setHidden(hidden);
    }

    @ZenGetter(value="levelButton")
    @ZenMethod
    public boolean hasLevelButton() {
        return this.skill.hasLevelButton();
    }

    @ZenSetter(value="levelButton")
    @ZenMethod
    public void setLevelButton(boolean button) {
        this.skill.getSkillConfig().setLevelButton(button);
    }

    @ZenOperator(value=OperatorType.COMPARE)
    public int compareTo(CTSkill other) {
        return this.skill.compareTo(other.skill);
    }

    @ZenGetter(value="skillPointInterval")
    @ZenMethod
    public int getSkillPointInterval() {
        return this.skill.getSkillPointInterval();
    }

    @ZenSetter(value="skillPointInterval")
    @ZenMethod
    public void setSkillPointInterval(int amount) {
        this.skill.getSkillConfig().setSkillPointInterval(amount);
    }

    @ZenMethod
    public int getLevelUpCost(int level) {
        return this.skill.getLevelUpCost(level);
    }

    public Skill getSkill() {
        return this.skill;
    }

    @ZenGetter(value="baseLevelCost")
    @ZenMethod
    public int getBaseLevelCost() {
        return this.skill.getSkillConfig().getBaseLevelCost();
    }

    @ZenSetter(value="baseLevelCost")
    @ZenMethod
    public void setBaseLevelCost(int cost) {
        this.skill.getSkillConfig().setBaseLevelCost(cost);
    }

    @ZenGetter(value="levelStaggering")
    @ZenMethod
    public String[] getLevelStaggering() {
        ArrayList stagger = new ArrayList();
        this.skill.getSkillConfig().getLevelStaggering().forEach((key, value) -> stagger.add(key + "|" + value));
        return stagger.toArray(new String[0]);
    }

    @ZenSetter(value="levelStaggering")
    @ZenMethod
    public void setLevelStaggering(String[] stagger) {
        Map<Integer, Integer> configLevelStaggering = Arrays.stream(stagger).map(string -> string.split("\\|")).filter(array -> ((String[])array).length == 2).map(array -> Pair.of((Object)array[0], (Object)array[1])).map(pair -> Pair.of((Object)Integer.parseInt((String)pair.getKey()), (Object)Integer.parseInt((String)pair.getValue()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        HashMap<Integer, Integer> levelStaggering = new HashMap<Integer, Integer>();
        int lastLevel = this.skill.getSkillConfig().getBaseLevelCost();
        for (int i = 1; i < this.skill.getSkillConfig().getLevelCap(); ++i) {
            if (configLevelStaggering.containsKey(i)) {
                lastLevel = configLevelStaggering.get(i);
            }
            levelStaggering.put(i, lastLevel);
        }
        this.skill.getSkillConfig().setLevelStaggering(levelStaggering);
    }
}

