/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.betterquesting.gui;

import betterquesting.api2.client.gui.controls.IFieldFilter;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.input.Keyboard;

public class PanelScrollingStrings
extends CanvasScrolling
implements IPEventListener {
    private final GuiColorStatic red = new GuiColorStatic(255, 0, 0, 255);
    private final GuiColorStatic green = new GuiColorStatic(0, 255, 0, 255);
    private final int btnNew;
    private final int btnRemove;
    private Map<Integer, Row> requirements = new HashMap<Integer, Row>();
    private List<String> initialRequirements = new ArrayList<String>();
    private PanelButton add;
    private int width;
    private int index;

    public PanelScrollingStrings(IGuiRect rect, List<String> requirements, int btnNew, int btnRemove) {
        super(rect);
        this.btnNew = btnNew;
        this.btnRemove = btnRemove;
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        for (String req : requirements) {
            if (req.isEmpty()) continue;
            this.initialRequirements.add(req);
        }
        this.initialRequirements.add("");
    }

    public List<String> getRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        for (Row row : this.requirements.values()) {
            String req = (String)row.textBox.getValue();
            if (req.isEmpty()) continue;
            reqs.add(req);
        }
        return reqs;
    }

    public void initPanel() {
        super.initPanel();
        this.width = this.getTransform().getWidth();
        this.initialRequirements.forEach(this::addRow);
        this.shiftAdd();
    }

    private void redraw() {
        ArrayList<Object> reqs = new ArrayList<Object>();
        for (Row row : this.requirements.values()) {
            reqs.add(row.textBox.getValue());
            this.removePanel((IGuiPanel)row.textBox);
            this.removePanel((IGuiPanel)row.remove);
        }
        this.requirements.clear();
        this.index = 0;
        reqs.forEach(this::addRow);
        this.shiftAdd();
    }

    private void addRow(String line) {
        int i = this.requirements.size() + 1;
        int key = this.index++;
        PanelTextField text = new PanelTextField((IGuiRect)new GuiRectangle(0, i * 16, this.width - 32, 16), line, (IFieldFilter)FieldFilterString.INSTANCE);
        text.setMaxLength(Integer.MAX_VALUE);
        this.addPanel((IGuiPanel)text);
        PanelButtonStorage remove = new PanelButtonStorage((IGuiRect)new GuiRectangle(this.width - 16, i * 16, 16, 16), this.btnRemove, "x", (Object)key);
        remove.setTextHighlight(PresetColor.BTN_DISABLED.getColor(), (IGuiColor)this.red, (IGuiColor)this.red);
        this.addPanel((IGuiPanel)remove);
        this.requirements.put(key, new Row(text, remove));
    }

    private void shiftAdd() {
        if (this.add != null) {
            this.removePanel((IGuiPanel)this.add);
        }
        this.add = new PanelButton((IGuiRect)new GuiRectangle(this.width - 32, this.requirements.size() * 16, 16, 16), this.btnNew, "+");
        this.add.setTextHighlight(PresetColor.BTN_DISABLED.getColor(), (IGuiColor)this.green, (IGuiColor)this.green);
        this.addPanel((IGuiPanel)this.add);
    }

    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == this.btnNew) {
            this.addRow("");
            this.shiftAdd();
        } else if (btn.getButtonID() == this.btnRemove) {
            int key = (Integer)((PanelButtonStorage)btn).getStoredValue();
            Row row = this.requirements.get(key);
            if (this.requirements.size() == 1) {
                row.textBox.setText("");
            } else {
                this.removePanel((IGuiPanel)row.remove);
                this.removePanel((IGuiPanel)row.textBox);
                this.requirements.remove(key);
                this.redraw();
            }
        }
    }

    private class Row {
        private PanelTextField<String> textBox;
        private PanelButtonStorage<Integer> remove;

        private Row(PanelTextField<String> textBox, PanelButtonStorage<Integer> remove) {
            this.textBox = textBox;
            this.remove = remove;
        }
    }
}

