/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.trigger;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.spawner.Spawner;
import com.lycanitesmobs.core.spawner.trigger.BlockSpawnTrigger;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OreBlockSpawnTrigger
extends BlockSpawnTrigger {
    public boolean ores = true;
    public boolean gems = false;

    public OreBlockSpawnTrigger(Spawner spawner) {
        super(spawner);
    }

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        if (json.has("ores")) {
            this.ores = json.get("ores").getAsBoolean();
        }
        if (json.has("gems")) {
            this.gems = json.get("gems").getAsBoolean();
        }
    }

    @Override
    public boolean isTriggerBlock(IBlockState blockState, World world, BlockPos blockPos, int fortune) {
        String[] blockNameParts;
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150418_aU) {
            return this.ores;
        }
        if (block == Blocks.field_150365_q) {
            return this.ores;
        }
        if (block.getRegistryName() == null) {
            return false;
        }
        String blockName = block.getRegistryName().func_110623_a();
        for (String blockNamePart : blockNameParts = blockName.split("\\.")) {
            int blockNamePartLength = blockNamePart.length();
            boolean nameMatch = false;
            if (blockNamePartLength >= 3 && (blockNamePart.substring(0, 3).equalsIgnoreCase("ore") || blockNamePart.substring(blockNamePartLength - 3, blockNamePartLength).equalsIgnoreCase("ore"))) {
                nameMatch = true;
            }
            if (!nameMatch && blockNamePartLength >= 7 && (blockNamePart.substring(0, 7).equalsIgnoreCase("crystal") || blockNamePart.substring(blockNamePartLength - 7, blockNamePartLength).equalsIgnoreCase("crystal"))) {
                nameMatch = true;
            }
            if (!nameMatch) continue;
            if (this.ores && this.gems) {
                return true;
            }
            Item dropItem = block.func_180660_a(blockState, world.field_73012_v, fortune);
            if (dropItem instanceof ItemBlock || blockName.contains("coal")) {
                return this.ores;
            }
            return this.gems;
        }
        return false;
    }

    @Override
    public int getBlockLevel(IBlockState blockState, World world, BlockPos blockPos) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150482_ag) {
            return 3;
        }
        if (block == Blocks.field_150412_bA) {
            return 3;
        }
        if (block == Blocks.field_150369_x) {
            return 2;
        }
        if (block == Blocks.field_150352_o) {
            return 2;
        }
        if (block == Blocks.field_150366_p) {
            return 1;
        }
        return 0;
    }
}

